/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.writer;

import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.liferay.batch.engine.csv.ColumnDescriptor;
import com.liferay.batch.engine.csv.ColumnDescriptorProvider;
import com.liferay.batch.engine.internal.writer.ItemClassIndexUtil;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CSVUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ColumnValuesExtractor {
    private static final Log _log = LogFactoryUtil.getLog(ColumnValuesExtractor.class);
    private final ColumnDescriptor[] _columnDescriptors;

    public ColumnValuesExtractor(ColumnDescriptorProvider columnDescriptorProvider, long companyId, Map<String, ObjectValuePair<Field, Method>> fieldNameObjectValuePairs, List<String> fieldNames, String taskItemDelegateName) throws PortalException {
        this._columnDescriptors = this._getColumnDescriptors(columnDescriptorProvider, companyId, fieldNameObjectValuePairs, fieldNames, 0, null, taskItemDelegateName);
    }

    public List<Object[]> extractValues(Object item) throws ReflectiveOperationException {
        ArrayList<Object[]> valuesList = new ArrayList<Object[]>();
        Object[] values = this._getBlankValues(this._columnDescriptors.length);
        ArrayList<ColumnDescriptor> childFieldColumnDescriptors = new ArrayList<ColumnDescriptor>();
        for (ColumnDescriptor columnDescriptor : this._columnDescriptors) {
            if (columnDescriptor.isChild()) {
                childFieldColumnDescriptors.add(columnDescriptor);
                continue;
            }
            values[columnDescriptor.getIndex()] = columnDescriptor.getValue(item);
        }
        valuesList.add(values);
        int hash = -1;
        for (ColumnDescriptor childFieldColumnDescriptor : childFieldColumnDescriptors) {
            if (hash != childFieldColumnDescriptor.getParentHashCode()) {
                hash = childFieldColumnDescriptor.getParentHashCode();
                values = this._getBlankValues(this._columnDescriptors.length);
                valuesList.add(values);
            }
            values[childFieldColumnDescriptor.getIndex()] = childFieldColumnDescriptor.getValue(item);
        }
        return valuesList;
    }

    public String[] getHeaders() {
        String[] headers = new String[this._columnDescriptors.length];
        for (ColumnDescriptor columnDescriptor : this._columnDescriptors) {
            headers[columnDescriptor.getIndex()] = columnDescriptor.getHeader();
        }
        return headers;
    }

    private <T> T[] _combine(T[] array1, T[] array2, int index) {
        Class<?> array1Class = array1.getClass();
        Object[] newArray = (Object[])Array.newInstance(array1Class.getComponentType(), array1.length + array2.length - 1);
        System.arraycopy(array1, 0, newArray, 0, array1.length);
        System.arraycopy(array2, 0, newArray, index, array2.length);
        return newArray;
    }

    private Object[] _getBlankValues(int size) {
        Object[] objects = new Object[size];
        Arrays.fill(objects, "");
        return objects;
    }

    private ColumnDescriptor[] _getColumnDescriptors(ColumnDescriptorProvider columnDescriptorProvider, long companyId, Map<String, ObjectValuePair<Field, Method>> fieldNameObjectValuePairs, Collection<String> fieldNames, int masterIndex, ColumnDescriptor parentColumnDescriptor, String taskItemDelegateName) throws PortalException {
        ColumnDescriptor[] columnDescriptors = new ColumnDescriptor[fieldNames.size()];
        int localIndex = 0;
        for (String fieldName : fieldNames) {
            ObjectValuePair<Field, Method> objectValuePair = fieldNameObjectValuePairs.get(fieldName);
            if (objectValuePair == null) {
                ColumnDescriptor[] fieldColumnDescriptors = columnDescriptorProvider.getColumnDescriptors(companyId, fieldName, masterIndex, fieldNameObjectValuePairs.get("properties"), taskItemDelegateName);
                columnDescriptors = this._combine(columnDescriptors, fieldColumnDescriptors, localIndex);
                masterIndex += fieldColumnDescriptors.length;
                localIndex += fieldColumnDescriptors.length;
                continue;
            }
            Field field = (Field)objectValuePair.getKey();
            columnDescriptors[localIndex] = ColumnDescriptor.from((Field)field, (String)field.getName(), (int)masterIndex++, (Method)((Method)objectValuePair.getValue()), (ColumnDescriptor)parentColumnDescriptor, this._getPOJOFieldUnsafeFunction(fieldNameObjectValuePairs.get(fieldName)));
            Class<?> fieldClass = field.getType();
            if (ItemClassIndexUtil.isMap(fieldClass) || ItemClassIndexUtil.isSingleColumnAdoptableArray(fieldClass) || ItemClassIndexUtil.isSingleColumnAdoptableValue(fieldClass)) {
                ++localIndex;
                continue;
            }
            if (ItemClassIndexUtil.isIterable(fieldClass)) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Mapping collection of ", fieldClass.getDeclaredClasses(), " to a single column may not contain all data"}));
                }
                ++localIndex;
                continue;
            }
            Map<String, ObjectValuePair<Field, Method>> childFieldMethodPairsMap = ItemClassIndexUtil.index(fieldClass);
            ColumnDescriptor[] childFieldColumnDescriptors = this._getColumnDescriptors(columnDescriptorProvider, companyId, childFieldMethodPairsMap, this._sort(childFieldMethodPairsMap.keySet()), localIndex, columnDescriptors[localIndex], taskItemDelegateName);
            columnDescriptors = this._combine(columnDescriptors, childFieldColumnDescriptors, localIndex);
            masterIndex = this._getLastMasterIndex(childFieldColumnDescriptors) + 1;
            localIndex += childFieldColumnDescriptors.length;
        }
        return columnDescriptors;
    }

    private int _getLastMasterIndex(ColumnDescriptor[] columnDescriptors) {
        ColumnDescriptor columnDescriptor = columnDescriptors[columnDescriptors.length - 1];
        return columnDescriptor.getIndex();
    }

    private UnsafeFunction<Object, Object, ReflectiveOperationException> _getPOJOFieldUnsafeFunction(final ObjectValuePair<Field, Method> objectValuePair) {
        Field field = (Field)objectValuePair.getKey();
        Class<?> fieldClass = field.getType();
        if (ItemClassIndexUtil.isSingleColumnAdoptableValue(fieldClass)) {
            if (ItemClassIndexUtil.isDate(fieldClass)) {
                ISO8601DateFormat dateFormat = new ISO8601DateFormat();
                return new UnsafeFunction<Object, Object, ReflectiveOperationException>((DateFormat)dateFormat){
                    final /* synthetic */ DateFormat val$dateFormat;
                    {
                        this.val$dateFormat = dateFormat;
                    }

                    public Object apply(Object object) throws ReflectiveOperationException {
                        Object value = ColumnValuesExtractor.this._getValue(object, (ObjectValuePair<Field, Method>)objectValuePair);
                        if (value == null) {
                            return "";
                        }
                        return this.val$dateFormat.format(value);
                    }
                };
            }
            return new UnsafeFunction<Object, Object, ReflectiveOperationException>(){

                public Object apply(Object object) throws ReflectiveOperationException {
                    Object value = ColumnValuesExtractor.this._getValue(object, (ObjectValuePair<Field, Method>)objectValuePair);
                    if (value == null) {
                        return "";
                    }
                    return value;
                }
            };
        }
        if (ItemClassIndexUtil.isSingleColumnAdoptableArray(fieldClass)) {
            return new UnsafeFunction<Object, Object, ReflectiveOperationException>(){

                public Object apply(Object object) throws ReflectiveOperationException {
                    Object value = ColumnValuesExtractor.this._getValue(object, (ObjectValuePair<Field, Method>)objectValuePair);
                    if (value == null) {
                        return "";
                    }
                    return StringUtil.merge((Object[])((Object[])value), CSVUtil::encode, (String)",");
                }
            };
        }
        if (ItemClassIndexUtil.isMap(fieldClass)) {
            return new UnsafeFunction<Object, Object, ReflectiveOperationException>(){

                public Object apply(Object object) throws ReflectiveOperationException {
                    Map map = (Map)ColumnValuesExtractor.this._getValue(object, (ObjectValuePair<Field, Method>)objectValuePair);
                    if (map == null) {
                        return "";
                    }
                    StringBundler sb = new StringBundler(map.size() * 3);
                    Set entries = map.entrySet();
                    Iterator iterator = entries.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        sb.append(CSVUtil.encode(entry.getKey()));
                        sb.append(":");
                        if (entry.getValue() != null) {
                            sb.append(CSVUtil.encode(entry.getValue()));
                        } else {
                            sb.append("");
                        }
                        if (!iterator.hasNext()) continue;
                        sb.append(", ");
                    }
                    return sb.toString();
                }
            };
        }
        return new UnsafeFunction<Object, Object, ReflectiveOperationException>(){

            public Object apply(Object object) throws ReflectiveOperationException {
                if (ColumnValuesExtractor.this._getValue(object, (ObjectValuePair<Field, Method>)objectValuePair) == null) {
                    return "";
                }
                return CSVUtil.encode((Object)object);
            }
        };
    }

    private Object _getValue(Object object, ObjectValuePair<Field, Method> objectValuePair) throws ReflectiveOperationException {
        Method method = (Method)objectValuePair.getValue();
        if (method == null) {
            Field field = (Field)objectValuePair.getKey();
            return field.get(object);
        }
        return method.invoke(object, new Object[0]);
    }

    private Collection<String> _sort(Collection<String> collection) {
        return ListUtil.sort(new ArrayList<String>(collection), (value1, value2) -> value1.compareToIgnoreCase((String)value2));
    }
}

