/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.bundle;

import com.liferay.batch.engine.internal.unit.MultiCompanyBatchEngineUnitProcessor;
import com.liferay.batch.engine.unit.BatchEngineUnit;
import com.liferay.batch.engine.unit.BatchEngineUnitMetaInfo;
import com.liferay.batch.engine.unit.BatchEngineUnitProcessor;
import com.liferay.batch.engine.unit.BatchEngineUnitReader;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(service={})
public class BatchEngineBundleTracker {
    @Reference
    private BatchEngineUnitProcessor _batchEngineUnitProcessor;
    @Reference
    private BatchEngineUnitReader _batchEngineUnitReader;
    private BundleTracker<Bundle> _bundleTracker;
    @Reference(target="(module.service.lifecycle=portlets.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private MultiCompanyBatchEngineUnitProcessor _multiCompanyBatchEngineUnitProcessor;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._bundleTracker = new BundleTracker(bundleContext, 32, (BundleTrackerCustomizer)new BatchEngineBundleTrackerCustomizer());
        this._bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
    }

    private class BatchEngineBundleTrackerCustomizer
    implements BundleTrackerCustomizer<Bundle> {
        private BatchEngineBundleTrackerCustomizer() {
        }

        public Bundle addingBundle(Bundle bundle, BundleEvent bundleEvent) {
            Dictionary headers = bundle.getHeaders("");
            if (headers.get("Liferay-Client-Extension-Batch") == null) {
                return null;
            }
            Collection batchEngineUnits = BatchEngineBundleTracker.this._batchEngineUnitReader.getBatchEngineUnits(bundle);
            if (batchEngineUnits.isEmpty()) {
                return null;
            }
            ArrayList<BatchEngineUnit> multiCompanyBatchEngineUnits = new ArrayList<BatchEngineUnit>();
            ArrayList<BatchEngineUnit> singleCompanyBatchEngineUnits = new ArrayList<BatchEngineUnit>();
            for (BatchEngineUnit batchEngineUnit : batchEngineUnits) {
                try {
                    BatchEngineUnitMetaInfo batchEngineUnitMetaInfo = batchEngineUnit.getBatchEngineUnitMetaInfo();
                    if (batchEngineUnitMetaInfo.isMultiCompany()) {
                        multiCompanyBatchEngineUnits.add(batchEngineUnit);
                        continue;
                    }
                    singleCompanyBatchEngineUnits.add(batchEngineUnit);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            BatchEngineBundleTracker.this._batchEngineUnitProcessor.processBatchEngineUnits(singleCompanyBatchEngineUnits);
            if (multiCompanyBatchEngineUnits.isEmpty()) {
                return null;
            }
            BatchEngineBundleTracker.this._multiCompanyBatchEngineUnitProcessor.registerBatchEngineUnits(bundle, multiCompanyBatchEngineUnits);
            return bundle;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Bundle unusedBundle) {
        }

        public void removedBundle(Bundle bundle, BundleEvent bundleEvent, Bundle unusedBundle) {
            BatchEngineBundleTracker.this._multiCompanyBatchEngineUnitProcessor.unregister(bundle);
        }
    }
}

