/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.batch.engine.model.impl;

import com.liferay.batch.engine.model.BatchEngineExportTask;
import com.liferay.batch.engine.model.BatchEngineExportTaskContentBlobModel;
import com.liferay.batch.engine.model.BatchEngineExportTaskModel;
import com.liferay.batch.engine.service.BatchEngineExportTaskLocalServiceUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the BatchEngineExportTask service. Represents a row in the &quot;BatchEngineExportTask&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>BatchEngineExportTaskModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link BatchEngineExportTaskImpl}.
 * </p>
 *
 * @author Shuyang Zhou
 * @see BatchEngineExportTaskImpl
 * @generated
 */
public class BatchEngineExportTaskModelImpl
	extends BaseModelImpl<BatchEngineExportTask>
	implements BatchEngineExportTaskModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a batch engine export task model instance should use the <code>BatchEngineExportTask</code> interface instead.
	 */
	public static final String TABLE_NAME = "BatchEngineExportTask";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"batchEngineExportTaskId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"callbackURL", Types.VARCHAR},
		{"className", Types.VARCHAR}, {"content", Types.BLOB},
		{"contentType", Types.VARCHAR}, {"endTime", Types.TIMESTAMP},
		{"errorMessage", Types.VARCHAR}, {"fieldNames", Types.VARCHAR},
		{"executeStatus", Types.VARCHAR}, {"parameters", Types.CLOB},
		{"startTime", Types.TIMESTAMP}, {"taskItemDelegateName", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("batchEngineExportTaskId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("callbackURL", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("className", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("content", Types.BLOB);
		TABLE_COLUMNS_MAP.put("contentType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("endTime", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("errorMessage", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("fieldNames", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("executeStatus", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("parameters", Types.CLOB);
		TABLE_COLUMNS_MAP.put("startTime", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("taskItemDelegateName", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table BatchEngineExportTask (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,batchEngineExportTaskId LONG not null primary key,companyId LONG,userId LONG,createDate DATE null,modifiedDate DATE null,callbackURL VARCHAR(75) null,className VARCHAR(255) null,content BLOB,contentType VARCHAR(75) null,endTime DATE null,errorMessage VARCHAR(1000) null,fieldNames VARCHAR(75) null,executeStatus VARCHAR(75) null,parameters TEXT null,startTime DATE null,taskItemDelegateName VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP =
		"drop table BatchEngineExportTask";

	public static final String ORDER_BY_JPQL =
		" ORDER BY batchEngineExportTask.batchEngineExportTaskId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY BatchEngineExportTask.batchEngineExportTaskId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXECUTESTATUS_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long BATCHENGINEEXPORTTASKID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public BatchEngineExportTaskModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _batchEngineExportTaskId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setBatchEngineExportTaskId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _batchEngineExportTaskId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return BatchEngineExportTask.class;
	}

	@Override
	public String getModelClassName() {
		return BatchEngineExportTask.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<BatchEngineExportTask, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<BatchEngineExportTask, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<BatchEngineExportTask, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((BatchEngineExportTask)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<BatchEngineExportTask, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<BatchEngineExportTask, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(BatchEngineExportTask)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<BatchEngineExportTask, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<BatchEngineExportTask, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<BatchEngineExportTask, Object>>
		_attributeGetterFunctions;

	static {
		Map<String, Function<BatchEngineExportTask, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<BatchEngineExportTask, Object>>();

		attributeGetterFunctions.put(
			"mvccVersion", BatchEngineExportTask::getMvccVersion);
		attributeGetterFunctions.put("uuid", BatchEngineExportTask::getUuid);
		attributeGetterFunctions.put(
			"batchEngineExportTaskId",
			BatchEngineExportTask::getBatchEngineExportTaskId);
		attributeGetterFunctions.put(
			"companyId", BatchEngineExportTask::getCompanyId);
		attributeGetterFunctions.put(
			"userId", BatchEngineExportTask::getUserId);
		attributeGetterFunctions.put(
			"createDate", BatchEngineExportTask::getCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", BatchEngineExportTask::getModifiedDate);
		attributeGetterFunctions.put(
			"callbackURL", BatchEngineExportTask::getCallbackURL);
		attributeGetterFunctions.put(
			"className", BatchEngineExportTask::getClassName);
		attributeGetterFunctions.put(
			"content", BatchEngineExportTask::getContent);
		attributeGetterFunctions.put(
			"contentType", BatchEngineExportTask::getContentType);
		attributeGetterFunctions.put(
			"endTime", BatchEngineExportTask::getEndTime);
		attributeGetterFunctions.put(
			"errorMessage", BatchEngineExportTask::getErrorMessage);
		attributeGetterFunctions.put(
			"fieldNames", BatchEngineExportTask::getFieldNames);
		attributeGetterFunctions.put(
			"executeStatus", BatchEngineExportTask::getExecuteStatus);
		attributeGetterFunctions.put(
			"parameters", BatchEngineExportTask::getParameters);
		attributeGetterFunctions.put(
			"startTime", BatchEngineExportTask::getStartTime);
		attributeGetterFunctions.put(
			"taskItemDelegateName",
			BatchEngineExportTask::getTaskItemDelegateName);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
	}

	private static final Map<String, BiConsumer<BatchEngineExportTask, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, BiConsumer<BatchEngineExportTask, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<BatchEngineExportTask, ?>>();

		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<BatchEngineExportTask, Long>)
				BatchEngineExportTask::setMvccVersion);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<BatchEngineExportTask, String>)
				BatchEngineExportTask::setUuid);
		attributeSetterBiConsumers.put(
			"batchEngineExportTaskId",
			(BiConsumer<BatchEngineExportTask, Long>)
				BatchEngineExportTask::setBatchEngineExportTaskId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<BatchEngineExportTask, Long>)
				BatchEngineExportTask::setCompanyId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<BatchEngineExportTask, Long>)
				BatchEngineExportTask::setUserId);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<BatchEngineExportTask, Date>)
				BatchEngineExportTask::setCreateDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<BatchEngineExportTask, Date>)
				BatchEngineExportTask::setModifiedDate);
		attributeSetterBiConsumers.put(
			"callbackURL",
			(BiConsumer<BatchEngineExportTask, String>)
				BatchEngineExportTask::setCallbackURL);
		attributeSetterBiConsumers.put(
			"className",
			(BiConsumer<BatchEngineExportTask, String>)
				BatchEngineExportTask::setClassName);
		attributeSetterBiConsumers.put(
			"content",
			(BiConsumer<BatchEngineExportTask, Blob>)
				BatchEngineExportTask::setContent);
		attributeSetterBiConsumers.put(
			"contentType",
			(BiConsumer<BatchEngineExportTask, String>)
				BatchEngineExportTask::setContentType);
		attributeSetterBiConsumers.put(
			"endTime",
			(BiConsumer<BatchEngineExportTask, Date>)
				BatchEngineExportTask::setEndTime);
		attributeSetterBiConsumers.put(
			"errorMessage",
			(BiConsumer<BatchEngineExportTask, String>)
				BatchEngineExportTask::setErrorMessage);
		attributeSetterBiConsumers.put(
			"fieldNames",
			(BiConsumer<BatchEngineExportTask, String>)
				BatchEngineExportTask::setFieldNames);
		attributeSetterBiConsumers.put(
			"executeStatus",
			(BiConsumer<BatchEngineExportTask, String>)
				BatchEngineExportTask::setExecuteStatus);
		attributeSetterBiConsumers.put(
			"parameters",
			(BiConsumer<BatchEngineExportTask, Map<String, Serializable>>)
				BatchEngineExportTask::setParameters);
		attributeSetterBiConsumers.put(
			"startTime",
			(BiConsumer<BatchEngineExportTask, Date>)
				BatchEngineExportTask::setStartTime);
		attributeSetterBiConsumers.put(
			"taskItemDelegateName",
			(BiConsumer<BatchEngineExportTask, String>)
				BatchEngineExportTask::setTaskItemDelegateName);

		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public long getBatchEngineExportTaskId() {
		return _batchEngineExportTaskId;
	}

	@Override
	public void setBatchEngineExportTaskId(long batchEngineExportTaskId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_batchEngineExportTaskId = batchEngineExportTaskId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getCallbackURL() {
		if (_callbackURL == null) {
			return "";
		}
		else {
			return _callbackURL;
		}
	}

	@Override
	public void setCallbackURL(String callbackURL) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_callbackURL = callbackURL;
	}

	@Override
	public String getClassName() {
		if (_className == null) {
			return "";
		}
		else {
			return _className;
		}
	}

	@Override
	public void setClassName(String className) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_className = className;
	}

	@Override
	public Blob getContent() {
		if (_contentBlobModel == null) {
			try {
				_contentBlobModel =
					BatchEngineExportTaskLocalServiceUtil.getContentBlobModel(
						getPrimaryKey());
			}
			catch (Exception exception) {
			}
		}

		Blob blob = null;

		if (_contentBlobModel != null) {
			blob = _contentBlobModel.getContentBlob();
		}

		return blob;
	}

	@Override
	public void setContent(Blob content) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		if (_contentBlobModel == null) {
			_contentBlobModel = new BatchEngineExportTaskContentBlobModel(
				getPrimaryKey(), content);
		}
		else {
			_contentBlobModel.setContentBlob(content);
		}
	}

	@Override
	public String getContentType() {
		if (_contentType == null) {
			return "";
		}
		else {
			return _contentType;
		}
	}

	@Override
	public void setContentType(String contentType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_contentType = contentType;
	}

	@Override
	public Date getEndTime() {
		return _endTime;
	}

	@Override
	public void setEndTime(Date endTime) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_endTime = endTime;
	}

	@Override
	public String getErrorMessage() {
		if (_errorMessage == null) {
			return "";
		}
		else {
			return _errorMessage;
		}
	}

	@Override
	public void setErrorMessage(String errorMessage) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_errorMessage = errorMessage;
	}

	@Override
	public String getFieldNames() {
		if (_fieldNames == null) {
			return "";
		}
		else {
			return _fieldNames;
		}
	}

	@Override
	public void setFieldNames(String fieldNames) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fieldNames = fieldNames;
	}

	@Override
	public String getExecuteStatus() {
		if (_executeStatus == null) {
			return "";
		}
		else {
			return _executeStatus;
		}
	}

	@Override
	public void setExecuteStatus(String executeStatus) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_executeStatus = executeStatus;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExecuteStatus() {
		return getColumnOriginalValue("executeStatus");
	}

	@Override
	public Map<String, Serializable> getParameters() {
		return _parameters;
	}

	@Override
	public void setParameters(Map<String, Serializable> parameters) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_parameters = parameters;
	}

	@Override
	public Date getStartTime() {
		return _startTime;
	}

	@Override
	public void setStartTime(Date startTime) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_startTime = startTime;
	}

	@Override
	public String getTaskItemDelegateName() {
		if (_taskItemDelegateName == null) {
			return "";
		}
		else {
			return _taskItemDelegateName;
		}
	}

	@Override
	public void setTaskItemDelegateName(String taskItemDelegateName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_taskItemDelegateName = taskItemDelegateName;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(BatchEngineExportTask.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), BatchEngineExportTask.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public BatchEngineExportTask toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, BatchEngineExportTask>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		BatchEngineExportTaskImpl batchEngineExportTaskImpl =
			new BatchEngineExportTaskImpl();

		batchEngineExportTaskImpl.setMvccVersion(getMvccVersion());
		batchEngineExportTaskImpl.setUuid(getUuid());
		batchEngineExportTaskImpl.setBatchEngineExportTaskId(
			getBatchEngineExportTaskId());
		batchEngineExportTaskImpl.setCompanyId(getCompanyId());
		batchEngineExportTaskImpl.setUserId(getUserId());
		batchEngineExportTaskImpl.setCreateDate(getCreateDate());
		batchEngineExportTaskImpl.setModifiedDate(getModifiedDate());
		batchEngineExportTaskImpl.setCallbackURL(getCallbackURL());
		batchEngineExportTaskImpl.setClassName(getClassName());
		batchEngineExportTaskImpl.setContentType(getContentType());
		batchEngineExportTaskImpl.setEndTime(getEndTime());
		batchEngineExportTaskImpl.setErrorMessage(getErrorMessage());
		batchEngineExportTaskImpl.setFieldNames(getFieldNames());
		batchEngineExportTaskImpl.setExecuteStatus(getExecuteStatus());
		batchEngineExportTaskImpl.setParameters(getParameters());
		batchEngineExportTaskImpl.setStartTime(getStartTime());
		batchEngineExportTaskImpl.setTaskItemDelegateName(
			getTaskItemDelegateName());

		batchEngineExportTaskImpl.resetOriginalValues();

		return batchEngineExportTaskImpl;
	}

	@Override
	public int compareTo(BatchEngineExportTask batchEngineExportTask) {
		long primaryKey = batchEngineExportTask.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof BatchEngineExportTask)) {
			return false;
		}

		BatchEngineExportTask batchEngineExportTask =
			(BatchEngineExportTask)object;

		long primaryKey = batchEngineExportTask.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_contentBlobModel = null;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<BatchEngineExportTask> toCacheModel() {
		BatchEngineExportTaskCacheModel batchEngineExportTaskCacheModel =
			new BatchEngineExportTaskCacheModel();

		batchEngineExportTaskCacheModel.mvccVersion = getMvccVersion();

		batchEngineExportTaskCacheModel.uuid = getUuid();

		String uuid = batchEngineExportTaskCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			batchEngineExportTaskCacheModel.uuid = null;
		}

		batchEngineExportTaskCacheModel.batchEngineExportTaskId =
			getBatchEngineExportTaskId();

		batchEngineExportTaskCacheModel.companyId = getCompanyId();

		batchEngineExportTaskCacheModel.userId = getUserId();

		Date createDate = getCreateDate();

		if (createDate != null) {
			batchEngineExportTaskCacheModel.createDate = createDate.getTime();
		}
		else {
			batchEngineExportTaskCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			batchEngineExportTaskCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			batchEngineExportTaskCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		batchEngineExportTaskCacheModel.callbackURL = getCallbackURL();

		String callbackURL = batchEngineExportTaskCacheModel.callbackURL;

		if ((callbackURL != null) && (callbackURL.length() == 0)) {
			batchEngineExportTaskCacheModel.callbackURL = null;
		}

		batchEngineExportTaskCacheModel.className = getClassName();

		String className = batchEngineExportTaskCacheModel.className;

		if ((className != null) && (className.length() == 0)) {
			batchEngineExportTaskCacheModel.className = null;
		}

		batchEngineExportTaskCacheModel.contentType = getContentType();

		String contentType = batchEngineExportTaskCacheModel.contentType;

		if ((contentType != null) && (contentType.length() == 0)) {
			batchEngineExportTaskCacheModel.contentType = null;
		}

		Date endTime = getEndTime();

		if (endTime != null) {
			batchEngineExportTaskCacheModel.endTime = endTime.getTime();
		}
		else {
			batchEngineExportTaskCacheModel.endTime = Long.MIN_VALUE;
		}

		batchEngineExportTaskCacheModel.errorMessage = getErrorMessage();

		String errorMessage = batchEngineExportTaskCacheModel.errorMessage;

		if ((errorMessage != null) && (errorMessage.length() == 0)) {
			batchEngineExportTaskCacheModel.errorMessage = null;
		}

		batchEngineExportTaskCacheModel.fieldNames = getFieldNames();

		String fieldNames = batchEngineExportTaskCacheModel.fieldNames;

		if ((fieldNames != null) && (fieldNames.length() == 0)) {
			batchEngineExportTaskCacheModel.fieldNames = null;
		}

		batchEngineExportTaskCacheModel.executeStatus = getExecuteStatus();

		String executeStatus = batchEngineExportTaskCacheModel.executeStatus;

		if ((executeStatus != null) && (executeStatus.length() == 0)) {
			batchEngineExportTaskCacheModel.executeStatus = null;
		}

		batchEngineExportTaskCacheModel.parameters = getParameters();

		Date startTime = getStartTime();

		if (startTime != null) {
			batchEngineExportTaskCacheModel.startTime = startTime.getTime();
		}
		else {
			batchEngineExportTaskCacheModel.startTime = Long.MIN_VALUE;
		}

		batchEngineExportTaskCacheModel.taskItemDelegateName =
			getTaskItemDelegateName();

		String taskItemDelegateName =
			batchEngineExportTaskCacheModel.taskItemDelegateName;

		if ((taskItemDelegateName != null) &&
			(taskItemDelegateName.length() == 0)) {

			batchEngineExportTaskCacheModel.taskItemDelegateName = null;
		}

		return batchEngineExportTaskCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(37);

		sb.append("{\"mvccVersion\": ");

		sb.append(getMvccVersion());

		sb.append(", \"uuid\": ");

		sb.append("\"" + getUuid() + "\"");

		sb.append(", \"batchEngineExportTaskId\": ");

		sb.append(getBatchEngineExportTaskId());

		sb.append(", \"companyId\": ");

		sb.append(getCompanyId());

		sb.append(", \"userId\": ");

		sb.append(getUserId());

		sb.append(", \"createDate\": ");

		sb.append("\"" + getCreateDate() + "\"");

		sb.append(", \"modifiedDate\": ");

		sb.append("\"" + getModifiedDate() + "\"");

		sb.append(", \"callbackURL\": ");

		sb.append("\"" + getCallbackURL() + "\"");

		sb.append(", \"className\": ");

		sb.append("\"" + getClassName() + "\"");

		sb.append(", \"contentType\": ");

		sb.append("\"" + getContentType() + "\"");

		sb.append(", \"endTime\": ");

		sb.append("\"" + getEndTime() + "\"");

		sb.append(", \"errorMessage\": ");

		sb.append("\"" + getErrorMessage() + "\"");

		sb.append(", \"fieldNames\": ");

		sb.append("\"" + getFieldNames() + "\"");

		sb.append(", \"executeStatus\": ");

		sb.append("\"" + getExecuteStatus() + "\"");

		sb.append(", \"parameters\": ");

		sb.append("\"" + getParameters() + "\"");

		sb.append(", \"startTime\": ");

		sb.append("\"" + getStartTime() + "\"");

		sb.append(", \"taskItemDelegateName\": ");

		sb.append("\"" + getTaskItemDelegateName() + "\"");

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(58);

		sb.append("<model><model-name>");
		sb.append("com.liferay.batch.engine.model.BatchEngineExportTask");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>mvccVersion</column-name><column-value><![CDATA[");

		sb.append(getMvccVersion());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>uuid</column-name><column-value><![CDATA[");

		sb.append(getUuid());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>batchEngineExportTaskId</column-name><column-value><![CDATA[");

		sb.append(getBatchEngineExportTaskId());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");

		sb.append(getCompanyId());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");

		sb.append(getUserId());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");

		sb.append(getCreateDate());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>modifiedDate</column-name><column-value><![CDATA[");

		sb.append(getModifiedDate());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>callbackURL</column-name><column-value><![CDATA[");

		sb.append(getCallbackURL());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>className</column-name><column-value><![CDATA[");

		sb.append(getClassName());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>contentType</column-name><column-value><![CDATA[");

		sb.append(getContentType());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>endTime</column-name><column-value><![CDATA[");

		sb.append(getEndTime());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>errorMessage</column-name><column-value><![CDATA[");

		sb.append(getErrorMessage());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>fieldNames</column-name><column-value><![CDATA[");

		sb.append(getFieldNames());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>executeStatus</column-name><column-value><![CDATA[");

		sb.append(getExecuteStatus());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>parameters</column-name><column-value><![CDATA[");

		sb.append(getParameters());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>startTime</column-name><column-value><![CDATA[");

		sb.append(getStartTime());

		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>taskItemDelegateName</column-name><column-value><![CDATA[");

		sb.append(getTaskItemDelegateName());

		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, BatchEngineExportTask>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					BatchEngineExportTask.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private long _batchEngineExportTaskId;
	private long _companyId;
	private long _userId;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _callbackURL;
	private String _className;
	private BatchEngineExportTaskContentBlobModel _contentBlobModel;
	private String _contentType;
	private Date _endTime;
	private String _errorMessage;
	private String _fieldNames;
	private String _executeStatus;
	private Map<String, Serializable> _parameters;
	private Date _startTime;
	private String _taskItemDelegateName;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<BatchEngineExportTask, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((BatchEngineExportTask)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"batchEngineExportTaskId", _batchEngineExportTaskId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("callbackURL", _callbackURL);
		_columnOriginalValues.put("className", _className);
		_columnOriginalValues.put("contentType", _contentType);
		_columnOriginalValues.put("endTime", _endTime);
		_columnOriginalValues.put("errorMessage", _errorMessage);
		_columnOriginalValues.put("fieldNames", _fieldNames);
		_columnOriginalValues.put("executeStatus", _executeStatus);
		_columnOriginalValues.put("parameters", _parameters);
		_columnOriginalValues.put("startTime", _startTime);
		_columnOriginalValues.put(
			"taskItemDelegateName", _taskItemDelegateName);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("batchEngineExportTaskId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("createDate", 32L);

		columnBitmasks.put("modifiedDate", 64L);

		columnBitmasks.put("callbackURL", 128L);

		columnBitmasks.put("className", 256L);

		columnBitmasks.put("content", 512L);

		columnBitmasks.put("contentType", 1024L);

		columnBitmasks.put("endTime", 2048L);

		columnBitmasks.put("errorMessage", 4096L);

		columnBitmasks.put("fieldNames", 8192L);

		columnBitmasks.put("executeStatus", 16384L);

		columnBitmasks.put("parameters", 32768L);

		columnBitmasks.put("startTime", 65536L);

		columnBitmasks.put("taskItemDelegateName", 131072L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private BatchEngineExportTask _escapedModel;

}