/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.item;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.MultivaluedHashMap;
import org.osgi.framework.ServiceObjects;

public class BatchEngineTaskItemResourceDelegate
implements Closeable {
    private static final ObjectMapper _objectMapper = new ObjectMapper();
    private final AcceptLanguage _acceptLanguage;
    private final Company _company;
    private final ExpressionConvert<Filter> _expressionConvert;
    private final Map<String, Field> _fieldMap;
    private final FilterParserProvider _filterParserProvider;
    private final Map<String, Serializable> _parameters;
    private final Object _resource;
    private final Method _resourceMethod;
    private final Map.Entry<String, Class<?>>[] _resourceMethodArgNameTypeEntries;
    private final ServiceObjects<Object> _resourceServiceObjects;
    private final SortParserProvider _sortParserProvider;
    private final User _user;

    public BatchEngineTaskItemResourceDelegate(Company company, ExpressionConvert<Filter> expressionConvert, Map<String, Field> fieldMap, FilterParserProvider filterParserProvider, Map<String, Serializable> parameters, Method resourceMethod, Map.Entry<String, Class<?>>[] resourceMethodArgNameTypeEntries, ServiceObjects<Object> resourceServiceObjects, SortParserProvider sortParserProvider, User user) throws ReflectiveOperationException {
        this._company = company;
        this._expressionConvert = expressionConvert;
        this._fieldMap = fieldMap;
        this._filterParserProvider = filterParserProvider;
        this._parameters = parameters;
        this._resourceMethod = resourceMethod;
        this._resourceMethodArgNameTypeEntries = resourceMethodArgNameTypeEntries;
        this._resourceServiceObjects = resourceServiceObjects;
        this._sortParserProvider = sortParserProvider;
        this._user = user;
        this._acceptLanguage = this._getAcceptLanguage();
        this._resource = this._getResource();
    }

    public void addItems(List<?> items) throws Exception {
        for (Object item : items) {
            Object[] args = new Object[this._resourceMethod.getParameterCount()];
            Parameter[] parameters = this._resourceMethod.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                if (parameter.getType() == item.getClass()) {
                    args[i] = item;
                    continue;
                }
                Map.Entry<String, Class<?>> resourceMethodArgNameTypeEntry = this._resourceMethodArgNameTypeEntries[i];
                if (resourceMethodArgNameTypeEntry == null) {
                    throw new IllegalArgumentException("Unable to find method argument name");
                }
                args[i] = this._getMethodArgValue(item, resourceMethodArgNameTypeEntry.getKey(), resourceMethodArgNameTypeEntry.getValue());
            }
            this._resourceMethod.invoke(this._resource, args);
        }
    }

    @Override
    public void close() {
        this._resourceServiceObjects.ungetService(this._resource);
    }

    public Page<?> getItems(int page, int pageSize) throws Exception {
        Object[] args = new Object[this._resourceMethod.getParameterCount()];
        for (int i = 0; i < this._resourceMethodArgNameTypeEntries.length; ++i) {
            Map.Entry<String, Class<?>> resourceMethodArgNameTypeEntry = this._resourceMethodArgNameTypeEntries[i];
            if (resourceMethodArgNameTypeEntry == null) continue;
            Class<?> resourceMethodArgType = resourceMethodArgNameTypeEntry.getValue();
            args[i] = resourceMethodArgType == Filter.class ? this._getFilter(this._acceptLanguage, this._getEntityModel(this._resource, this._parameters), (String)((Object)this._parameters.get("filter"))) : (resourceMethodArgType == Pagination.class ? Pagination.of((int)page, (int)pageSize) : (resourceMethodArgType == Sort[].class ? this._getSorts(this._acceptLanguage, this._getEntityModel(this._resource, this._parameters), (String)((Object)this._parameters.get("sort"))) : this._getMethodArgValue(null, resourceMethodArgNameTypeEntry.getKey(), resourceMethodArgType)));
        }
        return (Page)this._resourceMethod.invoke(this._resource, args);
    }

    private AcceptLanguage _getAcceptLanguage() {
        return new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return BatchEngineTaskItemResourceDelegate.this._user.getLanguageId();
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)BatchEngineTaskItemResourceDelegate.this._user.getLanguageId());
            }
        };
    }

    private EntityModel _getEntityModel(Object resource, Map<String, Serializable> parameterMap) throws Exception {
        EntityModelResource entityModelResource = (EntityModelResource)resource;
        return entityModelResource.getEntityModel(this._getMultivaluedHashMap(parameterMap));
    }

    private Filter _getFilter(AcceptLanguage acceptLanguage, EntityModel entityModel, String filterString) throws Exception {
        if (Validator.isNull((String)filterString)) {
            return null;
        }
        if (entityModel == null) {
            return null;
        }
        FilterParser filterParser = this._filterParserProvider.provide(entityModel);
        com.liferay.portal.odata.filter.Filter oDataFilter = new com.liferay.portal.odata.filter.Filter(filterParser.parse(filterString));
        return (Filter)this._expressionConvert.convert(oDataFilter.getExpression(), acceptLanguage.getPreferredLocale(), entityModel);
    }

    private Object _getMethodArgValue(Object item, String resourceMethodArgName, Class<?> resourceMethodArgType) throws IllegalAccessException {
        Serializable parameter = null;
        if (this._parameters != null) {
            parameter = this._parameters.get(resourceMethodArgName);
        }
        if (item != null && parameter == null) {
            Field field = this._fieldMap.get(resourceMethodArgName);
            if (field == null) {
                return null;
            }
            return field.get(item);
        }
        if (parameter != null) {
            return _objectMapper.convertValue((Object)parameter, resourceMethodArgType);
        }
        return null;
    }

    private MultivaluedHashMap<String, String> _getMultivaluedHashMap(final Map<String, Serializable> parameterMap) {
        return new MultivaluedHashMap<String, String>(){
            {
                for (Map.Entry entry : parameterMap.entrySet()) {
                    Object value = entry.getValue();
                    this.put(entry.getKey(), Collections.singletonList(value.toString()));
                }
            }
        };
    }

    private Object _getResource() throws ReflectiveOperationException {
        Object resource = this._resourceServiceObjects.getService();
        this._setFieldValue(resource, "contextAcceptLanguage", this._acceptLanguage);
        this._setFieldValue(resource, "contextCompany", this._company);
        this._setFieldValue(resource, "contextUser", this._user);
        return resource;
    }

    private Sort[] _getSorts(AcceptLanguage acceptLanguage, EntityModel entityModel, String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        SortParser sortParser = this._sortParserProvider.provide(entityModel);
        if (sortParser == null) {
            return null;
        }
        com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
        List sortFields = oDataSort.getSortFields();
        Sort[] sorts = new Sort[sortFields.size()];
        for (int i = 0; i < sortFields.size(); ++i) {
            SortField sortField = (SortField)sortFields.get(i);
            sorts[i] = new Sort(sortField.getSortableFieldName(acceptLanguage.getPreferredLocale()), !sortField.isAscending());
        }
        return sorts;
    }

    private void _setFieldValue(Object resource, String fieldName, Object value) throws ReflectiveOperationException {
        Class<?> resourceClass = resource.getClass();
        Class<?> resourceSuperClass = resourceClass.getSuperclass();
        Field field = resourceSuperClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(resource, value);
    }
}

