/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal;

import com.liferay.batch.engine.BatchEngineImportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskContentType;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.BatchEngineTaskOperation;
import com.liferay.batch.engine.configuration.BatchEngineTaskConfiguration;
import com.liferay.batch.engine.internal.BatchEngineTaskCallbackUtil;
import com.liferay.batch.engine.internal.BatchEngineTaskExecutorUtil;
import com.liferay.batch.engine.internal.BatchEngineTaskMethodRegistry;
import com.liferay.batch.engine.internal.item.BatchEngineTaskItemResourceDelegate;
import com.liferay.batch.engine.internal.item.BatchEngineTaskItemResourceDelegateFactory;
import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReader;
import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReaderFactory;
import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReaderUtil;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineImportTaskLocalService;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.batch.engine.configuration.BatchEngineTaskConfiguration"}, service={BatchEngineImportTaskExecutor.class})
public class BatchEngineImportTaskExecutorImpl
implements BatchEngineImportTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineImportTaskExecutorImpl.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRES_NEW, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    private BatchEngineImportTaskItemReaderFactory _batchEngineImportTaskItemReaderFactory;
    @Reference
    private BatchEngineImportTaskLocalService _batchEngineImportTaskLocalService;
    private BatchEngineTaskItemResourceDelegateFactory _batchEngineTaskItemResourceDelegateFactory;
    @Reference
    private BatchEngineTaskMethodRegistry _batchEngineTaskMethodRegistry;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void execute(BatchEngineImportTask batchEngineImportTask) {
        try {
            batchEngineImportTask.setExecuteStatus(BatchEngineTaskExecuteStatus.STARTED.toString());
            batchEngineImportTask.setStartTime(new Date());
            this._batchEngineImportTaskLocalService.updateBatchEngineImportTask(batchEngineImportTask);
            BatchEngineTaskExecutorUtil.execute((UnsafeRunnable<Throwable>)((UnsafeRunnable)() -> this._importItems(batchEngineImportTask)), this._userLocalService.getUser(batchEngineImportTask.getUserId()));
            this._updateBatchEngineImportTask(BatchEngineTaskExecuteStatus.COMPLETED, batchEngineImportTask, null);
        }
        catch (Throwable t) {
            _log.error((Object)("Unable to update batch engine import task " + batchEngineImportTask), t);
            this._updateBatchEngineImportTask(BatchEngineTaskExecuteStatus.FAILED, batchEngineImportTask, t.getMessage());
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        BatchEngineTaskConfiguration batchEngineTaskConfiguration = (BatchEngineTaskConfiguration)ConfigurableUtil.createConfigurable(BatchEngineTaskConfiguration.class, properties);
        this._batchEngineImportTaskItemReaderFactory = new BatchEngineImportTaskItemReaderFactory(GetterUtil.getString((String)batchEngineTaskConfiguration.csvFileColumnDelimiter(), (String)","));
        this._batchEngineTaskItemResourceDelegateFactory = new BatchEngineTaskItemResourceDelegateFactory(this._batchEngineTaskMethodRegistry, this._companyLocalService, null, null, null, this._userLocalService);
    }

    private void _commitItems(BatchEngineImportTask batchEngineImportTask, BatchEngineTaskItemResourceDelegate batchEngineTaskItemResourceDelegate, List<Object> items) throws Throwable {
        TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
            batchEngineTaskItemResourceDelegate.addItems(items);
            this._batchEngineImportTaskLocalService.updateBatchEngineImportTask(batchEngineImportTask);
            return null;
        });
    }

    private void _importItems(BatchEngineImportTask batchEngineImportTask) throws Throwable {
        try (BatchEngineImportTaskItemReader batchEngineImportTaskItemReader = this._batchEngineImportTaskItemReaderFactory.create(BatchEngineTaskContentType.valueOf((String)batchEngineImportTask.getContentType()), this._batchEngineImportTaskLocalService.openContentInputStream(batchEngineImportTask.getBatchEngineImportTaskId()));
             BatchEngineTaskItemResourceDelegate batchEngineTaskItemResourceDelegate = this._batchEngineTaskItemResourceDelegateFactory.create(BatchEngineTaskOperation.valueOf((String)batchEngineImportTask.getOperation()), batchEngineImportTask.getClassName(), batchEngineImportTask.getCompanyId(), batchEngineImportTask.getParameters(), batchEngineImportTask.getUserId(), batchEngineImportTask.getVersion());){
            ArrayList<Object> items = new ArrayList<Object>();
            Class itemClass = this._batchEngineTaskMethodRegistry.getItemClass(batchEngineImportTask.getClassName());
            Map<String, Object> fieldNameValueMap = null;
            while ((fieldNameValueMap = batchEngineImportTaskItemReader.read()) != null) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                items.add(BatchEngineImportTaskItemReaderUtil.convertValue(itemClass, BatchEngineImportTaskItemReaderUtil.mapFieldNames(batchEngineImportTask.getFieldNameMapping(), fieldNameValueMap)));
                if ((long)items.size() != batchEngineImportTask.getBatchSize()) continue;
                this._commitItems(batchEngineImportTask, batchEngineTaskItemResourceDelegate, items);
                items.clear();
            }
            if (!items.isEmpty()) {
                this._commitItems(batchEngineImportTask, batchEngineTaskItemResourceDelegate, items);
            }
        }
    }

    private void _updateBatchEngineImportTask(BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus, BatchEngineImportTask batchEngineImportTask, String errorMessage) {
        batchEngineImportTask.setEndTime(new Date());
        batchEngineImportTask.setErrorMessage(errorMessage);
        batchEngineImportTask.setExecuteStatus(batchEngineTaskExecuteStatus.toString());
        this._batchEngineImportTaskLocalService.updateBatchEngineImportTask(batchEngineImportTask);
        BatchEngineTaskCallbackUtil.sendCallback(batchEngineImportTask.getCallbackURL(), batchEngineImportTask.getExecuteStatus(), batchEngineImportTask.getBatchEngineImportTaskId());
    }
}

