/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.writer;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ObjectWriterFactory {
    private static final ObjectMapper _objectMapper = new ObjectMapper(){
        {
            this.enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY});
            this.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
            this.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        }
    };

    public static ObjectWriter getObjectWriter(Set<String> allFieldNames, List<String> includeFieldNames) {
        SimpleFilterProvider simpleFilterProvider = new SimpleFilterProvider();
        if (includeFieldNames.isEmpty()) {
            simpleFilterProvider.setFailOnUnknownId(false);
        } else {
            HashSet<String> excludeFieldNames = new HashSet<String>(allFieldNames);
            excludeFieldNames.removeAll(includeFieldNames);
            SimpleBeanPropertyFilter simpleBeanPropertyFilter = SimpleBeanPropertyFilter.serializeAllExcept(excludeFieldNames);
            simpleFilterProvider.addFilter("Liferay.Vulcan", simpleBeanPropertyFilter);
        }
        return _objectMapper.writer((FilterProvider)simpleFilterProvider);
    }
}

