/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class BatchEngineImportTaskItemReaderUtil {
    private static final ObjectMapper _objectMapper = new ObjectMapper();

    public static <T> T convertValue(Class<T> itemClass, Map<String, Object> fieldNameValueMap) throws ReflectiveOperationException {
        T item = itemClass.newInstance();
        for (Map.Entry<String, Object> entry : fieldNameValueMap.entrySet()) {
            String name = entry.getKey();
            Field field = null;
            try {
                field = itemClass.getDeclaredField(name);
            }
            catch (NoSuchFieldException nsfe) {
                field = itemClass.getDeclaredField("_" + name);
            }
            field.setAccessible(true);
            field.set(item, _objectMapper.convertValue(entry.getValue(), field.getType()));
        }
        return item;
    }

    public static void handleMapField(String fieldName, Map<String, Object> fieldNameValueMap, int lastDelimiterIndex, String value) {
        String key = fieldName.substring(lastDelimiterIndex + 1);
        HashMap<String, String> valueMap = (HashMap<String, String>)fieldNameValueMap.get(fieldName = fieldName.substring(0, lastDelimiterIndex));
        if (valueMap == null) {
            valueMap = new HashMap<String, String>();
            fieldNameValueMap.put(fieldName, valueMap);
        }
        valueMap.put(key, value);
    }

    public static Map<String, Object> mapFieldNames(Map<String, ? extends Serializable> fieldNameMappingMap, Map<String, Object> fieldNameValueMap) {
        if (fieldNameMappingMap == null || fieldNameMappingMap.isEmpty()) {
            return fieldNameValueMap;
        }
        HashMap<String, Object> targetFieldNameValueMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : fieldNameValueMap.entrySet()) {
            String targetFieldName = (String)((Object)fieldNameMappingMap.get(entry.getKey()));
            if (!Validator.isNotNull((String)targetFieldName)) continue;
            targetFieldNameValueMap.put(targetFieldName, entry.getValue());
        }
        return targetFieldNameValueMap;
    }
}

