/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.auto.deploy;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.batch.engine.BatchEngineImportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.BatchEngineTaskOperation;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineImportTaskLocalService;
import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AutoDeployListener.class})
public class BatchEngineAutoDeployListener
implements AutoDeployListener {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineAutoDeployListener.class);
    private static final ObjectMapper _objectMapper = new ObjectMapper();
    @Reference
    private BatchEngineImportTaskExecutor _batchEngineImportTaskExecutor;
    @Reference
    private BatchEngineImportTaskLocalService _batchEngineImportTaskLocalService;
    @Reference
    private com.liferay.portal.kernel.util.File _file;
    @Reference
    private PortalExecutorManager _portalExecutorManager;

    public int deploy(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        try (ZipFile zipFile = new ZipFile(autoDeploymentContext.getFile());){
            this._deploy(zipFile);
        }
        catch (Exception e) {
            throw new AutoDeployException((Throwable)e);
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDeployable(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        File file = autoDeploymentContext.getFile();
        String fileName = file.getName();
        if (!StringUtil.endsWith((String)fileName, (String)".zip")) {
            return false;
        }
        try (ZipFile zipFile = new ZipFile(file);){
            if (zipFile.size() != 2) {
                boolean bl = false;
                return bl;
            }
            ZipEntry zipEntry = zipFile.getEntry("batch-engine.json");
            if (zipEntry == null) {
                boolean bl = false;
                return bl;
            }
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                BatchEngineImportConfiguration batchEngineImportConfiguration = (BatchEngineImportConfiguration)_objectMapper.readValue(inputStream, BatchEngineImportConfiguration.class);
                if (batchEngineImportConfiguration == null) {
                    boolean bl = false;
                    return bl;
                }
                if (batchEngineImportConfiguration.companyId != 0L && batchEngineImportConfiguration.userId != 0L && !Validator.isNull((String)batchEngineImportConfiguration.className)) {
                    if (!Validator.isNull((String)batchEngineImportConfiguration.version)) return true;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            throw new AutoDeployException((Throwable)e);
        }
    }

    private void _deploy(ZipFile zipFile) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Deploying batch engine file " + zipFile.getName()));
        }
        Enumeration<? extends ZipEntry> iterator = zipFile.entries();
        BatchEngineImportConfiguration batchEngineImportConfiguration = null;
        byte[] content = null;
        String contentType = null;
        while (iterator.hasMoreElements()) {
            ZipEntry zipEntry = iterator.nextElement();
            if (Objects.equals(zipEntry.getName(), "batch-engine.json")) {
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                Throwable throwable = null;
                try {
                    batchEngineImportConfiguration = (BatchEngineImportConfiguration)_objectMapper.readValue(inputStream, BatchEngineImportConfiguration.class);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                    continue;
                }
            }
            UnsyncByteArrayOutputStream compressedUnsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);
                 ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)compressedUnsyncByteArrayOutputStream);){
                zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                StreamUtil.transfer((InputStream)inputStream, (OutputStream)zipOutputStream, (boolean)false);
            }
            content = compressedUnsyncByteArrayOutputStream.toByteArray();
            contentType = this._file.getExtension(zipEntry.getName());
        }
        if (batchEngineImportConfiguration == null || content == null || Validator.isNull(contentType)) {
            throw new IllegalStateException("Invalid batch engine file " + zipFile.getName());
        }
        NoticeableExecutorService executorService = this._portalExecutorManager.getPortalExecutor(BatchEngineAutoDeployListener.class.getName());
        BatchEngineImportTask batchEngineImportTask = this._batchEngineImportTaskLocalService.addBatchEngineImportTask(batchEngineImportConfiguration.companyId, batchEngineImportConfiguration.userId, 100L, batchEngineImportConfiguration.callbackURL, batchEngineImportConfiguration.className, content, StringUtil.toUpperCase(contentType), BatchEngineTaskExecuteStatus.INITIAL.name(), batchEngineImportConfiguration.fieldNameMappingMap, BatchEngineTaskOperation.CREATE.name(), batchEngineImportConfiguration.parameters, batchEngineImportConfiguration.version);
        executorService.submit(() -> {
            this._batchEngineImportTaskExecutor.execute(batchEngineImportTask);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Successfully deployed batch engine file " + zipFile.getName()));
            }
        });
    }

    private static final class BatchEngineImportConfiguration {
        @JsonProperty
        protected String callbackURL;
        @JsonProperty
        protected String className;
        @JsonProperty
        protected long companyId;
        @JsonProperty
        protected Map<String, String> fieldNameMappingMap;
        @JsonProperty
        protected Map<String, Serializable> parameters;
        @JsonProperty
        protected long userId;
        @JsonProperty
        protected String version;

        private BatchEngineImportConfiguration() {
        }
    }
}

