/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal;

import com.liferay.batch.engine.BatchEngineTaskFieldId;
import com.liferay.batch.engine.BatchEngineTaskMethod;
import com.liferay.batch.engine.BatchEngineTaskOperation;
import com.liferay.batch.engine.ItemClassRegistry;
import com.liferay.batch.engine.internal.BatchEngineTaskMethodRegistry;
import com.liferay.batch.engine.internal.item.BatchEngineTaskItemResourceDelegate;
import com.liferay.batch.engine.internal.item.BatchEngineTaskItemResourceDelegateCreator;
import com.liferay.batch.engine.internal.writer.ItemClassIndexUtil;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={BatchEngineTaskMethodRegistry.class, ItemClassRegistry.class})
public class BatchEngineTaskMethodRegistryImpl
implements BatchEngineTaskMethodRegistry {
    private final Map<CreatorKey, BatchEngineTaskItemResourceDelegateCreator> _batchEngineTaskItemResourceDelegateCreators = new ConcurrentHashMap<CreatorKey, BatchEngineTaskItemResourceDelegateCreator>();
    private final Map<String, Map.Entry<Class<?>, AtomicInteger>> _itemClasses = new ConcurrentHashMap();
    private ServiceTracker<Object, List<CreatorKey>> _serviceTracker;

    @Override
    public BatchEngineTaskItemResourceDelegateCreator getBatchEngineTaskItemResourceDelegateCreator(String apiVersion, BatchEngineTaskOperation batchEngineTaskOperation, String itemClassName) {
        return this._batchEngineTaskItemResourceDelegateCreators.get(new CreatorKey(apiVersion, batchEngineTaskOperation, itemClassName));
    }

    public Class<?> getItemClass(String itemClassName) {
        Map.Entry<Class<?>, AtomicInteger> entry = this._itemClasses.get(itemClassName);
        if (entry == null) {
            throw new IllegalStateException("Unknown class: " + itemClassName);
        }
        return entry.getKey();
    }

    @Activate
    protected void activate(BundleContext bundleContext) throws InvalidSyntaxException {
        this._serviceTracker = new ServiceTracker(bundleContext, bundleContext.createFilter("(&(api.version=*)(osgi.jaxrs.resource=true)(!(batch.engine=true)))"), (ServiceTrackerCustomizer)new BatchEngineTaskMethodServiceTrackerCustomizer(bundleContext));
        this._serviceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private class BatchEngineTaskMethodServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, List<CreatorKey>> {
        private final BundleContext _bundleContext;

        public List<CreatorKey> addingService(ServiceReference<Object> serviceReference) {
            Object resource = this._bundleContext.getService(serviceReference);
            Class<?> resourceClass = resource.getClass();
            ArrayList<CreatorKey> creatorKeys = null;
            for (Method resourceMethod : resourceClass.getMethods()) {
                BatchEngineTaskMethod batchEngineTaskMethod = resourceMethod.getAnnotation(BatchEngineTaskMethod.class);
                if (batchEngineTaskMethod == null) continue;
                Class itemClass = batchEngineTaskMethod.itemClass();
                CreatorKey creatorKey = new CreatorKey(String.valueOf(serviceReference.getProperty("api.version")), batchEngineTaskMethod.batchEngineTaskOperation(), itemClass.getName());
                try {
                    Map.Entry[] resourceMethodArgNameTypeEntries = this._getResourceMethodArgNameTypeEntries(resourceClass, resourceMethod);
                    ServiceObjects serviceObjects = this._bundleContext.getServiceObjects(serviceReference);
                    BatchEngineTaskMethodRegistryImpl.this._batchEngineTaskItemResourceDelegateCreators.put(creatorKey, (company, expressionConvert, filterParserProvider, parameters, sortParserProvider, user) -> new BatchEngineTaskItemResourceDelegate(company, (ExpressionConvert<Filter>)expressionConvert, ItemClassIndexUtil.index(itemClass), filterParserProvider, parameters, resourceMethod, resourceMethodArgNameTypeEntries, (ServiceObjects<Object>)serviceObjects, sortParserProvider, user));
                }
                catch (NoSuchMethodException nsme) {
                    throw new IllegalStateException(nsme);
                }
                if (creatorKeys == null) {
                    creatorKeys = new ArrayList<CreatorKey>();
                }
                creatorKeys.add(creatorKey);
                BatchEngineTaskMethodRegistryImpl.this._itemClasses.compute(creatorKey._itemClassName, (itemClassName, entry) -> {
                    if (entry == null) {
                        return new AbstractMap.SimpleImmutableEntry<Class, AtomicInteger>(itemClass, new AtomicInteger(1));
                    }
                    AtomicInteger counter = (AtomicInteger)entry.getValue();
                    counter.incrementAndGet();
                    return entry;
                });
            }
            return creatorKeys;
        }

        public void modifiedService(ServiceReference<Object> serviceReference, List<CreatorKey> creatorKeys) {
        }

        public void removedService(ServiceReference<Object> serviceReference, List<CreatorKey> creatorKeys) {
            for (CreatorKey creatorKey : creatorKeys) {
                BatchEngineTaskMethodRegistryImpl.this._batchEngineTaskItemResourceDelegateCreators.remove(creatorKey);
                BatchEngineTaskMethodRegistryImpl.this._itemClasses.compute(creatorKey._itemClassName, (itemClassName, entry) -> {
                    if (entry == null) {
                        return null;
                    }
                    AtomicInteger counter = (AtomicInteger)entry.getValue();
                    if (counter.decrementAndGet() == 0) {
                        return null;
                    }
                    return entry;
                });
            }
            this._bundleContext.ungetService(serviceReference);
        }

        private BatchEngineTaskMethodServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        private Map.Entry<String, Class<?>>[] _getResourceMethodArgNameTypeEntries(Class<?> resourceClass, Method resourceMethod) throws NoSuchMethodException {
            Parameter[] resourceMethodParameters = resourceMethod.getParameters();
            Map.Entry[] resourceMethodArgNameTypeEntries = new Map.Entry[resourceMethodParameters.length];
            Class<?> parentResourceClass = resourceClass.getSuperclass();
            Method parentResourceMethod = parentResourceClass.getMethod(resourceMethod.getName(), resourceMethod.getParameterTypes());
            Parameter[] parentResourceMethodParameters = parentResourceMethod.getParameters();
            for (int i = 0; i < resourceMethodParameters.length; ++i) {
                Parameter parameter = resourceMethodParameters[i];
                BatchEngineTaskFieldId batchEngineTaskFieldId = parameter.getAnnotation(BatchEngineTaskFieldId.class);
                Class<?> parameterType = parameter.getType();
                if (batchEngineTaskFieldId == null) {
                    if (parentResourceMethodParameters == null) continue;
                    parameter = parentResourceMethodParameters[i];
                    if (parameterType == Filter.class || parameterType == Pagination.class || parameterType == Sort[].class) {
                        resourceMethodArgNameTypeEntries[i] = new AbstractMap.SimpleImmutableEntry(parameter.getName(), parameterType);
                        continue;
                    }
                    PathParam pathParam = parameter.getAnnotation(PathParam.class);
                    if (pathParam != null) {
                        resourceMethodArgNameTypeEntries[i] = new AbstractMap.SimpleImmutableEntry(pathParam.value(), parameterType);
                        continue;
                    }
                    QueryParam queryParam = parameter.getAnnotation(QueryParam.class);
                    if (queryParam == null) continue;
                    resourceMethodArgNameTypeEntries[i] = new AbstractMap.SimpleImmutableEntry(queryParam.value(), parameterType);
                    continue;
                }
                resourceMethodArgNameTypeEntries[i] = new AbstractMap.SimpleImmutableEntry(batchEngineTaskFieldId.value(), parameterType);
            }
            return resourceMethodArgNameTypeEntries;
        }
    }

    private static class CreatorKey {
        private final String _apiVersion;
        private final BatchEngineTaskOperation _batchEngineTaskOperation;
        private final String _itemClassName;

        public boolean equals(Object obj) {
            CreatorKey creatorKey = (CreatorKey)obj;
            return Objects.equals(creatorKey._apiVersion, this._apiVersion) && Objects.equals(creatorKey._batchEngineTaskOperation, this._batchEngineTaskOperation) && Objects.equals(creatorKey._itemClassName, this._itemClassName);
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (Object)this._apiVersion);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._batchEngineTaskOperation);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._itemClassName);
            return hashCode;
        }

        private CreatorKey(String apiVersion, BatchEngineTaskOperation batchEngineTaskOperation, String itemClassName) {
            this._apiVersion = apiVersion;
            this._batchEngineTaskOperation = batchEngineTaskOperation;
            this._itemClassName = itemClassName;
        }
    }
}

