/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.app.builder.model;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ShardedModel;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the AppBuilderAppDataRecordLink service. Represents a row in the &quot;AppBuilderAppDataRecordLink&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.app.builder.model.impl.AppBuilderAppDataRecordLinkModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.app.builder.model.impl.AppBuilderAppDataRecordLinkImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AppBuilderAppDataRecordLink
 * @generated
 */
@ProviderType
public interface AppBuilderAppDataRecordLinkModel
	extends BaseModel<AppBuilderAppDataRecordLink>, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a app builder app data record link model instance should use the {@link AppBuilderAppDataRecordLink} interface instead.
	 */

	/**
	 * Returns the primary key of this app builder app data record link.
	 *
	 * @return the primary key of this app builder app data record link
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this app builder app data record link.
	 *
	 * @param primaryKey the primary key of this app builder app data record link
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the app builder app data record link ID of this app builder app data record link.
	 *
	 * @return the app builder app data record link ID of this app builder app data record link
	 */
	public long getAppBuilderAppDataRecordLinkId();

	/**
	 * Sets the app builder app data record link ID of this app builder app data record link.
	 *
	 * @param appBuilderAppDataRecordLinkId the app builder app data record link ID of this app builder app data record link
	 */
	public void setAppBuilderAppDataRecordLinkId(
		long appBuilderAppDataRecordLinkId);

	/**
	 * Returns the group ID of this app builder app data record link.
	 *
	 * @return the group ID of this app builder app data record link
	 */
	public long getGroupId();

	/**
	 * Sets the group ID of this app builder app data record link.
	 *
	 * @param groupId the group ID of this app builder app data record link
	 */
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this app builder app data record link.
	 *
	 * @return the company ID of this app builder app data record link
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this app builder app data record link.
	 *
	 * @param companyId the company ID of this app builder app data record link
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the app builder app ID of this app builder app data record link.
	 *
	 * @return the app builder app ID of this app builder app data record link
	 */
	public long getAppBuilderAppId();

	/**
	 * Sets the app builder app ID of this app builder app data record link.
	 *
	 * @param appBuilderAppId the app builder app ID of this app builder app data record link
	 */
	public void setAppBuilderAppId(long appBuilderAppId);

	/**
	 * Returns the app builder app version ID of this app builder app data record link.
	 *
	 * @return the app builder app version ID of this app builder app data record link
	 */
	public long getAppBuilderAppVersionId();

	/**
	 * Sets the app builder app version ID of this app builder app data record link.
	 *
	 * @param appBuilderAppVersionId the app builder app version ID of this app builder app data record link
	 */
	public void setAppBuilderAppVersionId(long appBuilderAppVersionId);

	/**
	 * Returns the ddl record ID of this app builder app data record link.
	 *
	 * @return the ddl record ID of this app builder app data record link
	 */
	public long getDdlRecordId();

	/**
	 * Sets the ddl record ID of this app builder app data record link.
	 *
	 * @param ddlRecordId the ddl record ID of this app builder app data record link
	 */
	public void setDdlRecordId(long ddlRecordId);

}