/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.app.builder.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the AppBuilderAppVersion service. Represents a row in the &quot;AppBuilderAppVersion&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.app.builder.model.impl.AppBuilderAppVersionModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.app.builder.model.impl.AppBuilderAppVersionImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AppBuilderAppVersion
 * @generated
 */
@ProviderType
public interface AppBuilderAppVersionModel
	extends BaseModel<AppBuilderAppVersion>, GroupedModel, ShardedModel,
			StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a app builder app version model instance should use the {@link AppBuilderAppVersion} interface instead.
	 */

	/**
	 * Returns the primary key of this app builder app version.
	 *
	 * @return the primary key of this app builder app version
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this app builder app version.
	 *
	 * @param primaryKey the primary key of this app builder app version
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the uuid of this app builder app version.
	 *
	 * @return the uuid of this app builder app version
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this app builder app version.
	 *
	 * @param uuid the uuid of this app builder app version
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the app builder app version ID of this app builder app version.
	 *
	 * @return the app builder app version ID of this app builder app version
	 */
	public long getAppBuilderAppVersionId();

	/**
	 * Sets the app builder app version ID of this app builder app version.
	 *
	 * @param appBuilderAppVersionId the app builder app version ID of this app builder app version
	 */
	public void setAppBuilderAppVersionId(long appBuilderAppVersionId);

	/**
	 * Returns the group ID of this app builder app version.
	 *
	 * @return the group ID of this app builder app version
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this app builder app version.
	 *
	 * @param groupId the group ID of this app builder app version
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this app builder app version.
	 *
	 * @return the company ID of this app builder app version
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this app builder app version.
	 *
	 * @param companyId the company ID of this app builder app version
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this app builder app version.
	 *
	 * @return the user ID of this app builder app version
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this app builder app version.
	 *
	 * @param userId the user ID of this app builder app version
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this app builder app version.
	 *
	 * @return the user uuid of this app builder app version
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this app builder app version.
	 *
	 * @param userUuid the user uuid of this app builder app version
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this app builder app version.
	 *
	 * @return the user name of this app builder app version
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this app builder app version.
	 *
	 * @param userName the user name of this app builder app version
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this app builder app version.
	 *
	 * @return the create date of this app builder app version
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this app builder app version.
	 *
	 * @param createDate the create date of this app builder app version
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this app builder app version.
	 *
	 * @return the modified date of this app builder app version
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this app builder app version.
	 *
	 * @param modifiedDate the modified date of this app builder app version
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the app builder app ID of this app builder app version.
	 *
	 * @return the app builder app ID of this app builder app version
	 */
	public long getAppBuilderAppId();

	/**
	 * Sets the app builder app ID of this app builder app version.
	 *
	 * @param appBuilderAppId the app builder app ID of this app builder app version
	 */
	public void setAppBuilderAppId(long appBuilderAppId);

	/**
	 * Returns the ddl record set ID of this app builder app version.
	 *
	 * @return the ddl record set ID of this app builder app version
	 */
	public long getDdlRecordSetId();

	/**
	 * Sets the ddl record set ID of this app builder app version.
	 *
	 * @param ddlRecordSetId the ddl record set ID of this app builder app version
	 */
	public void setDdlRecordSetId(long ddlRecordSetId);

	/**
	 * Returns the ddm structure ID of this app builder app version.
	 *
	 * @return the ddm structure ID of this app builder app version
	 */
	public long getDdmStructureId();

	/**
	 * Sets the ddm structure ID of this app builder app version.
	 *
	 * @param ddmStructureId the ddm structure ID of this app builder app version
	 */
	public void setDdmStructureId(long ddmStructureId);

	/**
	 * Returns the ddm structure layout ID of this app builder app version.
	 *
	 * @return the ddm structure layout ID of this app builder app version
	 */
	public long getDdmStructureLayoutId();

	/**
	 * Sets the ddm structure layout ID of this app builder app version.
	 *
	 * @param ddmStructureLayoutId the ddm structure layout ID of this app builder app version
	 */
	public void setDdmStructureLayoutId(long ddmStructureLayoutId);

	/**
	 * Returns the version of this app builder app version.
	 *
	 * @return the version of this app builder app version
	 */
	@AutoEscape
	public String getVersion();

	/**
	 * Sets the version of this app builder app version.
	 *
	 * @param version the version of this app builder app version
	 */
	public void setVersion(String version);

}