/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.app.builder.deploy;

import com.liferay.app.builder.model.AppBuilderApp;
import com.liferay.app.builder.service.AppBuilderAppLocalService;

import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;
import org.osgi.framework.ServiceRegistration;

/**
 * @author Jeyvison Nascimento
 */
@ProviderType
public interface AppDeployer {

	public void deploy(long appId) throws Exception;

	public default boolean undeploy(
			AppBuilderAppLocalService appBuilderAppLocalService, long appId,
			Map<Long, ServiceRegistration<?>[]> serviceRegistrationsMap)
		throws Exception {

		ServiceRegistration<?>[] serviceRegistrations =
			serviceRegistrationsMap.remove(appId);

		if (serviceRegistrations == null) {
			return false;
		}

		for (ServiceRegistration<?> serviceRegistration :
				serviceRegistrations) {

			serviceRegistration.unregister();
		}

		AppBuilderApp appBuilderApp =
			appBuilderAppLocalService.getAppBuilderApp(appId);

		appBuilderApp.setActive(false);

		appBuilderAppLocalService.updateAppBuilderApp(appBuilderApp);

		return true;
	}

	public void undeploy(long appId) throws Exception;

}