/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.app.builder.portlet.tab;

import com.liferay.app.builder.model.AppBuilderApp;

import java.util.List;

import org.osgi.annotation.versioning.ProviderType;

/**
 * @author Inácio Nery
 */
@ProviderType
public interface AppBuilderAppPortletTab {

	public AppBuilderAppPortletTabContext getAppBuilderAppPortletTabContext(
		AppBuilderApp appBuilderApp, long dataRecordId);

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getAppBuilderAppPortletTabContext(AppBuilderApp, long)}
	 */
	@Deprecated
	public default List<Long> getDataLayoutIds(
		AppBuilderApp appBuilderApp, long dataRecordId) {

		AppBuilderAppPortletTabContext appBuilderAppPortletTabContext =
			getAppBuilderAppPortletTabContext(appBuilderApp, dataRecordId);

		return appBuilderAppPortletTabContext.getDataLayoutIds();
	}

	public String getEditEntryPoint();

	public String getListEntryPoint();

	public String getViewEntryPoint();

}