/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.analytics.settings.rest.internal.dto.v1_0.converter;

import com.liferay.analytics.settings.rest.dto.v1_0.ContactUserGroup;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;

import org.osgi.service.component.annotations.Component;

/**
 * @author Riccardo Ferrari
 */
@Component(
	property = "dto.class.name=com.liferay.portal.kernel.model.UserGroup",
	service = {ContactUserGroupDTOConverter.class, DTOConverter.class}
)
public class ContactUserGroupDTOConverter
	implements DTOConverter<UserGroup, ContactUserGroup> {

	@Override
	public String getContentType() {
		return ContactUserGroup.class.getSimpleName();
	}

	@Override
	public ContactUserGroup toDTO(
			DTOConverterContext dtoConverterContext, UserGroup userGroup)
		throws Exception {

		ContactUserGroupDTOConverterContext
			contactUserGroupDTOConverterContext =
				(ContactUserGroupDTOConverterContext)dtoConverterContext;

		return new ContactUserGroup() {
			{
				id = userGroup.getUserGroupId();
				name = userGroup.getName();
				selected = contactUserGroupDTOConverterContext.isSelected(
					String.valueOf(userGroup.getUserGroupId()));
			}
		};
	}

}