/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.rest.internal.resource.v1_0;

import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.dto.v1_0.RecommendationConfiguration;
import com.liferay.analytics.settings.rest.dto.v1_0.RecommendationItem;
import com.liferay.analytics.settings.rest.internal.client.AnalyticsCloudClient;
import com.liferay.analytics.settings.rest.internal.resource.v1_0.BaseRecommendationConfigurationResourceImpl;
import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.analytics.settings.rest.resource.v1_0.RecommendationConfigurationResource;
import com.liferay.dispatch.executor.DispatchTaskStatus;
import com.liferay.dispatch.model.DispatchLog;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.dispatch.service.DispatchLogLocalService;
import com.liferay.dispatch.service.DispatchTriggerLocalService;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparatorFactoryUtil;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/recommendation-configuration.properties"}, scope=ServiceScope.PROTOTYPE, service={RecommendationConfigurationResource.class})
public class RecommendationConfigurationResourceImpl
extends BaseRecommendationConfigurationResourceImpl {
    private AnalyticsCloudClient _analyticsCloudClient;
    @Reference
    private AnalyticsSettingsManager _analyticsSettingsManager;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private DispatchLogLocalService _dispatchLogLocalService;
    @Reference
    private DispatchTriggerLocalService _dispatchTriggerLocalService;
    @Reference
    private Http _http;
    private RecommendationConfiguration _recommendationConfiguration;

    @Override
    public RecommendationConfiguration getRecommendationConfiguration() throws Exception {
        if (this._recommendationConfiguration != null) {
            return this._recommendationConfiguration;
        }
        final AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        return new RecommendationConfiguration(){
            {
                this.setContentRecommenderMostPopularItems(() -> new RecommendationItem(){
                    {
                        this.setEnabled(() -> ((AnalyticsConfiguration)analyticsConfiguration).contentRecommenderMostPopularItemsEnabled());
                        this.setStatus(() -> RecommendationConfigurationResourceImpl.this._getStatus("analytics-download-most-viewed-content-recommendation"));
                    }
                });
                this.setContentRecommenderUserPersonalization(() -> new RecommendationItem(){
                    {
                        this.setEnabled(() -> ((AnalyticsConfiguration)analyticsConfiguration).contentRecommenderUserPersonalizationEnabled());
                        this.setStatus(() -> RecommendationConfigurationResourceImpl.this._getStatus("analytics-download-user-content-recommendation"));
                    }
                });
            }
        };
    }

    @Override
    public void putRecommendationConfiguration(RecommendationConfiguration recommendationConfiguration) throws Exception {
        this._analyticsCloudClient.updateAnalyticsDataSourceDetails((AnalyticsConfiguration)this._configurationProvider.getCompanyConfiguration(AnalyticsConfiguration.class, this.contextCompany.getCompanyId()), this._isEnabled(recommendationConfiguration.getContentRecommenderMostPopularItems()), (Boolean)this._isEnabled(recommendationConfiguration.getContentRecommenderUserPersonalization()));
        this._analyticsSettingsManager.updateCompanyConfiguration(this.contextCompany.getCompanyId(), (Map)HashMapBuilder.put((Object)"contentRecommenderMostPopularItemsEnabled", (Object)this._isEnabled(recommendationConfiguration.getContentRecommenderMostPopularItems())).put((Object)"contentRecommenderUserPersonalizationEnabled", (Object)this._isEnabled(recommendationConfiguration.getContentRecommenderUserPersonalization())).build());
        this._recommendationConfiguration = recommendationConfiguration;
    }

    @Activate
    protected void activate() {
        this._analyticsCloudClient = new AnalyticsCloudClient(this._http);
    }

    private RecommendationItem.Status _getStatus(String name) {
        DispatchTrigger dispatchTrigger = this._dispatchTriggerLocalService.fetchDispatchTrigger(this.contextCompany.getCompanyId(), name);
        if (dispatchTrigger == null) {
            return RecommendationItem.Status.DISABLED;
        }
        List dispatchLogs = this._dispatchLogLocalService.getDispatchLogs(dispatchTrigger.getDispatchTriggerId(), 0, 1, OrderByComparatorFactoryUtil.create((String)"DispatchLog", (Object[])new Object[]{"startDate", "true"}));
        if (ListUtil.isEmpty((List)dispatchLogs)) {
            return RecommendationItem.Status.CONFIGURING;
        }
        DispatchLog dispatchLog = (DispatchLog)dispatchLogs.get(0);
        DispatchTaskStatus dispatchTaskStatus = DispatchTaskStatus.valueOf((int)dispatchLog.getStatus());
        if (dispatchTaskStatus == DispatchTaskStatus.FAILED) {
            return RecommendationItem.Status.FAILED;
        }
        if (dispatchTaskStatus == DispatchTaskStatus.IN_PROGRESS) {
            return RecommendationItem.Status.CONFIGURING;
        }
        if (dispatchTaskStatus == DispatchTaskStatus.SUCCESSFUL) {
            return RecommendationItem.Status.ENABLED;
        }
        return RecommendationItem.Status.DISABLED;
    }

    private boolean _isEnabled(RecommendationItem recommendationItem) {
        return recommendationItem.getEnabled();
    }
}

