/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.rest.internal.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.internal.client.exception.DataSourceConnectionException;
import com.liferay.analytics.settings.rest.internal.client.model.AnalyticsChannel;
import com.liferay.analytics.settings.rest.internal.client.model.AnalyticsDataSource;
import com.liferay.analytics.settings.rest.internal.client.pagination.Page;
import com.liferay.analytics.settings.rest.internal.client.pagination.Pagination;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class AnalyticsCloudClient {
    private static final Log _log = LogFactoryUtil.getLog(AnalyticsCloudClient.class);
    private static final Map<String, Object> _connectionProperties = new ConcurrentHashMap<String, Object>();
    private final Http _http;

    public AnalyticsCloudClient(Http http) {
        this._http = http;
    }

    public AnalyticsChannel addAnalyticsChannel(AnalyticsConfiguration analyticsConfiguration, String name) throws Exception {
        Http.Options options = this._getOptions(analyticsConfiguration);
        options.addHeader("Content-Type", "application/json");
        options.setBody(JSONUtil.put((String)"name", (Object)name).toString(), "application/json", "UTF-8");
        options.setLocation(analyticsConfiguration.liferayAnalyticsFaroBackendURL() + "/api/1.0/channels");
        options.setPost(true);
        String content = this._http.URLtoString(options);
        Http.Response response = options.getResponse();
        if (response.getResponseCode() == 200) {
            TypeFactory typeFactory = TypeFactory.defaultInstance();
            ObjectReader objectReader = ObjectMapperHolder._objectMapper.readerFor((JavaType)typeFactory.constructCollectionType(ArrayList.class, AnalyticsChannel.class));
            List analyticsChannels = (List)objectReader.readValue(content);
            return (AnalyticsChannel)analyticsChannels.get(0);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Response code " + response.getResponseCode()));
        }
        throw new PortalException("Unable to add Channel");
    }

    public Map<String, Object> connectAnalyticsDataSource(Company company, String connectionToken) throws Exception {
        JSONObject connectionTokenJSONObject = this._decodeToken(connectionToken);
        this._validateConnectionTokenURL(connectionTokenJSONObject.getString("url"));
        Http.Options options = new Http.Options();
        options.addPart("name", company.getName());
        options.addPart("portalURL", company.getPortalURL(0L));
        options.addPart("token", connectionTokenJSONObject.getString("token"));
        options.setLocation(connectionTokenJSONObject.getString("url"));
        options.setPost(true);
        String content = this._http.URLtoString(options);
        Http.Response response = options.getResponse();
        if (response.getResponseCode() != 200) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Response code " + response.getResponseCode()));
            }
            throw new DataSourceConnectionException("Unable to connect analytics data source");
        }
        JSONObject contentJSONObject = JSONFactoryUtil.createJSONObject((String)content);
        _connectionProperties.putAll(contentJSONObject.toMap());
        return _connectionProperties;
    }

    public AnalyticsDataSource disconnectAnalyticsDataSource(AnalyticsConfiguration analyticsConfiguration, Company company) throws Exception {
        try {
            Http.Options options = this._getOptions(analyticsConfiguration);
            options.addHeader("Content-Type", "application/json");
            options.setBody(JSONUtil.put((String)"url", (Object)company.getPortalURL(0L)).toString(), "application/json", "UTF-8");
            options.setLocation(String.format("%s/api/1.0/data-sources/%s/disconnect", analyticsConfiguration.liferayAnalyticsFaroBackendURL(), analyticsConfiguration.liferayAnalyticsDataSourceId()));
            options.setPost(true);
            String content = this._http.URLtoString(options);
            Http.Response response = options.getResponse();
            if (response.getResponseCode() == 200) {
                _connectionProperties.clear();
                return (AnalyticsDataSource)ObjectMapperHolder._objectMapper.readValue(content, AnalyticsDataSource.class);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Response code " + response.getResponseCode()));
            }
            throw new PortalException("Unable to disconnect analytics data source");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            throw new PortalException("Unable to disconnect analytics data source", (Throwable)exception);
        }
    }

    public Page<AnalyticsChannel> getAnalyticsChannelsPage(AnalyticsConfiguration analyticsConfiguration, String keywords, int page, int size, Sort[] sorts) throws Exception {
        try {
            Http.Options options = this._getOptions(analyticsConfiguration);
            String liferayAnalyticsFaroBackendURL = GetterUtil.getString((Object)_connectionProperties.get("liferayAnalyticsFaroBackendURL"), (String)analyticsConfiguration.liferayAnalyticsFaroBackendURL());
            Object url = liferayAnalyticsFaroBackendURL + "/api/1.0/channels";
            if (Validator.isNotNull((String)keywords)) {
                url = HttpComponentsUtil.addParameter((String)url, (String)"filter", (String)keywords);
            }
            url = HttpComponentsUtil.addParameter((String)url, (String)"page", (int)page);
            url = HttpComponentsUtil.addParameter((String)url, (String)"size", (int)size);
            if (ArrayUtil.isNotEmpty((Object[])sorts)) {
                StringBundler sb = new StringBundler(sorts.length * 3);
                for (Sort sort : sorts) {
                    sb.append(sort.getFieldName());
                    sb.append(",");
                    if (sort.isReverse()) {
                        sb.append("desc");
                        continue;
                    }
                    sb.append("asc");
                }
                url = HttpComponentsUtil.addParameter((String)url, (String)"sort", (String)sb.toString());
            }
            options.setLocation((String)url);
            String content = this._http.URLtoString(options);
            Http.Response response = options.getResponse();
            if (response.getResponseCode() == 200) {
                List analyticsChannels = Collections.emptyList();
                JsonNode jsonNode = ObjectMapperHolder._objectMapper.readTree(content);
                JsonNode embeddedJsonNode = jsonNode.get("_embedded");
                if (embeddedJsonNode != null) {
                    TypeFactory typeFactory = TypeFactory.defaultInstance();
                    ObjectReader objectReader = ObjectMapperHolder._objectMapper.readerFor((JavaType)typeFactory.constructCollectionType(ArrayList.class, AnalyticsChannel.class));
                    analyticsChannels = (List)objectReader.readValue(embeddedJsonNode.get("channels"));
                }
                JsonNode pageJsonNode = jsonNode.get("page");
                JsonNode totalElementsJsonNode = pageJsonNode.get("totalElements");
                return Page.of(analyticsChannels, Pagination.of(page, size), totalElementsJsonNode.asLong());
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Response code " + response.getResponseCode()));
            }
            throw new PortalException("Unable to get analytics channels page");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            throw new PortalException("Unable to get analytics channels page", (Throwable)exception);
        }
    }

    public AnalyticsChannel updateAnalyticsChannel(String analyticsChannelId, Group[] commerceChannelGroups, AnalyticsConfiguration analyticsConfiguration, String dataSourceId, Locale locale, Group[] siteGroups) throws Exception {
        try {
            if (!dataSourceId.equals(analyticsConfiguration.liferayAnalyticsDataSourceId())) {
                throw new IllegalArgumentException("Unknown data source ID");
            }
            Http.Options options = this._getOptions(analyticsConfiguration);
            options.addHeader("Content-Type", "application/json");
            options.setBody(JSONUtil.put((String)"commerceChannels", (Object)this._getGroupsJSONArray(commerceChannelGroups, locale)).put("dataSourceId", dataSourceId).put("groups", this._getGroupsJSONArray(siteGroups, locale)).toString(), "application/json", "UTF-8");
            options.setLocation(String.format("%s/api/1.0/channels/%s", analyticsConfiguration.liferayAnalyticsFaroBackendURL(), analyticsChannelId));
            options.setPatch(true);
            String content = this._http.URLtoString(options);
            Http.Response response = options.getResponse();
            if (response.getResponseCode() == 200) {
                JsonNode jsonNode = ObjectMapperHolder._objectMapper.readTree(content);
                ObjectReader objectReader = ObjectMapperHolder._objectMapper.readerFor(AnalyticsChannel.class);
                return (AnalyticsChannel)objectReader.readValue(jsonNode.get("channel"));
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Response code " + response.getResponseCode()));
            }
            throw new PortalException("Unable to update analytics channel");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            throw new PortalException("Unable to update analytics channels", (Throwable)exception);
        }
    }

    public AnalyticsDataSource updateAnalyticsDataSourceDetails(AnalyticsConfiguration analyticsConfiguration, Boolean contentRecommenderMostPopularItemsEnabled, Boolean contentRecommenderUserPersonalizationEnabled) throws Exception {
        try {
            Http.Options options = this._getOptions(analyticsConfiguration);
            options.addHeader("Content-Type", "application/json");
            options.setBody(JSONUtil.put((String)"contentRecommenderMostPopularItemsEnabled", (Object)contentRecommenderMostPopularItemsEnabled).put("contentRecommenderUserPersonalizationEnabled", (Object)contentRecommenderUserPersonalizationEnabled).toString(), "application/json", "UTF-8");
            options.setLocation(String.format("%s/api/1.0/data-sources/%s/details", analyticsConfiguration.liferayAnalyticsFaroBackendURL(), analyticsConfiguration.liferayAnalyticsDataSourceId()));
            options.setPut(true);
            String content = this._http.URLtoString(options);
            Http.Response response = options.getResponse();
            if (response.getResponseCode() == 200) {
                return (AnalyticsDataSource)ObjectMapperHolder._objectMapper.readValue(content, AnalyticsDataSource.class);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Response code " + response.getResponseCode()));
            }
            throw new PortalException("Unable to update analytics data source content recommender details");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            throw new PortalException("Unable to update analytics data source content recommender details", (Throwable)exception);
        }
    }

    public AnalyticsDataSource updateAnalyticsDataSourceDetails(Boolean accountsSelected, AnalyticsConfiguration analyticsConfiguration, Boolean contactsSelected) throws Exception {
        try {
            Http.Options options = this._getOptions(analyticsConfiguration);
            options.addHeader("Content-Type", "application/json");
            options.setBody(JSONUtil.put((String)"accountsSelected", (Object)accountsSelected).put("contactsSelected", (Object)contactsSelected).toString(), "application/json", "UTF-8");
            options.setLocation(String.format("%s/api/1.0/data-sources/%s/details", analyticsConfiguration.liferayAnalyticsFaroBackendURL(), analyticsConfiguration.liferayAnalyticsDataSourceId()));
            options.setPut(true);
            String content = this._http.URLtoString(options);
            Http.Response response = options.getResponse();
            if (response.getResponseCode() == 200) {
                return (AnalyticsDataSource)ObjectMapperHolder._objectMapper.readValue(content, AnalyticsDataSource.class);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Response code " + response.getResponseCode()));
            }
            throw new PortalException("Unable to update analytics data source details");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            throw new PortalException("Unable to update analytics data source details", (Throwable)exception);
        }
    }

    private JSONObject _decodeToken(String connectionToken) throws Exception {
        try {
            if (Validator.isBlank((String)connectionToken)) {
                throw new IllegalArgumentException();
            }
            return JSONFactoryUtil.createJSONObject((String)new String(Base64.decode((String)connectionToken)));
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to decode token", (Throwable)exception);
            throw new PortalException("Unable to decode token", (Throwable)exception);
        }
    }

    private JSONArray _getGroupsJSONArray(Group[] groups, Locale locale) throws Exception {
        return JSONUtil.toJSONArray((Object[])groups, group -> {
            if (group == null) {
                return null;
            }
            return JSONUtil.put((String)"id", () -> {
                if (!Objects.equals(group.getClassNameId(), PortalUtil.getClassNameId(Group.class)) && !Objects.equals(group.getClassNameId(), PortalUtil.getClassNameId(Organization.class))) {
                    return String.valueOf(group.getClassPK());
                }
                return String.valueOf(group.getGroupId());
            }).put("name", () -> {
                try {
                    return group.getDescriptiveName(locale);
                }
                catch (PortalException portalException) {
                    _log.error((Throwable)portalException);
                    return LanguageUtil.get((Locale)locale, (String)"unknown");
                }
            });
        });
    }

    private Http.Options _getOptions(AnalyticsConfiguration analyticsConfiguration) throws Exception {
        Http.Options options = new Http.Options();
        options.addHeader("OSB-Asah-Faro-Backend-Security-Signature", GetterUtil.getString((Object)_connectionProperties.get("liferayAnalyticsFaroBackendSecuritySignature"), (String)analyticsConfiguration.liferayAnalyticsFaroBackendSecuritySignature()));
        options.addHeader("OSB-Asah-Project-ID", GetterUtil.getString((Object)_connectionProperties.get("liferayAnalyticsProjectId"), (String)analyticsConfiguration.liferayAnalyticsProjectId()));
        return options;
    }

    private void _validateConnectionTokenURL(String url) throws Exception {
        String analyticsCloudDomainAllowed = PropsUtil.get((String)"analytics.cloud.domain.allowed");
        if (StringUtil.equals((String)analyticsCloudDomainAllowed, (String)"*")) {
            return;
        }
        String domain = HttpComponentsUtil.getDomain((String)url);
        if (InetAddressUtil.isLocalInetAddress((InetAddress)InetAddressUtil.getInetAddressByName((String)domain)) || !StringUtil.endsWith((String)domain, (String)analyticsCloudDomainAllowed)) {
            throw new DataSourceConnectionException("Invalid URL domain");
        }
    }

    private static class ObjectMapperHolder {
        private static final ObjectMapper _objectMapper = new ObjectMapper(){
            {
                this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                this.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            }
        };

        private ObjectMapperHolder() {
        }
    }
}

