/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.rest.internal.resource.v1_0;

import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.dto.v1_0.DataSourceLiferayAnalyticsURL;
import com.liferay.analytics.settings.rest.dto.v1_0.DataSourceToken;
import com.liferay.analytics.settings.rest.internal.client.AnalyticsCloudClient;
import com.liferay.analytics.settings.rest.internal.resource.v1_0.BaseDataSourceResourceImpl;
import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.analytics.settings.rest.resource.v1_0.DataSourceResource;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.Http;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/data-source.properties"}, scope=ServiceScope.PROTOTYPE, service={DataSourceResource.class})
public class DataSourceResourceImpl
extends BaseDataSourceResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(DataSourceResourceImpl.class);
    private AnalyticsCloudClient _analyticsCloudClient;
    @Reference
    private AnalyticsSettingsManager _analyticsSettingsManager;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Http _http;

    @Override
    public void deleteDataSource() throws Exception {
        block2: {
            try {
                this._analyticsCloudClient.disconnectAnalyticsDataSource((AnalyticsConfiguration)this._configurationProvider.getCompanyConfiguration(AnalyticsConfiguration.class, this.contextCompany.getCompanyId()));
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)exception);
            }
        }
        this._analyticsSettingsManager.deleteCompanyConfiguration(this.contextUser.getCompanyId());
    }

    @Override
    public DataSourceLiferayAnalyticsURL postDataSource(DataSourceToken dataSourceToken) throws Exception {
        Map<String, Object> properties = this._analyticsCloudClient.connectAnalyticsDataSource(this._companyLocalService.getCompany(this.contextUser.getCompanyId()), dataSourceToken.getToken());
        properties.put("token", dataSourceToken.getToken());
        this._analyticsSettingsManager.updateCompanyConfiguration(this.contextUser.getCompanyId(), properties);
        DataSourceLiferayAnalyticsURL dataSourceLiferayAnalyticsURL = new DataSourceLiferayAnalyticsURL();
        dataSourceLiferayAnalyticsURL.setLiferayAnalyticsURL(() -> String.valueOf(properties.get("liferayAnalyticsURL")));
        return dataSourceLiferayAnalyticsURL;
    }

    @Activate
    protected void activate() {
        this._analyticsCloudClient = new AnalyticsCloudClient(this._http);
    }
}

