/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.rest.internal.resource.v1_0;

import com.liferay.account.model.AccountEntry;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.constants.FieldAccountConstants;
import com.liferay.analytics.settings.rest.constants.FieldOrderConstants;
import com.liferay.analytics.settings.rest.constants.FieldPeopleConstants;
import com.liferay.analytics.settings.rest.constants.FieldProductConstants;
import com.liferay.analytics.settings.rest.dto.v1_0.Field;
import com.liferay.analytics.settings.rest.internal.resource.v1_0.BaseFieldResourceImpl;
import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.analytics.settings.rest.resource.v1_0.FieldResource;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/field.properties"}, scope=ServiceScope.PROTOTYPE, service={FieldResource.class})
public class FieldResourceImpl
extends BaseFieldResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(FieldResourceImpl.class);
    @Reference
    private AnalyticsSettingsManager _analyticsSettingsManager;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private Portal _portal;

    @Override
    public Page<Field> getFieldsAccountsPage(String keyword, Pagination pagination, Sort[] sorts) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        List<Field> fields = this._getFields(FieldAccountConstants.FIELD_ACCOUNT_EXAMPLES, FieldAccountConstants.FIELD_ACCOUNT_NAMES, FieldAccountConstants.FIELD_ACCOUNT_REQUIRED_NAMES, "account", this._getOrDefault(FieldAccountConstants.FIELD_ACCOUNT_DEFAULTS, analyticsConfiguration.syncedAccountFieldNames()), FieldAccountConstants.FIELD_ACCOUNT_TYPES);
        fields.addAll(this._getExpandoFields(AccountEntry.class.getName(), this.contextCompany.getCompanyId(), "account", analyticsConfiguration.syncedAccountFieldNames()));
        fields = this._filter(fields, keyword);
        fields = this._sort(fields, sorts);
        return Page.of((Collection)ListUtil.subList(fields, (int)pagination.getStartPosition(), (int)pagination.getEndPosition()), (Pagination)pagination, (long)fields.size());
    }

    @Override
    public Page<Field> getFieldsOrdersPage(String keyword, Pagination pagination, Sort[] sorts) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        List<Field> fields = this._getFields(FieldOrderConstants.FIELD_ORDER_EXAMPLES, FieldOrderConstants.FIELD_ORDER_NAMES, FieldOrderConstants.FIELD_ORDER_REQUIRED_NAMES, "order", analyticsConfiguration.syncedOrderFieldNames(), FieldOrderConstants.FIELD_ORDER_TYPES);
        fields.addAll(this._getFields(FieldOrderConstants.FIELD_ORDER_ITEM_EXAMPLES, FieldOrderConstants.FIELD_ORDER_ITEM_NAMES, FieldOrderConstants.FIELD_ORDER_ITEM_REQUIRED_NAMES, "order-item", analyticsConfiguration.syncedOrderFieldNames(), FieldOrderConstants.FIELD_ORDER_ITEM_TYPES));
        fields = this._filter(fields, keyword);
        fields = this._sort(fields, sorts);
        return Page.of((Collection)ListUtil.subList(fields, (int)pagination.getStartPosition(), (int)pagination.getEndPosition()), (Pagination)pagination, (long)fields.size());
    }

    @Override
    public Page<Field> getFieldsPeoplePage(String keyword, Pagination pagination, Sort[] sorts) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        List<Field> fields = this._getFields(FieldPeopleConstants.FIELD_CONTACT_EXAMPLES, FieldPeopleConstants.FIELD_CONTACT_NAMES, FieldPeopleConstants.FIELD_CONTACT_REQUIRED_NAMES, "contact", analyticsConfiguration.syncedContactFieldNames(), FieldPeopleConstants.FIELD_CONTACT_TYPES);
        fields.addAll(this._getFields(FieldPeopleConstants.FIELD_USER_EXAMPLES, FieldPeopleConstants.FIELD_USER_NAMES, FieldPeopleConstants.FIELD_USER_REQUIRED_NAMES, "user", analyticsConfiguration.syncedUserFieldNames(), FieldPeopleConstants.FIELD_USER_TYPES));
        fields.addAll(this._getExpandoFields(User.class.getName(), this.contextCompany.getCompanyId(), "user", analyticsConfiguration.syncedUserFieldNames()));
        fields = this._filter(fields, keyword);
        fields = this._sort(fields, sorts);
        return Page.of((Collection)ListUtil.subList(fields, (int)pagination.getStartPosition(), (int)pagination.getEndPosition()), (Pagination)pagination, (long)fields.size());
    }

    @Override
    public Page<Field> getFieldsProductsPage(String keyword, Pagination pagination, Sort[] sorts) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        List<Field> fields = this._getFields(FieldProductConstants.FIELD_CATEGORY_EXAMPLES, FieldProductConstants.FIELD_CATEGORY_NAMES, FieldProductConstants.FIELD_CATEGORY_REQUIRED_NAMES, "category", analyticsConfiguration.syncedCategoryFieldNames(), FieldProductConstants.FIELD_CATEGORY_TYPES);
        fields.addAll(this._getFields(FieldProductConstants.FIELD_PRODUCT_EXAMPLES, FieldProductConstants.FIELD_PRODUCT_NAMES, FieldProductConstants.FIELD_PRODUCT_REQUIRED_NAMES, "product", analyticsConfiguration.syncedProductFieldNames(), FieldProductConstants.FIELD_PRODUCT_TYPES));
        fields.addAll(this._getFields(FieldProductConstants.FIELD_PRODUCT_CHANNEL_EXAMPLES, FieldProductConstants.FIELD_PRODUCT_CHANNEL_NAMES, FieldProductConstants.FIELD_PRODUCT_CHANNEL_REQUIRED_NAMES, "product-channel", analyticsConfiguration.syncedProductChannelFieldNames(), FieldProductConstants.FIELD_PRODUCT_CHANNEL_TYPES));
        fields = this._filter(fields, keyword);
        fields = this._sort(fields, sorts);
        return Page.of((Collection)ListUtil.subList(fields, (int)pagination.getStartPosition(), (int)pagination.getEndPosition()), (Pagination)pagination, (long)fields.size());
    }

    @Override
    public void patchFieldAccount(Field[] fields) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        this._analyticsSettingsManager.updateCompanyConfiguration(this.contextCompany.getCompanyId(), (Map)HashMapBuilder.put((Object)"syncedAccountFieldNames", (Object)this._updateSelectedFields(analyticsConfiguration.syncedAccountFieldNames(), fields, FieldAccountConstants.FIELD_ACCOUNT_REQUIRED_NAMES, "account", (String[])ArrayUtil.append((Object[])FieldAccountConstants.FIELD_ACCOUNT_NAMES, (Object[])this._getExpandoFieldNames(AccountEntry.class.getName(), this.contextCompany.getCompanyId())))).build());
    }

    @Override
    public void patchFieldOrder(Field[] fields) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        this._analyticsSettingsManager.updateCompanyConfiguration(this.contextCompany.getCompanyId(), (Map)HashMapBuilder.put((Object)"syncedOrderFieldNames", (Object)this._updateSelectedFields(analyticsConfiguration.syncedOrderFieldNames(), fields, FieldOrderConstants.FIELD_ORDER_REQUIRED_NAMES, "order", FieldOrderConstants.FIELD_ORDER_NAMES)).put((Object)"syncedOrderItemFieldNames", (Object)this._updateSelectedFields(analyticsConfiguration.syncedOrderItemFieldNames(), fields, FieldOrderConstants.FIELD_ORDER_ITEM_REQUIRED_NAMES, "order-item", FieldOrderConstants.FIELD_ORDER_ITEM_NAMES)).build());
    }

    @Override
    public void patchFieldPeople(Field[] fields) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        this._analyticsSettingsManager.updateCompanyConfiguration(this.contextCompany.getCompanyId(), (Map)HashMapBuilder.put((Object)"syncedContactFieldNames", (Object)this._updateSelectedFields(analyticsConfiguration.syncedContactFieldNames(), fields, FieldPeopleConstants.FIELD_CONTACT_REQUIRED_NAMES, "contact", FieldPeopleConstants.FIELD_CONTACT_NAMES)).put((Object)"syncedUserFieldNames", (Object)this._updateSelectedFields(analyticsConfiguration.syncedUserFieldNames(), fields, FieldPeopleConstants.FIELD_USER_REQUIRED_NAMES, "user", (String[])ArrayUtil.append((Object[])FieldPeopleConstants.FIELD_USER_NAMES, (Object[])this._getExpandoFieldNames(User.class.getName(), this.contextCompany.getCompanyId())))).build());
    }

    @Override
    public void patchFieldProduct(Field[] fields) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        this._analyticsSettingsManager.updateCompanyConfiguration(this.contextCompany.getCompanyId(), (Map)HashMapBuilder.put((Object)"syncedCategoryFieldNames", (Object)this._updateSelectedFields(analyticsConfiguration.syncedCategoryFieldNames(), fields, FieldProductConstants.FIELD_CATEGORY_REQUIRED_NAMES, "category", FieldProductConstants.FIELD_CATEGORY_NAMES)).put((Object)"syncedProductChannelFieldNames", (Object)this._updateSelectedFields(analyticsConfiguration.syncedProductChannelFieldNames(), fields, FieldProductConstants.FIELD_PRODUCT_CHANNEL_REQUIRED_NAMES, "product-channel", FieldProductConstants.FIELD_PRODUCT_CHANNEL_NAMES)).put((Object)"syncedProductFieldNames", (Object)this._updateSelectedFields(analyticsConfiguration.syncedProductFieldNames(), fields, FieldProductConstants.FIELD_PRODUCT_REQUIRED_NAMES, "product", FieldProductConstants.FIELD_PRODUCT_NAMES)).build());
    }

    private List<Field> _filter(List<Field> fields, String keywords) {
        if (keywords == null) {
            return fields;
        }
        return ListUtil.filter(fields, field -> {
            String name = field.getName();
            return name.matches("(?i).*" + keywords + ".*");
        });
    }

    private String _getDataType(int type) {
        if (type == 1 || type == 2) {
            return "Boolean";
        }
        if (type == 3 || type == 4) {
            return "Date";
        }
        if (type == 5 || type == 6 || type == 7 || type == 8) {
            return "Decimal";
        }
        if (type == 9 || type == 10) {
            return "Integer";
        }
        if (type == 11 || type == 12) {
            return "Long";
        }
        if (type == 17 || type == 18 || type == 13 || type == 14) {
            return "Number";
        }
        return "String";
    }

    private String[] _getExpandoFieldNames(String className, long companyId) {
        ExpandoTable expandoTable = this._expandoTableLocalService.fetchTable(companyId, this._portal.getClassNameId(className), "CUSTOM_FIELDS");
        if (expandoTable == null) {
            return new String[0];
        }
        return this.transformToArray(this._expandoColumnLocalService.getColumns(expandoTable.getTableId()), expandoColumn -> expandoColumn.getName(), String.class);
    }

    private List<Field> _getExpandoFields(String className, long companyId, String source, String[] syncedNames) {
        ExpandoTable expandoTable = this._expandoTableLocalService.fetchTable(companyId, this._portal.getClassNameId(className), "CUSTOM_FIELDS");
        if (expandoTable == null) {
            return Collections.emptyList();
        }
        return this.transform(this._expandoColumnLocalService.getColumns(expandoTable.getTableId()), expandoColumn -> {
            Field field = new Field((ExpandoColumn)expandoColumn, syncedNames){
                final /* synthetic */ ExpandoColumn val$expandoColumn;
                final /* synthetic */ String[] val$syncedNames;
                {
                    this.val$expandoColumn = expandoColumn;
                    this.val$syncedNames = stringArray;
                    this.setName(() -> ((ExpandoColumn)this.val$expandoColumn).getName());
                    this.setRequired(() -> Boolean.FALSE);
                    this.setSelected(() -> ArrayUtil.contains((Object[])this.val$syncedNames, (Object)this.val$expandoColumn.getName()));
                    this.setType(() -> FieldResourceImpl.this._getDataType(this.val$expandoColumn.getType()));
                }
            };
            field.setSource(() -> source);
            return field;
        });
    }

    private List<Field> _getFields(final String[] examples, final String[] names, final String[] requiredNames, String source, final String[] syncedNames, final String[] types) {
        ArrayList<Field> fields = new ArrayList<Field>();
        int i = 0;
        while (i < names.length) {
            final int index = i++;
            Field field = new Field(){
                {
                    this.setExample(() -> examples[index]);
                    this.setName(() -> names[index]);
                    this.setRequired(() -> ArrayUtil.contains((Object[])requiredNames, (Object)names[index]));
                    this.setSelected(() -> ArrayUtil.contains((Object[])syncedNames, (Object)names[index]) || ArrayUtil.contains((Object[])requiredNames, (Object)names[index]));
                    this.setType(() -> types[index]);
                }
            };
            field.setSource(() -> source);
            fields.add(field);
        }
        return fields;
    }

    private String[] _getOrDefault(String[] defaultFieldNames, String[] fieldNames) {
        if (fieldNames != null && fieldNames.length > 0) {
            return fieldNames;
        }
        return defaultFieldNames;
    }

    private List<Field> _sort(List<Field> fields, Sort[] sorts) {
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            return fields;
        }
        Comparator<Field> fieldComparator = null;
        for (Sort sort : sorts) {
            if (!Objects.equals(sort.getFieldName(), "name") && !Objects.equals(sort.getFieldName(), "type")) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Skipping unsupported sort field: " + sort.getFieldName()));
                continue;
            }
            fieldComparator = Objects.equals(sort.getFieldName(), "name") ? Comparator.comparing(field -> StringUtil.toLowerCase((String)field.getName())) : Comparator.comparing(field -> StringUtil.toLowerCase((String)field.getType()));
            if (!sort.isReverse()) continue;
            fieldComparator = fieldComparator.reversed();
        }
        if (fieldComparator != null) {
            fields.sort(fieldComparator);
        }
        return fields;
    }

    private String[] _updateSelectedFields(String[] configurationFieldNames, Field[] fields, String[] requiredFieldNames, String source, String[] validateFieldNames) {
        HashSet<String> selectedFieldNames = new HashSet<String>(Arrays.asList(configurationFieldNames));
        for (Field field : fields) {
            if (!Objects.equals(source, field.getSource())) continue;
            if (!field.getSelected().booleanValue()) {
                selectedFieldNames.remove(field.getName());
                continue;
            }
            if (!ArrayUtil.contains((Object[])validateFieldNames, (Object)field.getName())) continue;
            selectedFieldNames.add(field.getName());
        }
        Collections.addAll(selectedFieldNames, requiredFieldNames);
        return selectedFieldNames.toArray(new String[0]);
    }
}

