/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.rest.internal.resource.v1_0;

import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.dto.v1_0.RecommendationConfiguration;
import com.liferay.analytics.settings.rest.internal.client.AnalyticsCloudClient;
import com.liferay.analytics.settings.rest.internal.resource.v1_0.BaseRecommendationConfigurationResourceImpl;
import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.analytics.settings.rest.resource.v1_0.RecommendationConfigurationResource;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Http;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/recommendation-configuration.properties"}, scope=ServiceScope.PROTOTYPE, service={RecommendationConfigurationResource.class})
public class RecommendationConfigurationResourceImpl
extends BaseRecommendationConfigurationResourceImpl {
    private AnalyticsCloudClient _analyticsCloudClient;
    @Reference
    private AnalyticsSettingsManager _analyticsSettingsManager;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Http _http;
    private RecommendationConfiguration _recommendationConfiguration;

    @Override
    public RecommendationConfiguration getRecommendationConfiguration() throws Exception {
        if (this._recommendationConfiguration != null) {
            return this._recommendationConfiguration;
        }
        final AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        return new RecommendationConfiguration(){
            {
                this.setContentRecommenderMostPopularItemsEnabled(() -> ((AnalyticsConfiguration)analyticsConfiguration).contentRecommenderMostPopularItemsEnabled());
                this.setContentRecommenderUserPersonalizationEnabled(() -> ((AnalyticsConfiguration)analyticsConfiguration).contentRecommenderUserPersonalizationEnabled());
            }
        };
    }

    @Override
    public void putRecommendationConfiguration(RecommendationConfiguration recommendationConfiguration) throws Exception {
        this._analyticsCloudClient.updateAnalyticsDataSourceDetails((AnalyticsConfiguration)this._configurationProvider.getCompanyConfiguration(AnalyticsConfiguration.class, this.contextCompany.getCompanyId()), recommendationConfiguration.getContentRecommenderMostPopularItemsEnabled(), recommendationConfiguration.getContentRecommenderUserPersonalizationEnabled());
        this._analyticsSettingsManager.updateCompanyConfiguration(this.contextCompany.getCompanyId(), (Map)HashMapBuilder.put((Object)"contentRecommenderMostPopularItemsEnabled", (Object)recommendationConfiguration.getContentRecommenderMostPopularItemsEnabled()).put((Object)"contentRecommenderUserPersonalizationEnabled", (Object)recommendationConfiguration.getContentRecommenderUserPersonalizationEnabled()).build());
        this._recommendationConfiguration = recommendationConfiguration;
    }

    @Activate
    protected void activate() {
        this._analyticsCloudClient = new AnalyticsCloudClient(this._http);
    }
}

