/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.rest.internal.resource.v1_0;

import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.dto.v1_0.ContactConfiguration;
import com.liferay.analytics.settings.rest.internal.client.AnalyticsCloudClient;
import com.liferay.analytics.settings.rest.internal.resource.v1_0.BaseContactConfigurationResourceImpl;
import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.analytics.settings.rest.resource.v1_0.ContactConfigurationResource;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Http;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/contact-configuration.properties"}, scope=ServiceScope.PROTOTYPE, service={ContactConfigurationResource.class})
public class ContactConfigurationResourceImpl
extends BaseContactConfigurationResourceImpl {
    private AnalyticsCloudClient _analyticsCloudClient;
    @Reference
    private AnalyticsSettingsManager _analyticsSettingsManager;
    @Reference
    private ConfigurationProvider _configurationProvider;
    private ContactConfiguration _contactConfiguration;
    @Reference
    private Http _http;

    @Override
    public ContactConfiguration getContactConfiguration() throws Exception {
        if (this._contactConfiguration != null) {
            return this._contactConfiguration;
        }
        final AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        return new ContactConfiguration(){
            {
                this.setSyncAllAccounts(() -> ((AnalyticsConfiguration)analyticsConfiguration).syncAllAccounts());
                this.setSyncAllContacts(() -> ((AnalyticsConfiguration)analyticsConfiguration).syncAllContacts());
                this.setSyncedAccountGroupIds(() -> ((AnalyticsConfiguration)analyticsConfiguration).syncedAccountGroupIds());
                this.setSyncedOrganizationIds(() -> ((AnalyticsConfiguration)analyticsConfiguration).syncedOrganizationIds());
                this.setSyncedUserGroupIds(() -> ((AnalyticsConfiguration)analyticsConfiguration).syncedUserGroupIds());
            }
        };
    }

    @Override
    public void putContactConfiguration(ContactConfiguration contactConfiguration) throws Exception {
        boolean accountsSelected = false;
        if (contactConfiguration.getSyncAllAccounts().booleanValue() || !ArrayUtil.isEmpty((Object[])contactConfiguration.getSyncedAccountGroupIds())) {
            accountsSelected = true;
        }
        boolean contactsSelected = false;
        if (contactConfiguration.getSyncAllContacts().booleanValue() || !ArrayUtil.isEmpty((Object[])contactConfiguration.getSyncedOrganizationIds()) || !ArrayUtil.isEmpty((Object[])contactConfiguration.getSyncedUserGroupIds())) {
            contactsSelected = true;
        }
        this._analyticsCloudClient.updateAnalyticsDataSourceDetails(accountsSelected, (AnalyticsConfiguration)this._configurationProvider.getCompanyConfiguration(AnalyticsConfiguration.class, this.contextCompany.getCompanyId()), null, contactsSelected, null);
        this._analyticsSettingsManager.updateCompanyConfiguration(this.contextCompany.getCompanyId(), (Map)HashMapBuilder.put((Object)"syncAllAccounts", (Object)contactConfiguration.getSyncAllAccounts()).put((Object)"syncAllContacts", (Object)contactConfiguration.getSyncAllContacts()).put((Object)"syncedAccountGroupIds", (Object)contactConfiguration.getSyncedAccountGroupIds()).put((Object)"syncedOrganizationIds", (Object)contactConfiguration.getSyncedOrganizationIds()).put((Object)"syncedUserGroupIds", (Object)contactConfiguration.getSyncedUserGroupIds()).build());
        this._contactConfiguration = contactConfiguration;
    }

    @Activate
    protected void activate() {
        this._analyticsCloudClient = new AnalyticsCloudClient(this._http);
    }
}

