/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.rest.internal.util.comparator;

import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.util.CollatorUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.Collator;
import java.util.Locale;

public class IgnoreCaseOrderByComparator<T>
extends OrderByComparator<T> {
    private final Object[] _columns;
    private final Locale _locale;

    public IgnoreCaseOrderByComparator(Object[] columns, Locale locale) {
        if (columns.length == 0 || columns.length % 2 != 0) {
            throw new IllegalArgumentException("Columns length is not an even number");
        }
        this._columns = columns;
        this._locale = locale;
    }

    public int compare(T object1, T object2) {
        for (int i = 0; i < this._columns.length; i += 2) {
            int value;
            String columnName = String.valueOf(this._columns[i]);
            Object columnValue1 = BeanPropertiesUtil.getObjectSilent(object1, (String)columnName);
            Object columnValue2 = BeanPropertiesUtil.getObjectSilent(object2, (String)columnName);
            if (columnValue1 instanceof String && columnValue2 instanceof String) {
                String columnValue1String = (String)columnValue1;
                String columnValue2String = (String)columnValue2;
                if (Validator.isXml((String)columnValue1String)) {
                    columnValue1String = LocalizationUtil.getLocalization((String)columnValue1String, (String)this._locale.getLanguage());
                    columnValue2String = LocalizationUtil.getLocalization((String)columnValue2String, (String)this._locale.getLanguage());
                    Collator collator = CollatorUtil.getInstance((Locale)this._locale);
                    value = collator.compare(StringUtil.toLowerCase((String)columnValue1String), StringUtil.toLowerCase((String)columnValue2String));
                } else {
                    value = columnValue1String.compareToIgnoreCase(columnValue2String);
                }
            } else {
                Comparable columnValueComparable1 = (Comparable)columnValue1;
                Comparable columnValueComparable2 = (Comparable)columnValue2;
                value = columnValueComparable1.compareTo(columnValueComparable2);
            }
            if (value == 0) continue;
            boolean columnAscending = Boolean.valueOf(String.valueOf(this._columns[i + 1]));
            if (columnAscending) {
                return value;
            }
            return -value;
        }
        return 0;
    }
}

