/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.rest.internal.graphql.query.v1_0;

import com.liferay.analytics.settings.rest.dto.v1_0.Channel;
import com.liferay.analytics.settings.rest.dto.v1_0.CommerceChannel;
import com.liferay.analytics.settings.rest.dto.v1_0.Site;
import com.liferay.analytics.settings.rest.resource.v1_0.ChannelResource;
import com.liferay.analytics.settings.rest.resource.v1_0.CommerceChannelResource;
import com.liferay.analytics.settings.rest.resource.v1_0.SiteResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.ComponentServiceObjects;

public class Query {
    private static ComponentServiceObjects<ChannelResource> _channelResourceComponentServiceObjects;
    private static ComponentServiceObjects<CommerceChannelResource> _commerceChannelResourceComponentServiceObjects;
    private static ComponentServiceObjects<SiteResource> _siteResourceComponentServiceObjects;
    private AcceptLanguage _acceptLanguage;
    private Company _company;
    private BiFunction<Object, String, Filter> _filterBiFunction;
    private GroupLocalService _groupLocalService;
    private HttpServletRequest _httpServletRequest;
    private HttpServletResponse _httpServletResponse;
    private RoleLocalService _roleLocalService;
    private BiFunction<Object, String, Sort[]> _sortsBiFunction;
    private UriInfo _uriInfo;
    private User _user;

    public static void setChannelResourceComponentServiceObjects(ComponentServiceObjects<ChannelResource> channelResourceComponentServiceObjects) {
        _channelResourceComponentServiceObjects = channelResourceComponentServiceObjects;
    }

    public static void setCommerceChannelResourceComponentServiceObjects(ComponentServiceObjects<CommerceChannelResource> commerceChannelResourceComponentServiceObjects) {
        _commerceChannelResourceComponentServiceObjects = commerceChannelResourceComponentServiceObjects;
    }

    public static void setSiteResourceComponentServiceObjects(ComponentServiceObjects<SiteResource> siteResourceComponentServiceObjects) {
        _siteResourceComponentServiceObjects = siteResourceComponentServiceObjects;
    }

    @GraphQLField
    public ChannelPage channels(@GraphQLName(value="keywords") String keywords, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (ChannelPage)this._applyComponentServiceObjects(_channelResourceComponentServiceObjects, this::_populateResourceContext, channelResource -> new ChannelPage(channelResource.getChannelsPage(keywords, this._filterBiFunction.apply(channelResource, filterString), Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField
    public CommerceChannelPage commerceChannels(@GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (CommerceChannelPage)this._applyComponentServiceObjects(_commerceChannelResourceComponentServiceObjects, this::_populateResourceContext, commerceChannelResource -> new CommerceChannelPage(commerceChannelResource.getCommerceChannelsPage(Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField
    public SitePage sites(@GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (SitePage)this._applyComponentServiceObjects(_siteResourceComponentServiceObjects, this::_populateResourceContext, siteResource -> new SitePage(siteResource.getSitesPage(Pagination.of((int)page, (int)pageSize))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R, E1 extends Throwable, E2 extends Throwable> R _applyComponentServiceObjects(ComponentServiceObjects<T> componentServiceObjects, UnsafeConsumer<T, E1> unsafeConsumer, UnsafeFunction<T, R, E2> unsafeFunction) throws E1, E2 {
        Object resource = componentServiceObjects.getService();
        try {
            unsafeConsumer.accept(resource);
            Object object = unsafeFunction.apply(resource);
            return (R)object;
        }
        finally {
            componentServiceObjects.ungetService(resource);
        }
    }

    private void _populateResourceContext(ChannelResource channelResource) throws Exception {
        channelResource.setContextAcceptLanguage(this._acceptLanguage);
        channelResource.setContextCompany(this._company);
        channelResource.setContextHttpServletRequest(this._httpServletRequest);
        channelResource.setContextHttpServletResponse(this._httpServletResponse);
        channelResource.setContextUriInfo(this._uriInfo);
        channelResource.setContextUser(this._user);
        channelResource.setGroupLocalService(this._groupLocalService);
        channelResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(CommerceChannelResource commerceChannelResource) throws Exception {
        commerceChannelResource.setContextAcceptLanguage(this._acceptLanguage);
        commerceChannelResource.setContextCompany(this._company);
        commerceChannelResource.setContextHttpServletRequest(this._httpServletRequest);
        commerceChannelResource.setContextHttpServletResponse(this._httpServletResponse);
        commerceChannelResource.setContextUriInfo(this._uriInfo);
        commerceChannelResource.setContextUser(this._user);
        commerceChannelResource.setGroupLocalService(this._groupLocalService);
        commerceChannelResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(SiteResource siteResource) throws Exception {
        siteResource.setContextAcceptLanguage(this._acceptLanguage);
        siteResource.setContextCompany(this._company);
        siteResource.setContextHttpServletRequest(this._httpServletRequest);
        siteResource.setContextHttpServletResponse(this._httpServletResponse);
        siteResource.setContextUriInfo(this._uriInfo);
        siteResource.setContextUser(this._user);
        siteResource.setGroupLocalService(this._groupLocalService);
        siteResource.setRoleLocalService(this._roleLocalService);
    }

    @GraphQLName(value="SitePage")
    public class SitePage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Site> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public SitePage(Page sitePage) {
            this.actions = sitePage.getActions();
            this.items = sitePage.getItems();
            this.lastPage = sitePage.getLastPage();
            this.page = sitePage.getPage();
            this.pageSize = sitePage.getPageSize();
            this.totalCount = sitePage.getTotalCount();
        }
    }

    @GraphQLName(value="CommerceChannelPage")
    public class CommerceChannelPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<CommerceChannel> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public CommerceChannelPage(Page commerceChannelPage) {
            this.actions = commerceChannelPage.getActions();
            this.items = commerceChannelPage.getItems();
            this.lastPage = commerceChannelPage.getLastPage();
            this.page = commerceChannelPage.getPage();
            this.pageSize = commerceChannelPage.getPageSize();
            this.totalCount = commerceChannelPage.getTotalCount();
        }
    }

    @GraphQLName(value="ChannelPage")
    public class ChannelPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Channel> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public ChannelPage(Page channelPage) {
            this.actions = channelPage.getActions();
            this.items = channelPage.getItems();
            this.lastPage = channelPage.getLastPage();
            this.page = channelPage.getPage();
            this.pageSize = channelPage.getPageSize();
            this.totalCount = channelPage.getTotalCount();
        }
    }
}

