/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.analytics.settings.rest.internal.dto.v1_0.converter;

import com.liferay.analytics.settings.rest.dto.v1_0.CommerceChannel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Riccardo Ferrari
 */
@Component(
	property = "dto.class.name=com.liferay.portal.kernel.model.Group",
	service = {CommerceChannelDTOConverter.class, DTOConverter.class}
)
public class CommerceChannelDTOConverter
	implements DTOConverter<Group, CommerceChannel> {

	@Override
	public String getContentType() {
		return CommerceChannel.class.getSimpleName();
	}

	@Override
	public CommerceChannel toDTO(
			DTOConverterContext dtoConverterContext, Group group)
		throws Exception {

		CommerceChannelDTOConverterContext commerceChannelDTOConverterContext =
			(CommerceChannelDTOConverterContext)dtoConverterContext;

		UnicodeProperties typeSettingsUnicodeProperties =
			group.getTypeSettingsProperties();

		return new CommerceChannel() {
			{
				id = group.getGroupId();
				name = group.getDescriptiveName();

				setChannelName(
					() -> {
						String analyticsChannelId =
							typeSettingsUnicodeProperties.getProperty(
								"analyticsChannelId", null);

						return commerceChannelDTOConverterContext.
							getChannelName(
								GetterUtil.getLong(analyticsChannelId));
					});
				setSiteName(
					() -> {
						String siteGroupId =
							typeSettingsUnicodeProperties.getProperty(
								"siteGroupId", null);

						if (siteGroupId == null) {
							return null;
						}

						Group siteGroup = _groupLocalService.getGroup(
							GetterUtil.getLong(siteGroupId));

						return siteGroup.getDescriptiveName();
					});
			}
		};
	}

	@Reference
	private GroupLocalService _groupLocalService;

}