/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.rest.internal.resource.v1_0;

import com.liferay.analytics.settings.rest.dto.v1_0.DataSourceToken;
import com.liferay.analytics.settings.rest.internal.client.AnalyticsCloudClient;
import com.liferay.analytics.settings.rest.internal.resource.v1_0.BaseDataSourceResourceImpl;
import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.analytics.settings.rest.resource.v1_0.DataSourceResource;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/data-source.properties"}, scope=ServiceScope.PROTOTYPE, service={DataSourceResource.class})
public class DataSourceResourceImpl
extends BaseDataSourceResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(DataSourceResourceImpl.class);
    @Reference
    private AnalyticsCloudClient _analyticsCloudClient;
    @Reference
    private AnalyticsSettingsManager _analyticsSettingsManager;

    @Override
    public void deleteDataSource() throws Exception {
        block2: {
            try {
                this._analyticsCloudClient.disconnectAnalyticsDataSource(this.contextCompany.getCompanyId());
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)exception);
            }
        }
        this._analyticsSettingsManager.deleteCompanyConfiguration(this.contextUser.getCompanyId());
    }

    @Override
    public void postDataSource(DataSourceToken dataSourceToken) throws Exception {
        Map<String, Object> properties = this._analyticsCloudClient.connectAnalyticsDataSource(this.contextUser.getCompanyId(), dataSourceToken.getToken());
        properties.put("token", dataSourceToken.getToken());
        this._analyticsSettingsManager.updateCompanyConfiguration(this.contextUser.getCompanyId(), properties);
    }
}

