/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.rest.internal.resource.v1_0;

import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.dto.v1_0.ContactConfiguration;
import com.liferay.analytics.settings.rest.internal.client.AnalyticsCloudClient;
import com.liferay.analytics.settings.rest.internal.resource.v1_0.BaseContactConfigurationResourceImpl;
import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.analytics.settings.rest.resource.v1_0.ContactConfigurationResource;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/contact-configuration.properties"}, scope=ServiceScope.PROTOTYPE, service={ContactConfigurationResource.class})
public class ContactConfigurationResourceImpl
extends BaseContactConfigurationResourceImpl {
    @Reference
    private AnalyticsCloudClient _analyticsCloudClient;
    @Reference
    private AnalyticsSettingsManager _analyticsSettingsManager;

    @Override
    public ContactConfiguration getContactConfiguration() throws Exception {
        final AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        return new ContactConfiguration(){
            {
                this.syncAllAccounts = analyticsConfiguration.syncAllAccounts();
                this.syncAllContacts = analyticsConfiguration.syncAllContacts();
                this.syncedAccountGroupIds = analyticsConfiguration.syncedAccountGroupIds();
                this.syncedOrganizationIds = analyticsConfiguration.syncedOrganizationIds();
                this.syncedUserGroupIds = analyticsConfiguration.syncedUserGroupIds();
            }
        };
    }

    @Override
    public void putContactConfiguration(ContactConfiguration contactConfiguration) throws Exception {
        boolean accountsSelected = false;
        if (contactConfiguration.getSyncAllAccounts().booleanValue() || !ArrayUtil.isEmpty((Object[])contactConfiguration.getSyncedAccountGroupIds())) {
            accountsSelected = true;
        }
        boolean contactsSelected = false;
        if (contactConfiguration.getSyncAllContacts().booleanValue() || !ArrayUtil.isEmpty((Object[])contactConfiguration.getSyncedOrganizationIds()) || !ArrayUtil.isEmpty((Object[])contactConfiguration.getSyncedUserGroupIds())) {
            contactsSelected = true;
        }
        this._analyticsCloudClient.updateAnalyticsDataSourceDetails(accountsSelected, this.contextCompany.getCompanyId(), null, contactsSelected, null);
        this._analyticsSettingsManager.updateCompanyConfiguration(this.contextCompany.getCompanyId(), (Map)HashMapBuilder.put((Object)"syncAllAccounts", (Object)contactConfiguration.getSyncAllAccounts()).put((Object)"syncAllContacts", (Object)contactConfiguration.getSyncAllContacts()).put((Object)"syncedAccountGroupIds", (Object)contactConfiguration.getSyncedAccountGroupIds()).put((Object)"syncedOrganizationIds", (Object)contactConfiguration.getSyncedOrganizationIds()).put((Object)"syncedUserGroupIds", (Object)contactConfiguration.getSyncedUserGroupIds()).build());
    }
}

