/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.analytics.settings.rest.internal.util;

import com.liferay.analytics.settings.rest.internal.util.comparator.IgnoreCaseOrderByComparator;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.OrderByComparator;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 * @author Riccardo Ferrari
 */
public class SortUtil {

	public static OrderByComparator<Group> getIgnoreCaseOrderByComparator(
		Locale locale, Sort[] sorts) {

		if (sorts == null) {
			return null;
		}

		List<Object> columns = new ArrayList<>();

		for (Sort sort : sorts) {
			columns.add(sort.getFieldName());
			columns.add(!sort.isReverse());
		}

		return new IgnoreCaseOrderByComparator<>(columns.toArray(), locale);
	}

}