/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.analytics.settings.rest.internal.dto.v1_0.converter;

import com.liferay.analytics.settings.rest.dto.v1_0.Site;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;

import org.osgi.service.component.annotations.Component;

/**
 * @author Riccardo Ferrari
 */
@Component(
	property = "dto.class.name=com.liferay.portal.kernel.model.Group",
	service = DTOConverter.class
)
public class SiteDTOConverter implements DTOConverter<Group, Site> {

	@Override
	public String getContentType() {
		return Site.class.getSimpleName();
	}

	@Override
	public Site toDTO(DTOConverterContext dtoConverterContext, Group group)
		throws Exception {

		SiteDTOConverterContext siteDTOConverterContext =
			(SiteDTOConverterContext)dtoConverterContext;

		return new Site() {
			{
				friendlyURL = group.getFriendlyURL();
				id = group.getGroupId();
				name = group.getDescriptiveName();

				setChannelName(
					() -> {
						UnicodeProperties typeSettingsUnicodeProperties =
							group.getTypeSettingsProperties();

						String analyticsChannelId =
							typeSettingsUnicodeProperties.getProperty(
								"analyticsChannelId", null);

						return siteDTOConverterContext.getChannelName(
							GetterUtil.getLong(analyticsChannelId));
					});
			}
		};
	}

}