/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.rest.internal.resource.v1_0;

import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.constants.FieldAccountConstants;
import com.liferay.analytics.settings.rest.constants.FieldOrderConstants;
import com.liferay.analytics.settings.rest.constants.FieldPeopleConstants;
import com.liferay.analytics.settings.rest.constants.FieldProductConstants;
import com.liferay.analytics.settings.rest.dto.v1_0.FieldSummary;
import com.liferay.analytics.settings.rest.internal.resource.v1_0.BaseFieldSummaryResourceImpl;
import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.analytics.settings.rest.resource.v1_0.FieldSummaryResource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/field-summary.properties"}, scope=ServiceScope.PROTOTYPE, service={FieldSummaryResource.class})
public class FieldSummaryResourceImpl
extends BaseFieldSummaryResourceImpl {
    @Reference
    private AnalyticsSettingsManager _analyticsSettingsManager;

    @Override
    public FieldSummary getField() throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        final String[] syncedAccountFieldNames = this._getOrDefault(FieldAccountConstants.FIELD_ACCOUNT_DEFAULTS, analyticsConfiguration.syncedAccountFieldNames());
        final String[] syncedCategoryFieldNames = this._getOrDefault(FieldProductConstants.FIELD_CATEGORY_NAMES, analyticsConfiguration.syncedCategoryFieldNames());
        final String[] syncedContactFieldNames = this._getOrDefault(FieldPeopleConstants.FIELD_CONTACT_DEFAULTS, analyticsConfiguration.syncedContactFieldNames());
        final String[] syncedOrderFieldNames = this._getOrDefault(FieldOrderConstants.FIELD_ORDER_NAMES, analyticsConfiguration.syncedOrderFieldNames());
        final String[] syncedOrderItemFieldNames = this._getOrDefault(FieldOrderConstants.FIELD_ORDER_ITEM_NAMES, analyticsConfiguration.syncedOrderItemFieldNames());
        final String[] syncedProductFieldNames = this._getOrDefault(FieldProductConstants.FIELD_PRODUCT_CHANNEL_NAMES, analyticsConfiguration.syncedProductFieldNames());
        final String[] syncedProductChannelFieldNames = this._getOrDefault(FieldProductConstants.FIELD_PRODUCT_NAMES, analyticsConfiguration.syncedProductChannelFieldNames());
        final String[] syncedUserFieldNames = this._getOrDefault(FieldPeopleConstants.FIELD_USER_DEFAULTS, analyticsConfiguration.syncedUserFieldNames());
        return new FieldSummary(){
            {
                this.account = syncedAccountFieldNames.length;
                this.order = syncedOrderFieldNames.length + syncedOrderItemFieldNames.length;
                this.people = syncedContactFieldNames.length + syncedUserFieldNames.length;
                this.product = syncedCategoryFieldNames.length + syncedProductFieldNames.length + syncedProductChannelFieldNames.length;
            }
        };
    }

    private String[] _getOrDefault(String[] defaultFieldNames, String[] fieldNames) {
        if (fieldNames != null && fieldNames.length > 0) {
            return fieldNames;
        }
        return defaultFieldNames;
    }
}

