/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.analytics.settings.rest.internal.dto.v1_0.converter;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;

import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;

/**
 * @author Riccardo Ferrari
 */
public class ChannelDTOConverterContext extends DefaultDTOConverterContext {

	public ChannelDTOConverterContext(
		String[] analyticsChannelIds, String analyticsDataSourceId, Object id,
		Locale locale) {

		super(false, new HashMap<>(), null, id, locale, null, null);

		_analyticsChannelIds = analyticsChannelIds;
		_analyticsDataSourceId = GetterUtil.getLong(analyticsDataSourceId);
	}

	public boolean isCommerceSyncEnabled(String analyticsChannelId) {
		return ArrayUtil.contains(_analyticsChannelIds, analyticsChannelId);
	}

	public boolean isLocalAnalyticsDataSource(Long analyticsDataSourceId) {
		return Objects.equals(analyticsDataSourceId, _analyticsDataSourceId);
	}

	private final String[] _analyticsChannelIds;
	private final Long _analyticsDataSourceId;

}