/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.analytics.settings.rest.internal.dto.v1_0.converter;

import com.liferay.analytics.settings.rest.dto.v1_0.Channel;
import com.liferay.analytics.settings.rest.dto.v1_0.DataSource;
import com.liferay.analytics.settings.rest.internal.client.model.AnalyticsChannel;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Riccardo Ferrari
 */
@Component(
	property = "dto.class.name=AnalyticsChannel",
	service = {ChannelDTOConverter.class, DTOConverter.class}
)
public class ChannelDTOConverter
	implements DTOConverter<AnalyticsChannel, Channel> {

	@Override
	public String getContentType() {
		return Channel.class.getSimpleName();
	}

	@Override
	public Channel toDTO(
			DTOConverterContext dtoConverterContext,
			AnalyticsChannel analyticsChannel)
		throws Exception {

		ChannelDTOConverterContext channelDTOConverterContext =
			(ChannelDTOConverterContext)dtoConverterContext;

		return new Channel() {
			{
				channelId = String.valueOf(analyticsChannel.getId());
				commerceSyncEnabled =
					channelDTOConverterContext.isCommerceSyncEnabled(
						String.valueOf(analyticsChannel.getId()));
				dataSources = TransformUtil.transform(
					ArrayUtil.filter(
						analyticsChannel.getAnalyticsDataSources(),
						analyticsDataSource ->
							channelDTOConverterContext.
								isLocalAnalyticsDataSource(
									analyticsDataSource.getId())),
					analyticsDataSource -> _dataSourceDTOConverter.toDTO(
						analyticsDataSource),
					DataSource.class);
				name = analyticsChannel.getName();
			}
		};
	}

	@Reference
	private DataSourceDTOConverter _dataSourceDTOConverter;

}