/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.analytics.settings.rest.internal.resource.v1_0;

import com.liferay.analytics.batch.exportimport.AnalyticsDXPEntityBatchExporter;
import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.analytics.settings.rest.resource.v1_0.AnalyticsDXPEntityBatchExporterResource;

import java.util.Collections;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

/**
 * @author Riccardo Ferrari
 */
@Component(
	properties = "OSGI-INF/liferay/rest/v1_0/analytics-dxp-entity-batch-exporter.properties",
	scope = ServiceScope.PROTOTYPE,
	service = AnalyticsDXPEntityBatchExporterResource.class
)
public class AnalyticsDXPEntityBatchExporterResourceImpl
	extends BaseAnalyticsDXPEntityBatchExporterResourceImpl {

	@Override
	public void postConfigurationWizardMode() throws Exception {
		_analyticsSettingsManager.updateCompanyConfiguration(
			contextCompany.getCompanyId(),
			Collections.singletonMap("wizardMode", false));
	}

	@Reference
	private AnalyticsDXPEntityBatchExporter _analyticsDXPEntityBatchExporter;

	@Reference
	private AnalyticsSettingsManager _analyticsSettingsManager;

}