/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.analytics.settings.rest.internal.client;

import com.liferay.analytics.settings.rest.internal.client.model.AnalyticsChannel;
import com.liferay.analytics.settings.rest.internal.client.model.AnalyticsDataSource;
import com.liferay.analytics.settings.rest.internal.client.pagination.Page;
import com.liferay.portal.kernel.search.Sort;

import java.util.Locale;
import java.util.Map;

/**
 * @author Riccardo Ferrari
 */
public interface AnalyticsCloudClient {

	public AnalyticsChannel addAnalyticsChannel(long companyId, String name)
		throws Exception;

	public Map<String, Object> connectAnalyticsDataSource(
			long companyId, String connectionToken)
		throws Exception;

	public AnalyticsDataSource disconnectAnalyticsDataSource(long companyId)
		throws Exception;

	public Page<AnalyticsChannel> getAnalyticsChannelsPage(
			long companyId, String keywords, int page, int size, Sort[] sorts)
		throws Exception;

	public AnalyticsChannel updateAnalyticsChannel(
			String analyticsChannelId, Long[] commerceChannelIds,
			long companyId, String dataSourceId, Locale locale,
			Long[] siteGroupIds)
		throws Exception;

	public AnalyticsDataSource updateAnalyticsDataSourceDetails(
			Boolean accountsSelected, long companyId,
			Boolean commerceChannelsSelected, Boolean contactsSelected,
			Boolean sitesSelected)
		throws Exception;

}