/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.analytics.settings.rest.internal.resource.v1_0;

import com.liferay.analytics.batch.exportimport.AnalyticsDXPEntityBatchExporter;
import com.liferay.analytics.batch.exportimport.constants.AnalyticsDXPEntityBatchExporterConstants;
import com.liferay.analytics.settings.rest.resource.v1_0.AnalyticsDXPEntityBatchExporterResource;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

/**
 * @author Riccardo Ferrari
 */
@Component(
	properties = "OSGI-INF/liferay/rest/v1_0/analytics-dxp-entity-batch-exporter.properties",
	scope = ServiceScope.PROTOTYPE,
	service = AnalyticsDXPEntityBatchExporterResource.class
)
public class AnalyticsDXPEntityBatchExporterResourceImpl
	extends BaseAnalyticsDXPEntityBatchExporterResourceImpl {

	@Override
	public void postAnalyticsDXPEntityBatchExporter() throws Exception {
		_analyticsDXPEntityBatchExporter.export(
			contextCompany.getCompanyId(),
			new String[] {
				AnalyticsDXPEntityBatchExporterConstants.
					DISPATCH_TRIGGER_NAME_ACCOUNT_ENTRY_DXP_ENTITIES,
				AnalyticsDXPEntityBatchExporterConstants.
					DISPATCH_TRIGGER_NAME_ORDER,
				AnalyticsDXPEntityBatchExporterConstants.
					DISPATCH_TRIGGER_NAME_PRODUCT,
				AnalyticsDXPEntityBatchExporterConstants.
					DISPATCH_TRIGGER_NAME_USER_DXP_ENTITIES
			});
	}

	@Reference
	private AnalyticsDXPEntityBatchExporter _analyticsDXPEntityBatchExporter;

}