/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.analytics.settings.rest.internal.dto.v1_0.converter;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;

import java.util.HashMap;
import java.util.Locale;

/**
 * @author Riccardo Ferrari
 */
public class ContactUserGroupDTOConverterContext
	extends DefaultDTOConverterContext {

	public ContactUserGroupDTOConverterContext(
		Object id, Locale locale, String[] syncedUserGroupIds) {

		super(false, new HashMap<>(), null, id, locale, null, null);

		_syncedUserGroupIds = syncedUserGroupIds;
	}

	public boolean isSelected(String userGroupId) {
		return ArrayUtil.contains(_syncedUserGroupIds, userGroupId);
	}

	private final String[] _syncedUserGroupIds;

}