/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.analytics.settings.rest.internal.dto.v1_0.converter;

import com.liferay.account.model.AccountGroup;
import com.liferay.analytics.settings.rest.dto.v1_0.ContactAccountGroup;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;

import org.osgi.service.component.annotations.Component;

/**
 * @author Riccardo Ferrari
 */
@Component(
	property = "dto.class.name=com.liferay.account.model.AccountGroup",
	service = {ContactAccountGroupDTOConverter.class, DTOConverter.class}
)
public class ContactAccountGroupDTOConverter
	implements DTOConverter<AccountGroup, ContactAccountGroup> {

	@Override
	public String getContentType() {
		return ContactAccountGroup.class.getSimpleName();
	}

	@Override
	public ContactAccountGroup toDTO(
			DTOConverterContext dtoConverterContext, AccountGroup accountGroup)
		throws Exception {

		ContactAccountGroupDTOConverterContext
			contactAccountGroupDTOConverterContext =
				(ContactAccountGroupDTOConverterContext)dtoConverterContext;

		return new ContactAccountGroup() {
			{
				id = accountGroup.getAccountGroupId();
				name = accountGroup.getName();
				selected = contactAccountGroupDTOConverterContext.isSelected(
					String.valueOf(accountGroup.getAccountGroupId()));
			}
		};
	}

}