/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.analytics.settings.rest.internal.dto.v1_0.converter;

import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/**
 * @author Riccardo Ferrari
 */
public class CommerceChannelDTOConverterContext
	extends DefaultDTOConverterContext {

	public CommerceChannelDTOConverterContext(
		Object id, Locale locale, Map<Long, String> channelNames) {

		super(false, new HashMap<>(), null, id, locale, null, null);

		_channelNames = channelNames;
	}

	public String getChannelName(Long analyticsChannelId) {
		if (analyticsChannelId == null) {
			return null;
		}

		return _channelNames.getOrDefault(analyticsChannelId, null);
	}

	private final Map<Long, String> _channelNames;

}