/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.analytics.settings.rest.internal.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Date;

/**
 * @author Riccardo Ferrari
 */
public class AnalyticsChannel {

	@JsonProperty("dataSources")
	public AnalyticsDataSource[] getAnalyticsDataSources() {
		return _analyticsDataSources;
	}

	public Date getCreateDate() {
		return _createDate;
	}

	public Long getId() {
		return _id;
	}

	public String getName() {
		return _name;
	}

	public void setAnalyticsDataSources(
		AnalyticsDataSource[] analyticsDataSources) {

		_analyticsDataSources = analyticsDataSources;
	}

	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	public void setId(Long id) {
		_id = id;
	}

	public void setName(String name) {
		_name = name;
	}

	private AnalyticsDataSource[] _analyticsDataSources;
	private Date _createDate;
	private Long _id;
	private String _name;

}