/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.rest.internal.resource.v1_0;

import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.dto.v1_0.Channel;
import com.liferay.analytics.settings.rest.internal.client.AnalyticsCloudClient;
import com.liferay.analytics.settings.rest.internal.client.model.AnalyticsChannel;
import com.liferay.analytics.settings.rest.internal.client.model.AnalyticsDataSource;
import com.liferay.analytics.settings.rest.internal.client.pagination.Page;
import com.liferay.analytics.settings.rest.internal.dto.v1_0.converter.ChannelDTOConverter;
import com.liferay.analytics.settings.rest.internal.dto.v1_0.converter.ChannelDTOConverterContext;
import com.liferay.analytics.settings.rest.internal.resource.v1_0.BaseChannelResourceImpl;
import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.analytics.settings.rest.resource.v1_0.ChannelResource;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/channel.properties"}, scope=ServiceScope.PROTOTYPE, service={ChannelResource.class})
public class ChannelResourceImpl
extends BaseChannelResourceImpl {
    @Reference
    protected DTOConverterRegistry dtoConverterRegistry;
    @Reference
    private AnalyticsCloudClient _analyticsCloudClient;
    @Reference
    private AnalyticsSettingsManager _analyticsSettingsManager;
    @Reference
    private ChannelDTOConverter _channelDTOConverter;

    @Override
    public com.liferay.portal.vulcan.pagination.Page<Channel> getChannelsPage(String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        Page<AnalyticsChannel> analyticsChannelsPage = this._analyticsCloudClient.getAnalyticsChannelsPage(this.contextCompany.getCompanyId(), keywords, pagination.getPage() - 1, pagination.getPageSize(), sorts);
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        return com.liferay.portal.vulcan.pagination.Page.of(this.transform(analyticsChannelsPage.getItems(), analyticsChannel -> this._channelDTOConverter.toDTO((DTOConverterContext)new ChannelDTOConverterContext(analyticsConfiguration.commerceSyncEnabledAnalyticsChannelIds(), analyticsChannel.getId(), this.contextAcceptLanguage.getPreferredLocale()), (AnalyticsChannel)analyticsChannel)), (Pagination)pagination, (long)analyticsChannelsPage.getTotalCount());
    }

    @Override
    public Channel patchChannel(Channel channel) throws Exception {
        Object[] dataSources;
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        Object[] commerceSyncEnabledAnalyticsChannelIds = analyticsConfiguration.commerceSyncEnabledAnalyticsChannelIds();
        if (channel.getCommerceSyncEnabled() != null) {
            boolean commerceSyncEnabled = ArrayUtil.contains((Object[])commerceSyncEnabledAnalyticsChannelIds, (Object)channel.getChannelId());
            if (channel.getCommerceSyncEnabled().booleanValue() && !commerceSyncEnabled) {
                commerceSyncEnabledAnalyticsChannelIds = (String[])ArrayUtil.append((Object[])commerceSyncEnabledAnalyticsChannelIds, (Object)channel.getChannelId());
                this._analyticsSettingsManager.updateCompanyConfiguration(this.contextCompany.getCompanyId(), (Map)HashMapBuilder.put((Object)"commerceSyncEnabledAnalyticsChannelIds", (Object)commerceSyncEnabledAnalyticsChannelIds).build());
            }
            if (!channel.getCommerceSyncEnabled().booleanValue() && commerceSyncEnabled) {
                commerceSyncEnabledAnalyticsChannelIds = ArrayUtil.remove((String[])commerceSyncEnabledAnalyticsChannelIds, (String)channel.getChannelId());
                this._analyticsSettingsManager.updateCompanyConfiguration(this.contextCompany.getCompanyId(), (Map)HashMapBuilder.put((Object)"commerceSyncEnabledAnalyticsChannelIds", (Object)commerceSyncEnabledAnalyticsChannelIds).build());
            }
        }
        if (ArrayUtil.isEmpty((Object[])(dataSources = channel.getDataSources()))) {
            return this._channelDTOConverter.toDTO((DTOConverterContext)new ChannelDTOConverterContext((String[])commerceSyncEnabledAnalyticsChannelIds, channel.getChannelId(), this.contextAcceptLanguage.getPreferredLocale()), this._analyticsCloudClient.updateAnalyticsChannel(channel.getChannelId(), this._analyticsSettingsManager.getCommerceChannelIds(channel.getChannelId(), this.contextUser.getCompanyId()), this.contextUser.getCompanyId(), analyticsConfiguration.liferayAnalyticsDataSourceId(), this.contextAcceptLanguage.getPreferredLocale(), this._analyticsSettingsManager.getSiteIds(channel.getChannelId(), this.contextCompany.getCompanyId())));
        }
        if (dataSources.length > 1) {
            throw new PortalException("Unable to update multiple data sources");
        }
        Object dataSource = dataSources[0];
        if (dataSource.getDataSourceId() == null) {
            dataSource.setDataSourceId(analyticsConfiguration.liferayAnalyticsDataSourceId());
        } else if (!Objects.equals(dataSource.getDataSourceId(), analyticsConfiguration.liferayAnalyticsDataSourceId())) {
            throw new PortalException("Invalid data source ID");
        }
        AnalyticsChannel analyticsChannel = this._analyticsCloudClient.updateAnalyticsChannel(channel.getChannelId(), dataSource.getCommerceChannelIds(), this.contextUser.getCompanyId(), dataSource.getDataSourceId(), this.contextAcceptLanguage.getPreferredLocale(), dataSource.getSiteIds());
        AnalyticsDataSource analyticsDataSource = this._getAnalyticsDataSource(GetterUtil.getLong((String)dataSource.getDataSourceId()), analyticsChannel.getAnalyticsDataSources());
        this._analyticsCloudClient.updateAnalyticsDataSourceDetails(null, this.contextCompany.getCompanyId(), ArrayUtil.isNotEmpty((Object[])analyticsDataSource.getCommerceChannelIds()), null, ArrayUtil.isNotEmpty((Object[])analyticsDataSource.getSiteIds()));
        this._analyticsSettingsManager.updateCompanyConfiguration(this.contextUser.getCompanyId(), (Map)HashMapBuilder.put((Object)"syncedCommerceChannelIds", (Object)this._analyticsSettingsManager.updateCommerceChannelIds(channel.getChannelId(), this.contextCompany.getCompanyId(), analyticsDataSource.getCommerceChannelIds())).put((Object)"syncedGroupIds", (Object)this._analyticsSettingsManager.updateSiteIds(channel.getChannelId(), this.contextCompany.getCompanyId(), analyticsDataSource.getSiteIds())).build());
        return this._channelDTOConverter.toDTO((DTOConverterContext)new ChannelDTOConverterContext((String[])commerceSyncEnabledAnalyticsChannelIds, channel.getChannelId(), this.contextAcceptLanguage.getPreferredLocale()), analyticsChannel);
    }

    @Override
    public Channel postChannel(Channel channel) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        return this._channelDTOConverter.toDTO((DTOConverterContext)new ChannelDTOConverterContext(analyticsConfiguration.commerceSyncEnabledAnalyticsChannelIds(), channel.getChannelId(), this.contextAcceptLanguage.getPreferredLocale()), this._analyticsCloudClient.addAnalyticsChannel(this.contextCompany.getCompanyId(), channel.getName()));
    }

    private AnalyticsDataSource _getAnalyticsDataSource(long analyticsDataSourceId, AnalyticsDataSource[] analyticsDataSources) {
        for (AnalyticsDataSource analyticsDataSource : analyticsDataSources) {
            if (analyticsDataSource.getId() != analyticsDataSourceId) continue;
            return analyticsDataSource;
        }
        throw new RuntimeException("Unable to get analytics data source");
    }
}

