/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.analytics.settings.rest.internal.resource.v1_0;

import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.dto.v1_0.ContactOrganization;
import com.liferay.analytics.settings.rest.internal.dto.v1_0.converter.ContactOrganizationDTOConverter;
import com.liferay.analytics.settings.rest.internal.dto.v1_0.converter.ContactOrganizationDTOConverterContext;
import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.analytics.settings.rest.resource.v1_0.ContactOrganizationResource;
import com.liferay.portal.kernel.model.OrganizationTable;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.util.OrderByComparatorFactoryUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

/**
 * @author Riccardo Ferrari
 */
@Component(
	properties = "OSGI-INF/liferay/rest/v1_0/contact-organization.properties",
	scope = ServiceScope.PROTOTYPE, service = ContactOrganizationResource.class
)
public class ContactOrganizationResourceImpl
	extends BaseContactOrganizationResourceImpl {

	@Override
	public Page<ContactOrganization> getContactOrganizationsPage(
			String keywords, Pagination pagination, Sort[] sorts)
		throws Exception {

		AnalyticsConfiguration analyticsConfiguration =
			_analyticsSettingsManager.getAnalyticsConfiguration(
				contextCompany.getCompanyId());

		if (sorts == null) {
			sorts = new Sort[] {new Sort("name", Sort.STRING_TYPE, false)};
		}

		Sort sort = sorts[0];

		return Page.of(
			transform(
				_organizationLocalService.getOrganizations(
					contextCompany.getCompanyId(), keywords,
					pagination.getStartPosition(), pagination.getEndPosition(),
					OrderByComparatorFactoryUtil.create(
						OrganizationTable.INSTANCE.getTableName(),
						sort.getFieldName(), !sort.isReverse())),
				organization -> _contactOrganizationDTOConverter.toDTO(
					new ContactOrganizationDTOConverterContext(
						organization.getOrganizationId(),
						contextAcceptLanguage.getPreferredLocale(),
						analyticsConfiguration.syncedOrganizationIds()),
					organization)),
			pagination,
			_organizationLocalService.getOrganizationsCount(
				contextCompany.getCompanyId(), keywords));
	}

	@Reference
	private AnalyticsSettingsManager _analyticsSettingsManager;

	@Reference
	private ContactOrganizationDTOConverter _contactOrganizationDTOConverter;

	@Reference
	private OrganizationLocalService _organizationLocalService;

}