/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.rest.internal.manager;

import aQute.bnd.annotation.metatype.Meta;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.constants.FieldAccountConstants;
import com.liferay.analytics.settings.rest.constants.FieldPeopleConstants;
import com.liferay.analytics.settings.rest.constants.FieldProductConstants;
import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.settings.SettingsDescriptor;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AnalyticsSettingsManager.class})
public class AnalyticsSettingsManagerImpl
implements AnalyticsSettingsManager {
    private static final Log _log = LogFactoryUtil.getLog(AnalyticsSettingsManagerImpl.class);
    private static final Map<String, String[]> _defaults = HashMapBuilder.put((Object)"syncedAccountFieldNames", (Object)FieldAccountConstants.FIELD_ACCOUNT_NAMES).put((Object)"syncedCategoryFieldNames", (Object)FieldProductConstants.FIELD_CATEGORY_NAMES).put((Object)"syncedContactFieldNames", (Object)FieldPeopleConstants.FIELD_CONTACT_NAMES).put((Object)"syncedProductChannelFieldNames", (Object)FieldProductConstants.FIELD_PRODUCT_CHANNEL_NAMES).put((Object)"syncedProductFieldNames", (Object)FieldProductConstants.FIELD_PRODUCT_NAMES).put((Object)"syncedUserFieldNames", (Object)FieldPeopleConstants.FIELD_USER_NAMES).build();
    private long _commerceChannelClassNameId;
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ConfigurationProvider _configurationProvider;
    private long _groupClassNameId;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SettingsFactory _settingsFactory;

    public void deleteCompanyConfiguration(long companyId) throws ConfigurationException {
        List groups = ListUtil.concat((List[])new List[]{this._groupLocalService.getGroups(companyId, -1L, true), this._groupLocalService.getGroups(companyId, "com.liferay.commerce.product.model.CommerceChannel", 0L)});
        for (Group group : groups) {
            UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
            if (typeSettingsUnicodeProperties.remove((Object)"analyticsChannelId") == null) continue;
            this._groupLocalService.updateGroup(group);
        }
        this._configurationProvider.deleteCompanyConfiguration(AnalyticsConfiguration.class, companyId);
    }

    public AnalyticsConfiguration getAnalyticsConfiguration(long companyId) throws ConfigurationException {
        return (AnalyticsConfiguration)this._configurationProvider.getCompanyConfiguration(AnalyticsConfiguration.class, companyId);
    }

    public Long[] getCommerceChannelIds(String analyticsChannelId, long companyId) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this.getAnalyticsConfiguration(companyId);
        ArrayList<Long> commerceChannelIds = new ArrayList<Long>();
        for (String commerceChannelId : analyticsConfiguration.syncedCommerceChannelIds()) {
            UnicodeProperties typeSettingsUnicodeProperties;
            Group group = this._groupLocalService.fetchGroup(companyId, this._commerceChannelClassNameId, GetterUtil.getLong((String)commerceChannelId));
            if (group == null || !Objects.equals(analyticsChannelId, (typeSettingsUnicodeProperties = group.getTypeSettingsProperties()).getProperty("analyticsChannelId"))) continue;
            commerceChannelIds.add(GetterUtil.getLong((String)commerceChannelId));
        }
        return commerceChannelIds.toArray(new Long[0]);
    }

    public Long[] getSiteIds(String analyticsChannelId, long companyId) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this.getAnalyticsConfiguration(companyId);
        ArrayList<Long> groupIds = new ArrayList<Long>();
        for (String groupId : analyticsConfiguration.syncedGroupIds()) {
            UnicodeProperties typeSettingsUnicodeProperties;
            Group group = this._groupLocalService.fetchGroup(GetterUtil.getLong((String)groupId));
            if (group == null || !Objects.equals(analyticsChannelId, (typeSettingsUnicodeProperties = group.getTypeSettingsProperties()).getProperty("analyticsChannelId"))) continue;
            groupIds.add(GetterUtil.getLong((String)groupId));
        }
        return groupIds.toArray(new Long[0]);
    }

    public boolean isAnalyticsEnabled(long companyId) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this.getAnalyticsConfiguration(companyId);
        return !Validator.isNull((String)analyticsConfiguration.liferayAnalyticsDataSourceId()) && !Validator.isNull((String)analyticsConfiguration.liferayAnalyticsFaroBackendSecuritySignature()) && !Validator.isNull((String)analyticsConfiguration.liferayAnalyticsFaroBackendURL());
    }

    public String[] updateCommerceChannelIds(String analyticsChannelId, long companyId, Long[] dataSourceCommerceChannelIds) throws Exception {
        this._updateTypeSetting(analyticsChannelId, this._commerceChannelClassNameId, companyId, dataSourceCommerceChannelIds, false);
        AnalyticsConfiguration analyticsConfiguration = this.getAnalyticsConfiguration(companyId);
        Set commerceChannelIds = SetUtil.fromArray((Object[])analyticsConfiguration.syncedCommerceChannelIds());
        for (Long dataSourceCommerceChannelId : dataSourceCommerceChannelIds) {
            commerceChannelIds.add(String.valueOf(dataSourceCommerceChannelId));
        }
        Long[] removeCommerceChannelIds = (Long[])ArrayUtil.filter((Object[])this.getCommerceChannelIds(analyticsChannelId, companyId), commerceChannelId -> !ArrayUtil.contains((Object[])dataSourceCommerceChannelIds, (Object)commerceChannelId));
        this._updateTypeSetting(analyticsChannelId, this._commerceChannelClassNameId, companyId, removeCommerceChannelIds, true);
        Stream commerceChannelIdsStream = commerceChannelIds.stream();
        return (String[])commerceChannelIdsStream.filter(commerceChannelId -> !ArrayUtil.contains((Object[])removeCommerceChannelIds, (Object)String.valueOf(commerceChannelId))).toArray(String[]::new);
    }

    public void updateCompanyConfiguration(long companyId, Map<String, Object> properties) throws Exception {
        HashMap<String, Object> configurationProperties = new HashMap();
        Configuration configuration = this._getFactoryConfiguration(this._getConfigurationPid(), ExtendedObjectClassDefinition.Scope.COMPANY, Long.valueOf(companyId));
        if (configuration != null) {
            configurationProperties = this._toMap(configuration.getProperties());
        }
        SettingsDescriptor settingsDescriptor = this._settingsFactory.getSettingsDescriptor(this._getConfigurationPid());
        Set allKeys = settingsDescriptor.getAllKeys();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (!allKeys.contains(entry.getKey())) continue;
            configurationProperties.put(entry.getKey(), entry.getValue());
        }
        for (String multiValuedKey : settingsDescriptor.getMultiValuedKeys()) {
            configurationProperties.computeIfAbsent(multiValuedKey, key -> _defaults.getOrDefault(key, new String[0]));
        }
        this._configurationProvider.saveCompanyConfiguration(AnalyticsConfiguration.class, companyId, this._toDictionary(configurationProperties));
    }

    public String[] updateSiteIds(String analyticsChannelId, long companyId, Long[] dataSourceSiteIds) throws Exception {
        this._updateTypeSetting(analyticsChannelId, this._groupClassNameId, companyId, dataSourceSiteIds, false);
        AnalyticsConfiguration analyticsConfiguration = this.getAnalyticsConfiguration(companyId);
        Set siteIds = SetUtil.fromArray((Object[])analyticsConfiguration.syncedGroupIds());
        for (Long dataSourceSiteId : dataSourceSiteIds) {
            siteIds.add(String.valueOf(dataSourceSiteId));
        }
        Long[] removeSiteIds = (Long[])ArrayUtil.filter((Object[])this.getSiteIds(analyticsChannelId, companyId), siteId -> !ArrayUtil.contains((Object[])dataSourceSiteIds, (Object)siteId));
        this._updateTypeSetting(analyticsChannelId, this._groupClassNameId, companyId, removeSiteIds, true);
        Stream siteIdsStream = siteIds.stream();
        return (String[])siteIdsStream.filter(siteId -> !ArrayUtil.contains((Object[])removeSiteIds, (Object)String.valueOf(siteId))).toArray(String[]::new);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._commerceChannelClassNameId = this._portal.getClassNameId("com.liferay.commerce.product.model.CommerceChannel");
        this._groupClassNameId = this._portal.getClassNameId(Group.class);
    }

    private String _getConfigurationPid() {
        Class<AnalyticsConfiguration> clazz = AnalyticsConfiguration.class;
        Meta.OCD ocd = clazz.getAnnotation(Meta.OCD.class);
        return ocd.id();
    }

    private Configuration _getFactoryConfiguration(String factoryPid, ExtendedObjectClassDefinition.Scope scope, Serializable scopePK) throws Exception {
        try {
            String filterString = StringBundler.concat((Object[])new Object[]{"(&(service.factoryPid=", factoryPid, ".scoped)(", scope.getPropertyKey(), "=", scopePK, "))"});
            Configuration[] configurations = this._configurationAdmin.listConfigurations(filterString);
            if (configurations != null) {
                return configurations[0];
            }
            return null;
        }
        catch (IOException | InvalidSyntaxException exception) {
            _log.error(exception);
            throw new ConfigurationException("Unable to retrieve factory configuration " + factoryPid, exception);
        }
    }

    private Dictionary<String, Object> _toDictionary(Map<String, Object> map) {
        return new HashMapDictionary(map);
    }

    private Map<String, Object> _toMap(Dictionary<String, Object> dictionary) {
        if (dictionary == null) {
            return Collections.emptyMap();
        }
        ArrayList<String> keys = Collections.list(dictionary.keys());
        Stream stream = keys.stream();
        return stream.collect(Collectors.toMap(Function.identity(), dictionary::get));
    }

    private <T> void _updateTypeSetting(String analyticsChannelId, long classNameId, long companyId, T[] classPKs, boolean remove) throws Exception {
        for (T classPK : classPKs) {
            Group group = this._groupLocalService.fetchGroup(companyId, classNameId, GetterUtil.getLong(classPK));
            if (group == null) continue;
            UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
            if (remove) {
                if (!analyticsChannelId.equals(typeSettingsUnicodeProperties.get((Object)"analyticsChannelId"))) continue;
                typeSettingsUnicodeProperties.remove((Object)"analyticsChannelId");
            } else {
                if (analyticsChannelId.equals(typeSettingsUnicodeProperties.get((Object)"analyticsChannelId"))) continue;
                typeSettingsUnicodeProperties.setProperty("analyticsChannelId", analyticsChannelId);
            }
            this._groupLocalService.updateGroup(group);
        }
    }
}

