/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.rest.internal.resource.v1_0;

import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.dto.v1_0.Field;
import com.liferay.analytics.settings.rest.internal.constants.FieldAccountConstants;
import com.liferay.analytics.settings.rest.internal.constants.FieldPeopleConstants;
import com.liferay.analytics.settings.rest.internal.resource.v1_0.BaseFieldResourceImpl;
import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.analytics.settings.rest.resource.v1_0.FieldResource;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/field.properties"}, scope=ServiceScope.PROTOTYPE, service={FieldResource.class})
public class FieldResourceImpl
extends BaseFieldResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(FieldResourceImpl.class);
    @Reference
    private AnalyticsSettingsManager _analyticsSettingsManager;

    @Override
    public Page<Field> getFieldsAccountsPage(String keyword, Pagination pagination, Sort[] sorts) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        List<Field> fields = this._getFields(FieldAccountConstants.FIELD_ACCOUNT_EXAMPLES, FieldAccountConstants.FIELD_ACCOUNT_NAMES, FieldAccountConstants.FIELD_ACCOUNT_REQUIRED_NAMES, "account", analyticsConfiguration.syncedAccountFieldNames(), FieldAccountConstants.FIELD_ACCOUNT_TYPES);
        fields = this._filter(fields, keyword);
        fields = this._sort(fields, sorts);
        return Page.of((Collection)ListUtil.subList(fields, (int)pagination.getStartPosition(), (int)pagination.getEndPosition()), (Pagination)pagination, (long)fields.size());
    }

    @Override
    public Page<Field> getFieldsPeoplePage(String keyword, Pagination pagination, Sort[] sorts) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        List<Field> fields = this._getFields(FieldPeopleConstants.FIELD_CONTACT_EXAMPLES, FieldPeopleConstants.FIELD_CONTACT_NAMES, FieldPeopleConstants.FIELD_CONTACT_REQUIRED_NAMES, "contact", analyticsConfiguration.syncedContactFieldNames(), FieldPeopleConstants.FIELD_CONTACT_TYPES);
        fields.addAll(this._getFields(FieldPeopleConstants.FIELD_USER_EXAMPLES, FieldPeopleConstants.FIELD_USER_NAMES, FieldPeopleConstants.FIELD_USER_REQUIRED_NAMES, "user", analyticsConfiguration.syncedUserFieldNames(), FieldPeopleConstants.FIELD_USER_TYPES));
        fields = this._filter(fields, keyword);
        fields = this._sort(fields, sorts);
        return Page.of((Collection)ListUtil.subList(fields, (int)pagination.getStartPosition(), (int)pagination.getEndPosition()), (Pagination)pagination, (long)fields.size());
    }

    @Override
    public void patchFieldAccount(Field[] fields) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        this._analyticsSettingsManager.updateCompanyConfiguration(this.contextCompany.getCompanyId(), (Map)HashMapBuilder.put((Object)"syncedAccountFieldNames", (Object)this._updateSelectedFields(analyticsConfiguration.syncedAccountFieldNames(), fields, FieldAccountConstants.FIELD_ACCOUNT_REQUIRED_NAMES, "contact", FieldAccountConstants.FIELD_ACCOUNT_NAMES)).build());
    }

    @Override
    public void patchFieldPeople(Field[] fields) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        this._analyticsSettingsManager.updateCompanyConfiguration(this.contextCompany.getCompanyId(), (Map)HashMapBuilder.put((Object)"syncedContactFieldNames", (Object)this._updateSelectedFields(analyticsConfiguration.syncedContactFieldNames(), fields, FieldPeopleConstants.FIELD_CONTACT_REQUIRED_NAMES, "contact", FieldPeopleConstants.FIELD_CONTACT_NAMES)).put((Object)"syncedUserFieldNames", (Object)this._updateSelectedFields(analyticsConfiguration.syncedUserFieldNames(), fields, FieldPeopleConstants.FIELD_USER_REQUIRED_NAMES, "user", FieldPeopleConstants.FIELD_USER_NAMES)).build());
    }

    private List<Field> _filter(List<Field> fields, String keywords) {
        if (keywords == null) {
            return fields;
        }
        Stream stream = fields.stream();
        return stream.filter(field -> {
            String name = field.getName();
            return name.matches("(?i).*" + keywords + ".*");
        }).collect(Collectors.toList());
    }

    private List<Field> _getFields(String[] examples, String[] names, String[] requiredNames, String source, String[] syncedNames, String[] types) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (int i = 0; i < names.length; ++i) {
            Field field = new Field();
            field.setExample(examples[i]);
            field.setName(names[i]);
            field.setRequired(Boolean.valueOf(ArrayUtil.contains((Object[])requiredNames, (Object)names[i])));
            field.setSelected(Boolean.valueOf(ArrayUtil.contains((Object[])syncedNames, (Object)names[i]) || field.getRequired() != false));
            field.setSource(source);
            field.setType(types[i]);
            fields.add(field);
        }
        return fields;
    }

    private List<Field> _sort(List<Field> fields, Sort[] sorts) {
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            return fields;
        }
        Comparator<Field> fieldComparator = null;
        for (Sort sort : sorts) {
            if (!Objects.equals(sort.getFieldName(), "name")) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Skipping unsupported sort field: " + sort.getFieldName()));
                continue;
            }
            fieldComparator = Comparator.comparing(Field::getName);
            if (!sort.isReverse()) continue;
            fieldComparator = fieldComparator.reversed();
        }
        if (fieldComparator != null) {
            fields.sort(fieldComparator);
        }
        return fields;
    }

    private String[] _updateSelectedFields(String[] configurationFieldNames, Field[] fields, String[] requiredFieldNames, String source, String[] validateFieldNames) {
        HashSet<String> selectedFieldNames = new HashSet<String>(Arrays.asList(configurationFieldNames));
        for (Field field : fields) {
            if (!Objects.equals(source, field.getSource())) continue;
            if (!field.getSelected().booleanValue()) {
                selectedFieldNames.remove(field.getName());
                continue;
            }
            if (!ArrayUtil.contains((Object[])validateFieldNames, (Object)field.getName())) continue;
            selectedFieldNames.add(field.getName());
        }
        Collections.addAll(selectedFieldNames, requiredFieldNames);
        return selectedFieldNames.toArray(new String[0]);
    }
}

