/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.analytics.settings.rest.internal.constants;

/**
 * @author Riccardo Ferrari
 */
public class FieldAccountConstants {

	public static final String[] FIELD_ACCOUNT_EXAMPLES = {
		"asd-yrty", "12346-A", "12345", "12345", "12345", "johndoe",
		"31st Oct 2008", "31st Oct 2008", "12345", "cash", "12345", "12345",
		"Gold Account", "www.liferay.com", "test@liferay.com", "12345", "Gold",
		"True", "ee", "23456", "business", "0", "12345", "admin",
		"31st Oct 2008"
	};

	public static final String[] FIELD_ACCOUNT_NAMES = {
		"uuid_", "externalReferenceCode", "accountEntryId", "companyId",
		"userId", "userName", "createDate", "modifiedDate",
		"defaultBillingAddressId", "defaultCPaymentMethodKey",
		"defaultShippingAddressId", "parentAccountEntryId", "description",
		"domains", "emailAddress", "logoId", "name", "restrictMembership",
		"taxExemptionCode", "taxIdNumber", "type_", "status", "statusByUserId",
		"statusByUserName", "statusDate"
	};

	public static final String[] FIELD_ACCOUNT_REQUIRED_NAMES = {
		"accountEntryId", "emailAddress", "name"
	};

	public static final String[] FIELD_ACCOUNT_TYPES = {
		"String", "String", "Long", "Long", "Long", "String", "StringDate",
		"StringDate", "Long", "String", "Long", "Long", "String", "String",
		"String", "Long", "String", "Boolean", "String", "String", "String",
		"Integer", "Long", "String", "StringDate"
	};

}