/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.rest.internal.manager;

import aQute.bnd.annotation.metatype.Meta;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.internal.constants.FieldAccountConstants;
import com.liferay.analytics.settings.rest.internal.constants.FieldPeopleConstants;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.settings.SettingsDescriptor;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AnalyticsSettingsManager.class})
public class AnalyticsSettingsManager {
    private static final Log _log = LogFactoryUtil.getLog(AnalyticsSettingsManager.class);
    private static final Map<String, String[]> _defaults = HashMapBuilder.put((Object)"syncedAccountFieldNames", (Object)FieldAccountConstants.FIELD_ACCOUNT_NAMES).put((Object)"syncedContactFieldNames", (Object)FieldPeopleConstants.FIELD_CONTACT_NAMES).put((Object)"syncedUserFieldNames", (Object)FieldPeopleConstants.FIELD_USER_NAMES).build();
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private SettingsFactory _settingsFactory;

    public void deleteCompanyConfiguration(long companyId) throws ConfigurationException {
        this._configurationProvider.deleteCompanyConfiguration(AnalyticsConfiguration.class, companyId);
    }

    public AnalyticsConfiguration getAnalyticsConfiguration(long companyId) throws ConfigurationException {
        return (AnalyticsConfiguration)this._configurationProvider.getCompanyConfiguration(AnalyticsConfiguration.class, companyId);
    }

    public boolean isAnalyticsEnabled(long companyId) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this.getAnalyticsConfiguration(companyId);
        return !Validator.isNull((String)analyticsConfiguration.liferayAnalyticsDataSourceId()) && !Validator.isNull((String)analyticsConfiguration.liferayAnalyticsFaroBackendSecuritySignature()) && !Validator.isNull((String)analyticsConfiguration.liferayAnalyticsFaroBackendURL());
    }

    public void updateCompanyConfiguration(long companyId, Map<String, Object> properties) throws Exception {
        HashMap<String, Object> configurationProperties = new HashMap();
        Configuration configuration = this._getFactoryConfiguration(this._getConfigurationPid(), ExtendedObjectClassDefinition.Scope.COMPANY, Long.valueOf(companyId));
        if (configuration != null) {
            configurationProperties = this._toMap(configuration.getProperties());
        }
        SettingsDescriptor settingsDescriptor = this._settingsFactory.getSettingsDescriptor(this._getConfigurationPid());
        Set allKeys = settingsDescriptor.getAllKeys();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (!allKeys.contains(entry.getKey())) continue;
            configurationProperties.put(entry.getKey(), entry.getValue());
        }
        for (String multiValuedKey : settingsDescriptor.getMultiValuedKeys()) {
            configurationProperties.computeIfAbsent(multiValuedKey, key -> _defaults.getOrDefault(key, new String[0]));
        }
        this._configurationProvider.saveCompanyConfiguration(AnalyticsConfiguration.class, companyId, this._toDictionary(configurationProperties));
    }

    private String _getConfigurationPid() {
        Class<AnalyticsConfiguration> clazz = AnalyticsConfiguration.class;
        Meta.OCD ocd = clazz.getAnnotation(Meta.OCD.class);
        return ocd.id();
    }

    private Configuration _getFactoryConfiguration(String factoryPid, ExtendedObjectClassDefinition.Scope scope, Serializable scopePK) throws Exception {
        try {
            String filterString = StringBundler.concat((Object[])new Object[]{"(&(service.factoryPid=", factoryPid, ".scoped)(", scope.getPropertyKey(), "=", scopePK, "))"});
            Configuration[] configurations = this._configurationAdmin.listConfigurations(filterString);
            if (configurations != null) {
                return configurations[0];
            }
            return null;
        }
        catch (IOException | InvalidSyntaxException exception) {
            _log.error(exception);
            throw new ConfigurationException("Unable to retrieve factory configuration " + factoryPid, exception);
        }
    }

    private Dictionary<String, Object> _toDictionary(Map<String, Object> map) {
        return new HashMapDictionary(map);
    }

    private Map<String, Object> _toMap(Dictionary<String, Object> dictionary) {
        if (dictionary == null) {
            return Collections.emptyMap();
        }
        ArrayList<String> keys = Collections.list(dictionary.keys());
        Stream stream = keys.stream();
        return stream.collect(Collectors.toMap(Function.identity(), dictionary::get));
    }
}

