/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.rest.internal.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.internal.client.AnalyticsCloudClient;
import com.liferay.analytics.settings.rest.internal.client.exception.DataSourceConnectionException;
import com.liferay.analytics.settings.rest.internal.client.model.DataSource;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AnalyticsCloudClient.class})
public class AnalyticsCloudClientImpl
implements AnalyticsCloudClient {
    private static final Log _log = LogFactoryUtil.getLog(AnalyticsCloudClientImpl.class);
    private static final ObjectMapper _objectMapper = new ObjectMapper(){
        {
            this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        }
    };
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Http _http;
    @Reference
    private SettingsFactory _settingsFactory;

    @Override
    public Map<String, Object> connectDataSource(long companyId, String connectionToken) throws Exception {
        JSONObject connectionTokenJSONObject = this._decodeToken(connectionToken);
        Company company = this._companyLocalService.getCompany(companyId);
        Http.Options options = new Http.Options();
        String url = HttpComponentsUtil.addParameter((String)connectionTokenJSONObject.getString("url"), (String)"name", (String)company.getName());
        url = HttpComponentsUtil.addParameter((String)url, (String)"portalURL", (String)company.getPortalURL(0L));
        url = HttpComponentsUtil.addParameter((String)url, (String)"token", (String)connectionTokenJSONObject.getString("token"));
        options.setLocation(url);
        options.setPost(true);
        String content = this._http.URLtoString(options);
        Http.Response response = options.getResponse();
        if (response.getResponseCode() != 200) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Response code " + response.getResponseCode()));
            }
            throw new DataSourceConnectionException("Unable to connect data source");
        }
        JSONObject contentJSONObject = JSONFactoryUtil.createJSONObject((String)content);
        return contentJSONObject.toMap();
    }

    @Override
    public DataSource disconnectDataSource(long companyId) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = (AnalyticsConfiguration)this._configurationProvider.getCompanyConfiguration(AnalyticsConfiguration.class, companyId);
        try {
            Http.Options options = new Http.Options();
            options.addHeader("Content-Length", "0");
            options.addHeader("OSB-Asah-Faro-Backend-Security-Signature", analyticsConfiguration.liferayAnalyticsFaroBackendSecuritySignature());
            options.addHeader("OSB-Asah-Project-ID", analyticsConfiguration.liferayAnalyticsProjectId());
            options.setLocation(String.format("%s/api/1.0/data-sources/%s/disconnect", analyticsConfiguration.liferayAnalyticsFaroBackendURL(), analyticsConfiguration.liferayAnalyticsDataSourceId()));
            options.setPost(true);
            String content = this._http.URLtoString(options);
            Http.Response response = options.getResponse();
            if (response.getResponseCode() == 200) {
                return (DataSource)_objectMapper.readValue(content, DataSource.class);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Response code " + response.getResponseCode()));
            }
            throw new PortalException("Unable to disconnect data source");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            throw new PortalException("Unable to disconnect data source", (Throwable)exception);
        }
    }

    private JSONObject _decodeToken(String connectionToken) throws Exception {
        try {
            if (Validator.isBlank((String)connectionToken)) {
                throw new IllegalArgumentException();
            }
            return JSONFactoryUtil.createJSONObject((String)new String(Base64.decode((String)connectionToken)));
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to decode token", (Throwable)exception);
            throw new PortalException("Unable to decode token", (Throwable)exception);
        }
    }
}

