var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __reExport = (target, mod, secondTarget) => (__copyProps(target, mod, "default"), secondTarget && __copyProps(secondTarget, mod, "default"));

// ../../../../../../../../../../$/bridge/for/main/@liferay/frontend-js-react-web
var frontend_js_react_web_exports = {};
__reExport(frontend_js_react_web_exports, liferay_star);
import * as liferay_star from "../../frontend-js-react-web/__liferay__/index.js";

// ../../../../../../../../../../$/bridge/for/main/frontend-js-web
var frontend_js_web_exports = {};
__reExport(frontend_js_web_exports, liferay_star2);
import * as liferay_star2 from "../../frontend-js-web/__liferay__/index.js";

// ../../../../../../../../../../$/bridge/for/main/prop-types
var prop_types_exports = {};
__export(prop_types_exports, {
  default: () => prop_types_default
});
__reExport(prop_types_exports, prop_types_star);
import * as prop_types_star from "../../frontend-js-react-web/__liferay__/exports/prop-types.js";
import __default__ from "../../frontend-js-react-web/__liferay__/exports/prop-types.js";
var prop_types_default = __default__;

// ../../../../../../../../../../$/bridge/for/main/react
var react_exports = {};
__export(react_exports, {
  default: () => react_default
});
__reExport(react_exports, react_star);
import * as react_star from "../../frontend-js-react-web/__liferay__/exports/react.js";
import __default__2 from "../../frontend-js-react-web/__liferay__/exports/react.js";
var react_default = __default__2;

// ../../../../../../../../../../$/bridge/for/main/@clayui/alert
var alert_exports = {};
__export(alert_exports, {
  default: () => alert_default
});
__reExport(alert_exports, clayui_alert_star);
import * as clayui_alert_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$alert.js";
import __default__3 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$alert.js";
var alert_default = __default__3;

// ../../../../../../../../../../$/bridge/for/main/@clayui/loading-indicator
var loading_indicator_exports = {};
__export(loading_indicator_exports, {
  default: () => loading_indicator_default
});
__reExport(loading_indicator_exports, clayui_loading_indicator_star);
import * as clayui_loading_indicator_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$loading-indicator.js";
import __default__4 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$loading-indicator.js";
var loading_indicator_default = __default__4;

// src/main/resources/META-INF/resources/js/context/ChartStateContext.tsx
var INITIAL_STATE = {
  dataSet: { histogram: [], keyList: [], totals: {} },
  lineChartLoading: true,
  pieChartLoading: true,
  publishDate: null,
  timeRange: null,
  timeSpanKey: null,
  timeSpanOffset: 0
};
var ADD_DATA_SET_ITEMS = "ADD_DATA_SET_ITEMS";
var CHANGE_TIME_SPAN_KEY = "CHANGE_TIME_SPAN_KEY";
var NEXT_TIME_SPAN = "NEXT_TIME_SPAN";
var PREV_TIME_SPAN = "PREV_TIME_SPAN";
var SET_LOADING = "SET_LOADING";
var SET_PIE_CHART_LOADING = "SET_PIE_CHART_LOADING";
var FALLBACK_DATA_SET_ITEM = { histogram: [], value: null };
var LAST_7_DAYS = "last-7-days";
var LAST_30_DAYS = "last-30-days";
var ChartDispatchContext = (0, react_exports.createContext)(
  () => {
  }
);
var ChartStateContext = (0, react_exports.createContext)(INITIAL_STATE);
function reducer(state, action) {
  let nextState;
  switch (action.type) {
    case ADD_DATA_SET_ITEMS:
      nextState = setLineChartLoadingState(state);
      if (action.payload.keys) {
        nextState = [...action.payload.keys].reduce((state2, key) => {
          const dataSetItem = action.payload.dataSetItems?.[key] ?? FALLBACK_DATA_SET_ITEM;
          return addDataSetItem(
            state2,
            {
              dataSetItem,
              dataSetItems: action.payload.dataSetItems,
              key
            },
            action.validAnalyticsConnection
          );
        }, state);
      }
      break;
    case CHANGE_TIME_SPAN_KEY:
      nextState = {
        ...state,
        lineChartLoading: true,
        timeSpanKey: action.payload.key,
        timeSpanOffset: 0
      };
      break;
    case NEXT_TIME_SPAN:
      nextState = {
        ...state,
        lineChartLoading: true,
        timeSpanOffset: state.timeSpanOffset - 1
      };
      break;
    case PREV_TIME_SPAN:
      nextState = {
        ...state,
        lineChartLoading: true,
        timeSpanOffset: state.timeSpanOffset + 1
      };
      break;
    case SET_LOADING:
      nextState = setLineChartLoadingState(state);
      break;
    case SET_PIE_CHART_LOADING:
      nextState = {
        ...state,
        pieChartLoading: Boolean(action.payload.loading)
      };
      break;
    default:
      nextState = state;
      break;
  }
  return nextState;
}
function ChartStateContextProvider({
  children,
  publishDate,
  timeRange,
  timeSpanKey
}) {
  const [state, dispatch] = (0, react_exports.useReducer)(
    reducer,
    {
      ...INITIAL_STATE,
      publishDate,
      timeRange,
      timeSpanKey
    }
  );
  return /* @__PURE__ */ react_default.createElement(ChartDispatchContext.Provider, { value: dispatch }, /* @__PURE__ */ react_default.createElement(ChartStateContext.Provider, { value: state }, children));
}
function useDateTitle() {
  const { timeRange, timeSpanKey, timeSpanOffset } = (0, react_exports.useContext)(ChartStateContext);
  if (!timeRange) {
    return { firstDate: null, lastDate: null };
  }
  const firstDate = new Date(timeRange.startDate.concat("T00:00:00"));
  const lastDate = new Date(timeRange.endDate.concat("T00:00:00"));
  const increment = timeSpanKey === LAST_7_DAYS ? 7 : timeSpanKey === LAST_30_DAYS ? 30 : 0;
  if (timeSpanKey === LAST_30_DAYS) {
    firstDate.setDate(firstDate.getDate() + 6 - (increment - 1));
  }
  if (timeSpanOffset && timeSpanOffset > 0) {
    lastDate.setDate(lastDate.getDate() - increment * timeSpanOffset);
    firstDate.setDate(firstDate.getDate() - increment * timeSpanOffset);
    return {
      firstDate,
      lastDate
    };
  } else {
    return {
      firstDate,
      lastDate
    };
  }
}
function useIsPreviousPeriodButtonDisabled() {
  const { publishDate } = (0, react_exports.useContext)(ChartStateContext);
  const { firstDate } = useDateTitle();
  if (!publishDate || !firstDate) {
    return false;
  }
  const publishedDate = publishDate && new Date(publishDate);
  return firstDate < publishedDate;
}
function setLineChartLoadingState(state) {
  if (!state.dataSet) {
    return { ...state, lineChartLoading: true };
  }
  if (state.dataSet.histogram.length) {
    return { ...state, lineChartLoading: false };
  }
  const histogram = state.dataSet.histogram.map((set) => {
    const newSet = {};
    const setArray = Object.entries(set);
    for (const index in setArray) {
      const [key, value] = setArray[index];
      if (key === "label") {
        newSet[key] = value;
      } else {
        newSet[key] = null;
      }
    }
    return newSet;
  });
  const arrayTotals = state.dataSet.totals ? Object.entries(state.dataSet.totals) : [];
  const totals = {};
  for (const index in arrayTotals) {
    const [key] = arrayTotals[index];
    totals[key] = null;
  }
  const nextState = {
    ...state,
    dataSet: {
      ...state.dataSet,
      histogram,
      totals
    },
    lineChartLoading: true
  };
  return nextState;
}
function mergeDataSets({
  key,
  newData,
  previousDataSet = { histogram: [], keyList: [], totals: {} },
  publishDate,
  timeSpanComparator,
  validAnalyticsConnection
}) {
  const resultDataSet = {
    histogram: [],
    keyList: [...previousDataSet.keyList, key],
    totals: {
      ...previousDataSet.totals,
      [key]: newData.value
    }
  };
  if (!publishDate) {
    return {
      ...resultDataSet,
      histogram: previousDataSet.histogram
    };
  }
  const publishDateObject = new Date(publishDate);
  const newFormattedHistogram = newData.histogram.map((h) => {
    const valueDataObject = h.key ? new Date(h.key) : null;
    if (valueDataObject && timeSpanComparator && valueDataObject < publishDateObject && publishDateObject.getTime() - valueDataObject.getTime() > timeSpanComparator || !validAnalyticsConnection) {
      return {
        [key]: null,
        label: h.key
      };
    }
    return {
      [key]: h.value,
      label: h.key
    };
  });
  if (!newFormattedHistogram.length) {
    return {
      ...resultDataSet,
      histogram: previousDataSet.histogram
    };
  }
  let start = 0;
  const mergeHistogram = [];
  while (start < newData.histogram.length) {
    if (!previousDataSet.histogram[start]) {
      mergeHistogram.push({
        ...newFormattedHistogram[start]
      });
    } else if (newFormattedHistogram[start].label === previousDataSet.histogram[start].label) {
      mergeHistogram.push({
        ...newFormattedHistogram[start],
        ...previousDataSet.histogram[start]
      });
    }
    start = start + 1;
  }
  resultDataSet.histogram = mergeHistogram;
  return resultDataSet;
}
function addDataSetItem(state, payload, validAnalyticsConnection) {
  const previousDataSet = state.lineChartLoading === true ? void 0 : state.dataSet;
  return {
    ...state,
    dataSet: mergeDataSets({
      key: payload.key,
      newData: payload.dataSetItem,
      previousDataSet,
      publishDate: state.publishDate,
      timeSpanComparator: payload.timeSpanComparator,
      validAnalyticsConnection
    }),
    lineChartLoading: false
  };
}

// src/main/resources/META-INF/resources/js/context/ConnectionContext.tsx
var ConnectionContext = (0, react_exports.createContext)({
  validAnalyticsConnection: true
});
ConnectionContext.Provider.propTypes = {
  value: prop_types_default.shape({
    validAnalyticsConnection: prop_types_default.bool.isRequired
  }).isRequired
};
var ConnectionContext_default = ConnectionContext;

// src/main/resources/META-INF/resources/js/utils/useSafeReducer.ts
var identity = (a) => a;
function useSafeReducer(reducer3, initializerArg, initializer = identity) {
  const [state, dispatch] = (0, react_exports.useReducer)(reducer3, initializerArg, initializer);
  const isMounted = (0, frontend_js_react_web_exports.useIsMounted)();
  const safeDispatch = (0, react_exports.useCallback)(
    (...args) => {
      if (isMounted()) {
        dispatch(...args);
      }
    },
    [dispatch, isMounted]
  );
  return [state, safeDispatch];
}

// src/main/resources/META-INF/resources/js/context/StoreContext.tsx
var ADD_WARNING = "ADD_WARNING";
var INITIAL_STATE2 = {
  publishedToday: false,
  warning: false
};
var StoreDispatchContext = react_default.createContext(
  () => {
  }
);
var StoreStateContext = (0, react_exports.createContext)(INITIAL_STATE2);
function reducer2(state = INITIAL_STATE2, action) {
  let nextState = state;
  switch (action.type) {
    case ADD_WARNING:
      nextState = state.warning ? state : { ...state, warning: true };
      break;
    default:
      return state;
  }
  return nextState;
}
function StoreContextProvider({ children, value }) {
  const [state, dispatch] = useSafeReducer(reducer2, {
    ...INITIAL_STATE2,
    ...value
  });
  return /* @__PURE__ */ react_default.createElement(StoreDispatchContext.Provider, { value: dispatch }, /* @__PURE__ */ react_default.createElement(StoreStateContext.Provider, { value: state }, children));
}

// src/main/resources/META-INF/resources/js/context/dataReducer.tsx
var initialState = {
  data: null,
  error: null,
  loading: false
};
function dataReducer(state, action) {
  switch (action.type) {
    case "LOAD_DATA":
      return {
        ...state,
        loading: true
      };
    case "SET_ERROR":
      return {
        ...state,
        error: action.error,
        loading: false
      };
    case "SET_DATA":
      return {
        data: {
          ...action.data,
          publishedToday: action.data && (/* @__PURE__ */ new Date()).toDateString() === new Date(action.data.publishDate).toDateString()
        },
        error: action.data?.error,
        loading: false
      };
    default:
      return initialState;
  }
}

// src/main/resources/META-INF/resources/js/utils/APIService.tsx
var APIService_default = {
  getAnalyticsReportsData(analyticsReportsURL, body) {
    return _fetchWithError(analyticsReportsURL, {
      body,
      method: "POST"
    });
  },
  getHistoricalReads(analyticsReportsHistoricalReadsURL, { namespace, plid, timeSpanKey, timeSpanOffset }) {
    const body = { plid, timeSpanKey, timeSpanOffset };
    return _fetchWithError(analyticsReportsHistoricalReadsURL, {
      body: _getFormDataRequest(body, namespace),
      method: "POST"
    });
  },
  getHistoricalViews(analyticsReportsHistoricalViewsURL, { namespace, plid, timeSpanKey, timeSpanOffset }) {
    const body = { plid, timeSpanKey, timeSpanOffset };
    return _fetchWithError(analyticsReportsHistoricalViewsURL, {
      body: _getFormDataRequest(body, namespace),
      method: "POST"
    });
  },
  getTotalReads(analyticsReportsTotalReadsURL, { namespace, plid }) {
    const body = { plid };
    return _fetchWithError(analyticsReportsTotalReadsURL, {
      body: _getFormDataRequest(body, namespace),
      method: "POST"
    });
  },
  getTotalViews(analyticsReportsTotalViewsURL, { namespace, plid }) {
    const body = { plid };
    return _fetchWithError(analyticsReportsTotalViewsURL, {
      body: _getFormDataRequest(body, namespace),
      method: "POST"
    });
  },
  getTrafficSources(analyticsReportsTrafficSourcesURL, { namespace, plid, timeSpanKey, timeSpanOffset }) {
    const body = { plid, timeSpanKey, timeSpanOffset };
    return _fetchWithError(analyticsReportsTrafficSourcesURL, {
      body: _getFormDataRequest(body, namespace),
      method: "POST"
    });
  }
};
function _getFormDataRequest(body, prefix, formData = new FormData()) {
  Object.entries(body).forEach(([key, value]) => {
    formData.append(`${prefix}${key}`, value);
  });
  return formData;
}
function _fetchWithError(url, options = {}) {
  return (0, frontend_js_web_exports.fetch)(url, options).then((response) => response.json()).then((objectResponse) => {
    if (objectResponse.error) {
      throw objectResponse.error;
    }
    return objectResponse;
  });
}

// ../../../../../../../../../../$/bridge/for/main/@clayui/icon
var icon_exports = {};
__export(icon_exports, {
  default: () => icon_default
});
__reExport(icon_exports, clayui_icon_star);
import * as clayui_icon_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$icon.js";
import __default__5 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$icon.js";
var icon_default = __default__5;

// ../../../../../../../../../../$/bridge/for/main/@clayui/link
var link_exports = {};
__export(link_exports, {
  default: () => link_default
});
__reExport(link_exports, clayui_link_star);
import * as clayui_link_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$link.js";
import __default__6 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$link.js";
var link_default = __default__6;

// src/main/resources/META-INF/resources/js/components/ConnectToAC.tsx
function ConnectToAC({
  analyticsURL,
  isAnalyticsConnected,
  hideAnalyticsReportsPanelURL,
  pathToAssets,
  onHideAnalyticsReportsPanelClick = (event) => {
    event.preventDefault();
    if (document.hrefFm && typeof submitForm !== "undefined") {
      submitForm(document.hrefFm, hideAnalyticsReportsPanelURL);
    }
  }
}) {
  return /* @__PURE__ */ react_default.createElement("div", { className: "p-3 pt-4 text-center" }, /* @__PURE__ */ react_default.createElement(
    "img",
    {
      alt: Liferay.Language.get("connect-to-liferay-analytics-cloud"),
      src: `${pathToAssets}/assets/ac-icon.svg`
    }
  ), isAnalyticsConnected ? /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement("div", { className: "font-weight-semi-bold h5 mt-3" }, Liferay.Language.get("sync-to-analytics-cloud")), /* @__PURE__ */ react_default.createElement("p", { className: "text-secondary" }, Liferay.Language.get(
    "sync-your-liferay-dxp-instance-with-analytics-cloud-to-view-content-performance-metrics-and-build-a-successful-content-strategy"
  )), /* @__PURE__ */ react_default.createElement(
    link_default,
    {
      button: true,
      displayType: "primary",
      href: analyticsURL,
      target: "_blank"
    },
    Liferay.Language.get("open-analytics-cloud"),
    /* @__PURE__ */ react_default.createElement("span", { className: "inline-item inline-item-after" }, /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "shortcut" }))
  )) : /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement("div", { className: "font-weight-semi-bold h5 mt-3" }, Liferay.Language.get(
    "connect-to-liferay-analytics-cloud"
  )), /* @__PURE__ */ react_default.createElement("p", { className: "text-secondary" }, Liferay.Language.get(
    "liferay-dxp-instance-has-to-be-connected-with-analytics-cloud-to-view-content-performance-metrics-and-build-a-successful-content-strategy"
  )), /* @__PURE__ */ react_default.createElement(
    link_default,
    {
      className: "d-block font-weight-bold mb-2 mt-5",
      onClick: onHideAnalyticsReportsPanelClick,
      tabIndex: 0
    },
    Liferay.Language.get("do-not-show-me-this-again")
  ), /* @__PURE__ */ react_default.createElement("p", { className: "text-secondary" }, Liferay.Language.get("do-not-show-me-this-again-help"))));
}

// ../../../../../../../../../../$/bridge/for/main/classnames
var classnames_exports = {};
__export(classnames_exports, {
  default: () => classnames_default
});
__reExport(classnames_exports, classnames_star);
import * as classnames_star from "../../frontend-js-react-web/__liferay__/exports/classnames.js";
import __default__7 from "../../frontend-js-react-web/__liferay__/exports/classnames.js";
var classnames_default = __default__7;

// src/main/resources/META-INF/resources/js/utils/dateFormat.tsx
function generateDateFormatters(key) {
  function formatChartTitle([initialDate, finalDate]) {
    const singleDayDateRange = finalDate.getTime() - initialDate.getTime() <= 1e3 * 60 * 60 * 24;
    const dateFormatter = (date, options = {
      day: "numeric",
      month: "short",
      year: "numeric"
    }) => Intl.DateTimeFormat([key], options).format(date);
    const equalMonth = initialDate.getMonth() === finalDate.getMonth();
    const equalYear = initialDate.getFullYear() === finalDate.getFullYear();
    const initialDateOptions = {
      day: "numeric",
      month: equalMonth && equalYear ? void 0 : "short",
      year: equalYear ? void 0 : "numeric"
    };
    if (singleDayDateRange) {
      return dateFormatter(finalDate);
    }
    return `${dateFormatter(
      initialDate,
      initialDateOptions
    )} - ${dateFormatter(finalDate)}`;
  }
  function formatLongDate(value) {
    return Intl.DateTimeFormat([key]).format(new Date(value));
  }
  function formatNumericDay(value) {
    return Intl.DateTimeFormat([key], {
      day: "numeric"
    }).format(new Date(value));
  }
  function formatNumericHour(value) {
    return Intl.DateTimeFormat([key], {
      hour: "numeric"
    }).format(new Date(value));
  }
  return {
    formatChartTitle,
    formatLongDate,
    formatNumericDay,
    formatNumericHour
  };
}

// ../../../../../../../../../../$/bridge/for/main/@clayui/layout
var layout_exports = {};
__export(layout_exports, {
  default: () => layout_default
});
__reExport(layout_exports, clayui_layout_star);
import * as clayui_layout_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$layout.js";
import __default__8 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$layout.js";
var layout_default = __default__8;

// ../../../../../../../../../../$/bridge/for/main/@clayui/sticker
var sticker_exports = {};
__export(sticker_exports, {
  default: () => sticker_default
});
__reExport(sticker_exports, clayui_sticker_star);
import * as clayui_sticker_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$sticker.js";
import __default__9 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$sticker.js";
var sticker_default = __default__9;

// ../../../../../../../../../../$/bridge/for/main/@clayui/button
var button_exports = {};
__export(button_exports, {
  default: () => button_default
});
__reExport(button_exports, clayui_button_star);
import * as clayui_button_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$button.js";
import __default__10 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$button.js";
var button_default = __default__10;

// ../../../../../../../../../../$/bridge/for/main/@clayui/drop-down
var drop_down_exports = {};
__export(drop_down_exports, {
  default: () => drop_down_default
});
__reExport(drop_down_exports, clayui_drop_down_star);
import * as clayui_drop_down_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$drop-down.js";
import __default__11 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$drop-down.js";
var drop_down_default = __default__11;

// ../../../../../../../../../../$/bridge/for/main/@clayui/label
var label_exports = {};
__export(label_exports, {
  default: () => label_default
});
__reExport(label_exports, clayui_label_star);
import * as clayui_label_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$label.js";
import __default__12 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$label.js";
var label_default = __default__12;

// ../../../../../../../../../../$/bridge/for/main/@clayui/tooltip
var tooltip_exports = {};
__export(tooltip_exports, {
  default: () => tooltip_default
});
__reExport(tooltip_exports, clayui_tooltip_star);
import * as clayui_tooltip_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$tooltip.js";
import __default__13 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$tooltip.js";
var tooltip_default = __default__13;

// src/main/resources/META-INF/resources/js/components/Translation.tsx
function Translation({
  onSelectedLanguageClick,
  viewURLs
}) {
  const { languageTag: defaultLanguage } = (0, react_exports.useContext)(StoreStateContext);
  const [active, setActive] = (0, react_exports.useState)(false);
  const selectedLanguage = (0, react_exports.useMemo)(() => {
    return viewURLs.find((language) => language.selected)?.languageId || defaultLanguage || viewURLs[0].languageId;
  }, [defaultLanguage, viewURLs]);
  const { timeSpanKey, timeSpanOffset } = (0, react_exports.useContext)(ChartStateContext);
  return /* @__PURE__ */ react_default.createElement(layout_default.ContentRow, null, /* @__PURE__ */ react_default.createElement(layout_default.ContentCol, null, /* @__PURE__ */ react_default.createElement(
    drop_down_default,
    {
      active,
      hasLeftSymbols: true,
      menuElementAttrs: {
        className: "dropdown-menu__translation"
      },
      onActiveChange: setActive,
      trigger: /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          className: "btn-monospaced",
          displayType: "secondary",
          small: true
        },
        /* @__PURE__ */ react_default.createElement(icon_default, { symbol: selectedLanguage.toLowerCase() }),
        /* @__PURE__ */ react_default.createElement(
          "span",
          {
            className: "d-block font-weight-normal",
            style: { fontSize: "9px" }
          },
          selectedLanguage
        )
      )
    },
    /* @__PURE__ */ react_default.createElement(drop_down_default.ItemList, null, Object.values(viewURLs).map((language, index) => /* @__PURE__ */ react_default.createElement(
      drop_down_default.Item,
      {
        active: language.selected && !!language.languageId,
        key: index,
        onClick: () => {
          onSelectedLanguageClick(
            language.viewURL,
            timeSpanKey,
            timeSpanOffset
          );
        },
        symbolLeft: language.languageId.toLowerCase()
      },
      /* @__PURE__ */ react_default.createElement(layout_default.ContentRow, null, /* @__PURE__ */ react_default.createElement(layout_default.ContentCol, { expand: true }, /* @__PURE__ */ react_default.createElement(tooltip_exports.ClayTooltipProvider, null, /* @__PURE__ */ react_default.createElement(
        "span",
        {
          className: "text-truncate-inline",
          "data-tooltip-align": "top",
          title: language.languageLabel
        },
        /* @__PURE__ */ react_default.createElement("span", { className: "text-truncate" }, language.languageLabel)
      ))), language.default && /* @__PURE__ */ react_default.createElement(label_default, { displayType: "info" }, Liferay.Language.get("default")))
    )))
  )));
}

// src/main/resources/META-INF/resources/js/components/BasicInformation.js
function Author({ author: { authorId, name, url } }) {
  return /* @__PURE__ */ react_default.createElement("div", { className: "text-secondary" }, /* @__PURE__ */ react_default.createElement(
    sticker_default,
    {
      className: classnames_default("c-mr-2 sticker-user-icon", {
        [`user-icon-color-${parseInt(authorId, 10) % 10}`]: !url
      }),
      shape: "circle",
      size: "sm"
    },
    url ? /* @__PURE__ */ react_default.createElement("img", { alt: `${name}.`, className: "sticker-img", src: url }) : /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "user" })
  ), (0, frontend_js_web_exports.sub)(Liferay.Language.get("authored-by-x"), name));
}
function BasicInformation({
  author,
  canonicalURL,
  onSelectedLanguageClick,
  publishDate,
  title,
  viewURLs
}) {
  const { languageTag } = (0, react_exports.useContext)(StoreStateContext);
  const formattedPublishDate = Intl.DateTimeFormat(languageTag, {
    day: "numeric",
    month: "long",
    year: "numeric"
  }).format(new Date(publishDate));
  return /* @__PURE__ */ react_default.createElement("div", { className: "sidebar-section" }, /* @__PURE__ */ react_default.createElement(layout_default.ContentRow, { className: "mb-2", verticalAlign: "center" }, /* @__PURE__ */ react_default.createElement(layout_default.ContentCol, null, /* @__PURE__ */ react_default.createElement("div", { className: "inline-item-before" }, /* @__PURE__ */ react_default.createElement(layout_default.ContentRow, null, /* @__PURE__ */ react_default.createElement(layout_default.ContentCol, null, /* @__PURE__ */ react_default.createElement(
    Translation,
    {
      onSelectedLanguageClick,
      viewURLs
    }
  ))))), /* @__PURE__ */ react_default.createElement(layout_default.ContentCol, { expand: true }, /* @__PURE__ */ react_default.createElement(layout_default.ContentRow, null, /* @__PURE__ */ react_default.createElement("span", { className: "font-weight-semi-bold text-truncate-inline" }, /* @__PURE__ */ react_default.createElement(
    "span",
    {
      className: "text-truncate",
      "data-tooltip-align": "bottom",
      title
    },
    title
  ))), /* @__PURE__ */ react_default.createElement(layout_default.ContentRow, null, /* @__PURE__ */ react_default.createElement(
    "span",
    {
      className: "text-truncate text-truncate-reverse",
      "data-tooltip-align": "bottom",
      title: canonicalURL
    },
    /* @__PURE__ */ react_default.createElement("bdi", { className: "text-secondary" }, canonicalURL)
  )))), /* @__PURE__ */ react_default.createElement(layout_default.ContentRow, { className: "mb-2" }, /* @__PURE__ */ react_default.createElement(layout_default.ContentCol, { expand: true }, /* @__PURE__ */ react_default.createElement("span", { className: "text-secondary" }, (0, frontend_js_web_exports.sub)(
    Liferay.Language.get("published-on-x"),
    formattedPublishDate
  )))), author && /* @__PURE__ */ react_default.createElement(layout_default.ContentRow, null, /* @__PURE__ */ react_default.createElement(layout_default.ContentCol, { expand: true }, /* @__PURE__ */ react_default.createElement(Author, { author }))));
}
Author.propTypes = {
  author: prop_types_default.object.isRequired
};
BasicInformation.propTypes = {
  author: prop_types_default.object,
  canonicalURL: prop_types_default.string.isRequired,
  onSelectedLanguageClick: prop_types_default.func.isRequired,
  publishDate: prop_types_default.string.isRequired,
  title: prop_types_default.string.isRequired,
  viewURLs: prop_types_default.arrayOf(
    prop_types_default.shape({
      default: prop_types_default.bool.isRequired,
      languageId: prop_types_default.string.isRequired,
      selected: prop_types_default.bool.isRequired,
      viewURL: prop_types_default.string.isRequired
    })
  ).isRequired
};
var BasicInformation_default = BasicInformation;

// ../../../../../../../../../../$/bridge/for/main/recharts
var recharts_exports = {};
__reExport(recharts_exports, recharts_star);
import * as recharts_star from "../../frontend-js-recharts/__liferay__/exports/recharts.js";

// src/main/resources/META-INF/resources/js/utils/numberFormat.tsx
var DEFAULT_COMPACT_THRESHOLD = 1e4;
function numberFormat(languageTag, number, options = {}) {
  const { compactThreshold = DEFAULT_COMPACT_THRESHOLD, useCompact } = options;
  const formatOptions = {};
  if (useCompact && number >= compactThreshold) {
    formatOptions.notation = "compact";
  }
  return Intl.NumberFormat(languageTag, formatOptions).format(number);
}

// src/main/resources/META-INF/resources/js/components/CustomDots.js
function ActiveDot(props) {
  const { cx, cy, fill, r, shape, strokeWidth = 0 } = props;
  if (cy === null) {
    return null;
  } else if (shape === "square") {
    const squareSize = r * 2;
    return /* @__PURE__ */ react_default.createElement(
      "rect",
      {
        fill,
        height: squareSize,
        strokeWidth,
        width: squareSize,
        x: cx - r,
        y: cy - r
      }
    );
  } else {
    return /* @__PURE__ */ react_default.createElement(
      "circle",
      {
        cx,
        cy,
        fill,
        r,
        strokeWidth
      }
    );
  }
}
ActiveDot.propTypes = {
  props: prop_types_default.objectOf(
    prop_types_default.shape({
      cx: prop_types_default.number.required,
      cy: prop_types_default.number.required,
      fill: prop_types_default.string.required,
      r: prop_types_default.number.required,
      shape: prop_types_default.oneOf(["square", "circle"]),
      strokeWidth: prop_types_default.number.required
    })
  )
};
function Dot(props) {
  const { cx, cy, fill, r, shape } = props;
  if (cy === null) {
    return null;
  } else if (shape === "square") {
    const squareSize = r * 2;
    return /* @__PURE__ */ react_default.createElement(
      "rect",
      {
        fill,
        height: squareSize,
        width: squareSize,
        x: cx - r,
        y: cy - r
      }
    );
  } else {
    return /* @__PURE__ */ react_default.createElement("circle", { cx, cy, fill, r });
  }
}
Dot.propTypes = {
  props: prop_types_default.objectOf(
    prop_types_default.shape({
      cx: prop_types_default.number.required,
      cy: prop_types_default.number.required,
      fill: prop_types_default.string.required,
      r: prop_types_default.number.required,
      shape: prop_types_default.oneOf(["circle", "square"])
    })
  )
};

// src/main/resources/META-INF/resources/js/components/CustomTooltip.js
function CustomTooltip(props) {
  const {
    formatter,
    label,
    labelFormatter,
    payload,
    publishDateFill,
    separator = "",
    showPublishedDateLabel
  } = props;
  return label ? /* @__PURE__ */ react_default.createElement("div", { className: "custom-tooltip popover" }, /* @__PURE__ */ react_default.createElement("p", { className: "mx-2 popover-header py-1" }, /* @__PURE__ */ react_default.createElement("b", null, labelFormatter ? labelFormatter(label) : label)), /* @__PURE__ */ react_default.createElement("div", { className: "mb-0 p-2 popover-body" }, showPublishedDateLabel && /* @__PURE__ */ react_default.createElement("span", null, /* @__PURE__ */ react_default.createElement(
    "span",
    {
      className: "custom-circle mr-1",
      style: {
        backgroundColor: "white",
        border: `2px solid ${publishDateFill}`
      }
    }
  ), Liferay.Language.get("published")), /* @__PURE__ */ react_default.createElement("ul", { className: "list-unstyled mb-0" }, payload.map((item) => {
    const [value, name, iconType] = formatter ? formatter(item.value, item.name, item.iconType) : [item.value, item.name, item.iconType];
    return /* @__PURE__ */ react_default.createElement("li", { key: item.name }, /* @__PURE__ */ react_default.createElement(
      "span",
      {
        className: `custom-${iconType} mr-1`,
        style: {
          backgroundColor: item.color
        }
      }
    ), name, separator, /* @__PURE__ */ react_default.createElement("b", null, value));
  })))) : null;
}
CustomTooltip.propTypes = {
  formatter: prop_types_default.func,
  label: prop_types_default.string,
  labelFormatter: prop_types_default.func,
  payload: prop_types_default.arrayOf(
    prop_types_default.shape({
      name: prop_types_default.string.isRequired,
      value: prop_types_default.number.isRequired
    })
  ),
  publishDateFill: prop_types_default.string,
  separator: prop_types_default.string,
  showPublishedDateLabel: prop_types_default.bool
};

// src/main/resources/META-INF/resources/js/components/Chart.js
var CHART_COLORS = {
  analyticsReportsHistoricalReads: "#50D2A0",
  analyticsReportsHistoricalViews: "#4B9BFF",
  cartesianGrid: "#E7E7ED",
  publishDate: "#2E5AAC"
};
var CHART_SIZES = {
  dotRadius: 4,
  fill: "white",
  height: 220,
  lineWidth: 2,
  width: 280,
  yAxisWidth: 40
};
var DAY_IN_MILLISECONDS = 24 * 60 * 60 * 1e3;
var HOUR_IN_MILLISECONDS = 60 * 60 * 1e3;
var LAST_24_HOURS = "last-24-hours";
var METRICS_STATIC_VALUES = {
  analyticsReportsHistoricalReads: {
    color: CHART_COLORS.analyticsReportsHistoricalReads,
    iconType: "square",
    langKey: Liferay.Language.get("reads-metric")
  },
  analyticsReportsHistoricalViews: {
    color: CHART_COLORS.analyticsReportsHistoricalViews,
    iconType: "circle",
    langKey: Liferay.Language.get("views-metric")
  }
};
function keyToTranslatedLabelValue(key) {
  return METRICS_STATIC_VALUES[key]?.langKey ?? key;
}
function keyToHexColor(key) {
  return METRICS_STATIC_VALUES[key]?.color ?? "#666666";
}
function keyToIconType(key) {
  return METRICS_STATIC_VALUES[key]?.iconType ?? "line";
}
function thousandsToKilosFormater(value) {
  if (value > 1e3) {
    return value / 1e3 + "K";
  }
  return value;
}
function legendFormatterGenerator(totals, languageTag, publishedToday, validAnalyticsConnection) {
  return (value) => {
    const preformattedNumber = totals[value];
    return /* @__PURE__ */ react_default.createElement("span", null, /* @__PURE__ */ react_default.createElement(
      "span",
      {
        className: `custom-${keyToIconType(value)} mr-2`,
        style: {
          backgroundColor: keyToHexColor(value)
        }
      }
    ), /* @__PURE__ */ react_default.createElement("span", { className: "text-secondary" }, keyToTranslatedLabelValue(value)), /* @__PURE__ */ react_default.createElement("span", { className: "font-weight-bold inline-item-after" }, validAnalyticsConnection && preformattedNumber !== null && !publishedToday ? numberFormat(languageTag, preformattedNumber) : "-"));
  };
}
function Chart({ dataProviders = [], publishDate }) {
  const { validAnalyticsConnection } = (0, react_exports.useContext)(ConnectionContext_default);
  const storeDispatch = (0, react_exports.useContext)(StoreDispatchContext);
  const chartDispatch = (0, react_exports.useContext)(ChartDispatchContext);
  const { languageTag, publishedToday } = (0, react_exports.useContext)(StoreStateContext);
  const { dataSet, lineChartLoading, timeRange, timeSpanKey, timeSpanOffset } = (0, react_exports.useContext)(ChartStateContext);
  const isPreviousPeriodButtonDisabled = useIsPreviousPeriodButtonDisabled();
  const dateFormatters = (0, react_exports.useMemo)(
    () => generateDateFormatters(languageTag),
    [languageTag]
  );
  const isMounted = (0, frontend_js_react_web_exports.useIsMounted)();
  (0, react_exports.useEffect)(() => {
    let gone = false;
    const timeSpanComparator = timeSpanKey === LAST_24_HOURS ? HOUR_IN_MILLISECONDS : DAY_IN_MILLISECONDS;
    const keys = /* @__PURE__ */ new Set(["analyticsReportsHistoricalViews"]);
    if (dataProviders.length === 2) {
      keys.add("analyticsReportsHistoricalReads");
    }
    if (validAnalyticsConnection) {
      const promises = dataProviders.map((getter) => {
        return getter();
      });
      allSettled(promises).then((data) => {
        if (gone || !isMounted()) {
          return;
        }
        let dataSetItems = {};
        for (let i = 0; i < data.length; i++) {
          if (data[i].status === "fulfilled") {
            dataSetItems = {
              ...dataSetItems,
              ...data[i].value
            };
          } else {
            storeDispatch({ type: "ADD_WARNING" });
          }
        }
        chartDispatch({
          payload: {
            dataSetItems,
            keys,
            timeSpanComparator
          },
          type: "ADD_DATA_SET_ITEMS",
          validAnalyticsConnection
        });
      });
    } else {
      chartDispatch({
        payload: {
          keys,
          timeSpanComparator
        },
        type: "ADD_DATA_SET_ITEMS",
        validAnalyticsConnection
      });
    }
    return () => {
      gone = true;
    };
  }, [timeSpanKey, timeSpanOffset]);
  const { histogram, keyList } = dataSet;
  const referenceDotPosition = (0, react_exports.useMemo)(() => {
    const publishDateISOString = new Date(publishDate).toISOString();
    return timeSpanKey === LAST_24_HOURS ? publishDateISOString.split(":")[0].concat(":00:00") : publishDateISOString.split("T")[0].concat("T00:00:00");
  }, [timeSpanKey, publishDate]);
  const legendFormatter = dataSet && legendFormatterGenerator(
    dataSet.totals,
    languageTag,
    publishedToday,
    validAnalyticsConnection
  );
  const xAxisFormatter = timeSpanKey === LAST_24_HOURS ? dateFormatters.formatNumericHour : dateFormatters.formatNumericDay;
  const lineChartWrapperClasses = classnames_default("line-chart-wrapper", {
    "line-chart-wrapper--loading": lineChartLoading
  });
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, dataSet ? /* @__PURE__ */ react_default.createElement("div", { className: lineChartWrapperClasses }, lineChartLoading && /* @__PURE__ */ react_default.createElement(
    loading_indicator_default,
    {
      className: "chart-loading-indicator",
      small: true
    }
  ), /* @__PURE__ */ react_default.createElement("div", { className: "line-chart" }, /* @__PURE__ */ react_default.createElement(
    recharts_exports.LineChart,
    {
      data: histogram,
      height: CHART_SIZES.height,
      width: CHART_SIZES.width
    },
    /* @__PURE__ */ react_default.createElement(
      recharts_exports.Legend,
      {
        formatter: legendFormatter,
        iconSize: 0,
        layout: "vertical",
        verticalAlign: "top",
        wrapperStyle: {
          left: 0,
          top: 0
        }
      }
    ),
    /* @__PURE__ */ react_default.createElement(
      recharts_exports.CartesianGrid,
      {
        stroke: CHART_COLORS.cartesianGrid,
        strokeDasharray: "0 0",
        vertical: true,
        verticalPoints: [
          CHART_SIZES.width - CHART_SIZES.dotRadius
        ]
      }
    ),
    /* @__PURE__ */ react_default.createElement(
      recharts_exports.XAxis,
      {
        axisLine: {
          stroke: CHART_COLORS.cartesianGrid
        },
        dataKey: "label",
        domain: !validAnalyticsConnection || !histogram.length ? [
          new Date(
            timeRange.startDate
          ).getDate(),
          new Date(
            timeRange.endDate
          ).getDate()
        ] : [],
        interval: "preserveStartEnd",
        tickCount: 7,
        tickFormatter: (value) => {
          return validAnalyticsConnection && histogram.length !== 0 ? xAxisFormatter(value) : value;
        },
        tickLine: false,
        type: validAnalyticsConnection && histogram.length !== 0 ? "category" : "number"
      }
    ),
    !validAnalyticsConnection || publishedToday || !histogram.length ? /* @__PURE__ */ react_default.createElement(
      recharts_exports.YAxis,
      {
        axisLine: {
          stroke: CHART_COLORS.cartesianGrid
        },
        tickLine: false,
        ticks: [0, 50, 100],
        width: CHART_SIZES.yAxisWidth
      }
    ) : /* @__PURE__ */ react_default.createElement(
      recharts_exports.YAxis,
      {
        allowDecimals: false,
        axisLine: {
          stroke: CHART_COLORS.cartesianGrid
        },
        minTickGap: 3,
        tickFormatter: thousandsToKilosFormater,
        tickLine: false,
        width: CHART_SIZES.yAxisWidth
      }
    ),
    validAnalyticsConnection && !publishedToday && /* @__PURE__ */ react_default.createElement(
      recharts_exports.Tooltip,
      {
        animationDuration: 0,
        content: /* @__PURE__ */ react_default.createElement(
          CustomTooltip,
          {
            publishDateFill: CHART_COLORS.publishDate,
            showPublishedDateLabel: isPreviousPeriodButtonDisabled
          }
        ),
        cursor: validAnalyticsConnection && histogram.length !== 0 && !publishedToday,
        formatter: (value, name) => {
          return [
            numberFormat(languageTag, value),
            keyToTranslatedLabelValue(name),
            keyToIconType(name)
          ];
        },
        labelFormatter: dateFormatters.formatLongDate,
        separator: ": "
      }
    ),
    keyList.map((keyName) => {
      const color = keyToHexColor(keyName);
      const shape = keyToIconType(keyName);
      return /* @__PURE__ */ react_default.createElement(
        recharts_exports.Line,
        {
          activeDot: /* @__PURE__ */ react_default.createElement(ActiveDot, { shape }),
          dataKey: keyName,
          dot: /* @__PURE__ */ react_default.createElement(Dot, { shape }),
          fill: color,
          isAnimationActive: false,
          key: keyName,
          stroke: color,
          strokeWidth: CHART_SIZES.lineWidth,
          type: "monotone"
        }
      );
    }),
    validAnalyticsConnection && !publishedToday && /* @__PURE__ */ react_default.createElement(
      recharts_exports.ReferenceDot,
      {
        isFront: true,
        r: 4,
        stroke: CHART_COLORS.publishDate,
        strokeWidth: CHART_SIZES.lineWidth,
        x: referenceDotPosition,
        y: 0
      }
    )
  ))) : null);
}
function allSettled(promises) {
  return Promise.all(
    promises.map((promise) => {
      return promise.then((value) => {
        return { status: "fulfilled", value };
      }).catch((reason) => {
        return { reason, status: "rejected" };
      });
    })
  );
}
Chart.propTypes = {
  dataProviders: prop_types_default.arrayOf(prop_types_default.func).isRequired,
  publishDate: prop_types_default.string.isRequired,
  timeSpanOptions: prop_types_default.arrayOf(
    prop_types_default.shape({
      key: prop_types_default.string.isRequired,
      label: prop_types_default.string.isRequired
    })
  ).isRequired
};

// ../../../../../../../../../../$/bridge/for/main/@clayui/form
var form_exports = {};
__export(form_exports, {
  default: () => form_default
});
__reExport(form_exports, clayui_form_star);
import * as clayui_form_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$form.js";
import __default__14 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$form.js";
var form_default = __default__14;

// src/main/resources/META-INF/resources/js/components/TimeSpanSelector.tsx
function TimeSpanSelector({
  disabledNextTimeSpan,
  disabledPreviousPeriodButton,
  timeSpanKey,
  timeSpanOptions
}) {
  const { validAnalyticsConnection } = (0, react_exports.useContext)(ConnectionContext_default);
  const dispatch = (0, react_exports.useContext)(ChartDispatchContext);
  return /* @__PURE__ */ react_default.createElement("div", { className: "d-flex" }, /* @__PURE__ */ react_default.createElement(
    form_exports.ClaySelect,
    {
      "aria-label": Liferay.Language.get("select-date-range"),
      className: "bg-white",
      disabled: !validAnalyticsConnection,
      onChange: (event) => {
        const { value } = event.target;
        dispatch({
          payload: { key: value },
          type: "CHANGE_TIME_SPAN_KEY"
        });
      },
      value: timeSpanKey || void 0
    },
    timeSpanOptions.map((option) => {
      return /* @__PURE__ */ react_default.createElement(
        form_exports.ClaySelect.Option,
        {
          key: option.key?.toString(),
          label: option.label,
          value: option.key?.toString()
        }
      );
    })
  ), /* @__PURE__ */ react_default.createElement("div", { className: "d-flex flex-shrink-0 ml-2" }, /* @__PURE__ */ react_default.createElement(
    button_exports.ClayButtonWithIcon,
    {
      "aria-label": Liferay.Language.get("previous-period"),
      className: "mr-1",
      "data-tooltip-align": "top-right",
      disabled: !validAnalyticsConnection || disabledPreviousPeriodButton,
      displayType: "secondary",
      onClick: () => dispatch({ type: "PREV_TIME_SPAN" }),
      small: true,
      symbol: "angle-left",
      title: disabledPreviousPeriodButton ? Liferay.Language.get(
        "you-cannot-choose-a-date-prior-to-the-publication-date"
      ) : void 0
    }
  ), /* @__PURE__ */ react_default.createElement(
    button_exports.ClayButtonWithIcon,
    {
      "aria-label": Liferay.Language.get("next-period"),
      disabled: !validAnalyticsConnection || disabledNextTimeSpan,
      displayType: "secondary",
      onClick: () => dispatch({ type: "NEXT_TIME_SPAN" }),
      small: true,
      symbol: "angle-right"
    }
  )));
}

// ../../../../../../../../../../$/bridge/for/main/@clayui/popover
var popover_exports = {};
__export(popover_exports, {
  default: () => popover_default
});
__reExport(popover_exports, clayui_popover_star);
import * as clayui_popover_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$popover.js";
import __default__15 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$popover.js";
var popover_default = __default__15;

// src/main/resources/META-INF/resources/js/components/Hint.tsx
function Hint({ message, position = "top", secondary, title }) {
  const [showPopover, setShowPopover] = (0, react_exports.useState)(false);
  return /* @__PURE__ */ react_default.createElement(
    popover_default,
    {
      alignPosition: position,
      className: "position-fixed",
      header: title,
      onShowChange: setShowPopover,
      show: showPopover,
      trigger: /* @__PURE__ */ react_default.createElement(
        "span",
        {
          className: classnames_default("p-1", {
            "text-secondary": secondary
          }),
          onMouseEnter: () => setShowPopover(true),
          onMouseLeave: () => setShowPopover(false)
        },
        /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "question-circle" })
      )
    },
    message
  );
}
var Hint_default = Hint;

// src/main/resources/META-INF/resources/js/components/TotalCount.tsx
function TotalCount({
  className,
  dataProvider,
  label,
  percentage = false,
  popoverHeader,
  popoverMessage,
  popoverPosition
}) {
  const { validAnalyticsConnection } = (0, react_exports.useContext)(ConnectionContext_default);
  const [value, setValue] = (0, frontend_js_react_web_exports.useStateSafe)("-");
  const dispatch = (0, react_exports.useContext)(StoreDispatchContext);
  const { languageTag, publishedToday } = (0, react_exports.useContext)(StoreStateContext);
  (0, react_exports.useEffect)(() => {
    if (validAnalyticsConnection) {
      dataProvider().then(setValue).catch(() => {
        setValue("-");
        dispatch({ type: "ADD_WARNING" });
      });
    }
  }, [dispatch, dataProvider, setValue, validAnalyticsConnection]);
  let displayValue = "-";
  if (validAnalyticsConnection && languageTag && !publishedToday) {
    displayValue = value !== "-" ? percentage ? /* @__PURE__ */ react_default.createElement("span", null, `${value}%`) : numberFormat(languageTag, Number(value)) : value;
  }
  return /* @__PURE__ */ react_default.createElement("div", { className }, /* @__PURE__ */ react_default.createElement("span", { className: "text-secondary" }, label), /* @__PURE__ */ react_default.createElement("span", { className: "text-secondary" }, /* @__PURE__ */ react_default.createElement(
    Hint,
    {
      message: popoverMessage,
      position: popoverPosition,
      title: popoverHeader
    }
  )), /* @__PURE__ */ react_default.createElement("span", { className: "font-weight-bold inline-item-after" }, displayValue));
}
var TotalCount_default = TotalCount;

// src/main/resources/META-INF/resources/js/components/EmptyPieChart.js
var EMPTY_PIE_CHART_FILL_COLOR = "#f1f2f5";
function EmptyPieChart({
  height,
  innerRadius,
  outerRadius,
  width
}) {
  return /* @__PURE__ */ react_default.createElement("div", { className: "pie-chart-wrapper--chart" }, /* @__PURE__ */ react_default.createElement(recharts_exports.PieChart, { height, width }, /* @__PURE__ */ react_default.createElement(
    recharts_exports.Pie,
    {
      cx: "50%",
      cy: "50%",
      data: [{ value: 100 }],
      dataKey: "value",
      innerRadius,
      isAnimationActive: false,
      nameKey: "name",
      outerRadius,
      paddingAngle: 1
    },
    /* @__PURE__ */ react_default.createElement(recharts_exports.Cell, { fill: EMPTY_PIE_CHART_FILL_COLOR })
  )));
}
EmptyPieChart.propTypes = {
  height: prop_types_default.number.isRequired,
  innerRadius: prop_types_default.number.isRequired,
  outerRadius: prop_types_default.number.isRequired,
  width: prop_types_default.number.isRequired
};

// src/main/resources/META-INF/resources/js/components/TrafficSources.js
var COLORS_MAP = {
  direct: "#FF73C3",
  organic: "#4B9FFF",
  paid: "#FFB46E",
  referral: "#FF5F5F",
  social: "#50D2A0"
};
var PIE_CHART_SIZES = {
  height: 140,
  innerRadius: 40,
  outerRadius: 70,
  paddingAngle: 1,
  width: 140
};
var FALLBACK_COLOR = "#e92563";
var getColorByName = (name) => COLORS_MAP[name] || FALLBACK_COLOR;
function TrafficSources({ dataProvider, onTrafficSourceClick }) {
  const [highlighted, setHighlighted] = (0, react_exports.useState)(null);
  const isMounted = (0, frontend_js_react_web_exports.useIsMounted)();
  const { validAnalyticsConnection } = (0, react_exports.useContext)(ConnectionContext_default);
  const dispatch = (0, react_exports.useContext)(StoreDispatchContext);
  const chartDispatch = (0, react_exports.useContext)(ChartDispatchContext);
  const { languageTag, publishedToday } = (0, react_exports.useContext)(StoreStateContext);
  const { pieChartLoading, timeSpanKey, timeSpanOffset } = (0, react_exports.useContext)(ChartStateContext);
  const [trafficSources, setTrafficSources] = (0, frontend_js_react_web_exports.useStateSafe)([]);
  const pieChartWrapperClasses = classnames_default("pie-chart-wrapper", {
    "pie-chart-wrapper--loading": pieChartLoading
  });
  (0, react_exports.useEffect)(() => {
    if (validAnalyticsConnection) {
      chartDispatch({
        payload: {
          loading: true
        },
        type: "SET_PIE_CHART_LOADING"
      });
      dataProvider().then((trafficSources2) => {
        if (isMounted()) {
          setTrafficSources(trafficSources2);
        }
      }).catch(() => {
        if (isMounted()) {
          setTrafficSources([]);
          dispatch({ type: "ADD_WARNING" });
        }
      }).finally(() => {
        if (isMounted()) {
          chartDispatch({
            payload: {
              loading: false
            },
            type: "SET_PIE_CHART_LOADING"
          });
        }
      });
    }
  }, [
    chartDispatch,
    dispatch,
    dataProvider,
    setTrafficSources,
    timeSpanKey,
    timeSpanOffset,
    validAnalyticsConnection,
    isMounted
  ]);
  const fullPieChart = (0, react_exports.useMemo)(
    () => validAnalyticsConnection && !publishedToday && trafficSources?.some(({ value }) => value),
    [publishedToday, trafficSources, validAnalyticsConnection]
  );
  const missingTrafficSourceValue = (0, react_exports.useMemo)(
    () => trafficSources?.some(({ value }) => value === void 0),
    [trafficSources]
  );
  (0, react_exports.useEffect)(() => {
    if (missingTrafficSourceValue) {
      dispatch({ type: "ADD_WARNING" });
    }
  }, [dispatch, missingTrafficSourceValue]);
  function handleLegendMouseEnter(name) {
    setHighlighted(name);
  }
  function handleLegendMouseLeave() {
    setHighlighted(null);
  }
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement("h5", { className: "mt-3 sheet-subtitle" }, Liferay.Language.get("traffic-channels"), /* @__PURE__ */ react_default.createElement(
    Hint_default,
    {
      message: Liferay.Language.get("traffic-channels-help"),
      secondary: true,
      title: Liferay.Language.get("traffic-channels")
    }
  )), !fullPieChart && !missingTrafficSourceValue && /* @__PURE__ */ react_default.createElement("div", { className: "mb-3 text-secondary" }, Liferay.Language.get(
    "your-page-has-no-incoming-traffic-from-traffic-channels-yet"
  )), /* @__PURE__ */ react_default.createElement("div", { className: pieChartWrapperClasses }, pieChartLoading && /* @__PURE__ */ react_default.createElement(
    loading_indicator_default,
    {
      className: "chart-loading-indicator",
      small: true
    }
  ), /* @__PURE__ */ react_default.createElement("div", { className: "pie-chart-wrapper--legend" }, /* @__PURE__ */ react_default.createElement("table", null, /* @__PURE__ */ react_default.createElement("tbody", null, trafficSources?.map((entry) => {
    const hasDetails = entry?.value > 0 && entry?.endpointURL;
    return /* @__PURE__ */ react_default.createElement("tr", { key: entry.name }, /* @__PURE__ */ react_default.createElement(
      "td",
      {
        className: "px-0",
        onMouseOut: handleLegendMouseLeave,
        onMouseOver: () => handleLegendMouseEnter(
          entry.name
        )
      },
      /* @__PURE__ */ react_default.createElement(
        "span",
        {
          className: "pie-chart-wrapper--legend--dot",
          style: {
            backgroundColor: getColorByName(
              entry.name
            )
          }
        }
      )
    ), /* @__PURE__ */ react_default.createElement(
      "td",
      {
        className: "c-py-1 text-secondary",
        onMouseOut: handleLegendMouseLeave,
        onMouseOver: () => handleLegendMouseEnter(
          entry.name
        )
      },
      validAnalyticsConnection && !publishedToday && hasDetails ? /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          className: "px-0 py-1 text-primary",
          displayType: "link",
          onClick: () => onTrafficSourceClick(
            trafficSources,
            entry.name,
            false
          ),
          small: true
        },
        entry.title
      ) : /* @__PURE__ */ react_default.createElement("span", null, entry.title)
    ), /* @__PURE__ */ react_default.createElement("td", { className: "text-secondary" }, /* @__PURE__ */ react_default.createElement(
      Hint_default,
      {
        message: entry.helpMessage,
        title: entry.title
      }
    )), /* @__PURE__ */ react_default.createElement("td", { className: "font-weight-semi-bold" }, validAnalyticsConnection && !publishedToday && entry.value !== void 0 ? numberFormat(
      languageTag,
      entry.value,
      {
        useCompact: true
      }
    ) : "-"));
  })))), !fullPieChart && /* @__PURE__ */ react_default.createElement(
    EmptyPieChart,
    {
      height: PIE_CHART_SIZES.height,
      innerRadius: PIE_CHART_SIZES.innerRadius,
      outerRadius: PIE_CHART_SIZES.outerRadius,
      width: PIE_CHART_SIZES.width
    }
  ), fullPieChart && /* @__PURE__ */ react_default.createElement("div", { className: "pie-chart-wrapper--chart" }, /* @__PURE__ */ react_default.createElement(
    recharts_exports.PieChart,
    {
      height: PIE_CHART_SIZES.height,
      width: PIE_CHART_SIZES.width
    },
    /* @__PURE__ */ react_default.createElement(
      recharts_exports.Pie,
      {
        cx: "50%",
        cy: "50%",
        data: trafficSources,
        dataKey: "value",
        innerRadius: PIE_CHART_SIZES.innerRadius,
        isAnimationActive: false,
        nameKey: "name",
        outerRadius: PIE_CHART_SIZES.outerRadius,
        paddingAngle: PIE_CHART_SIZES.paddingAngle
      },
      trafficSources.map((entry, i) => {
        const fillColor = getColorByName(
          entry.name
        );
        const cellClasses = classnames_default({
          dim: highlighted && entry.name !== highlighted
        });
        return /* @__PURE__ */ react_default.createElement(
          recharts_exports.Cell,
          {
            className: cellClasses,
            fill: fillColor,
            key: i,
            onMouseOut: handleLegendMouseLeave,
            onMouseOver: () => handleLegendMouseEnter(
              entry.name
            )
          }
        );
      })
    ),
    /* @__PURE__ */ react_default.createElement(
      recharts_exports.Tooltip,
      {
        animationDuration: 0,
        content: /* @__PURE__ */ react_default.createElement(TrafficSourcesCustomTooltip, null),
        formatter: (value, name, iconType) => {
          return [
            numberFormat(languageTag, value),
            name,
            iconType
          ];
        },
        separator: ": "
      }
    )
  ))));
}
function TrafficSourcesCustomTooltip(props) {
  const { formatter, payload, separator = "" } = props;
  return /* @__PURE__ */ react_default.createElement("div", { className: "custom-tooltip popover" }, /* @__PURE__ */ react_default.createElement("p", { className: "mx-2 popover-header py-1" }, /* @__PURE__ */ react_default.createElement(
    "b",
    null,
    // eslint-disable-next-line @liferay/no-length-jsx-expression
    payload.length && payload[0].payload.title
  )), /* @__PURE__ */ react_default.createElement("ul", { className: "list-unstyled mb-0 p-2 popover-body" }, /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, payload.map((item) => {
    const [value, _name, iconType] = formatter ? formatter(item.value, item.name, item.iconType) : [item.value, item.name, item.iconType];
    const { payload: payload2 } = item;
    return /* @__PURE__ */ react_default.createElement(react_default.Fragment, { key: item.name }, /* @__PURE__ */ react_default.createElement("li", null, Liferay.Language.get("visitors"), separator, /* @__PURE__ */ react_default.createElement("b", null, value)), /* @__PURE__ */ react_default.createElement("li", null, Liferay.Language.get("traffic-share"), separator, /* @__PURE__ */ react_default.createElement("b", null, `${payload2.share}%`)));
  }))));
}
TrafficSources.propTypes = {
  dataProvider: prop_types_default.func.isRequired,
  onTrafficSourceClick: prop_types_default.func.isRequired
};

// src/main/resources/META-INF/resources/js/components/Main.js
function Main({
  author,
  canonicalURL,
  chartDataProviders,
  className,
  onSelectedLanguageClick,
  onTrafficSourceClick,
  pagePublishDate,
  pageTitle,
  timeSpanOptions,
  totalReadsDataProvider,
  totalViewsDataProvider,
  trafficSourcesDataProvider,
  viewURLs
}) {
  const { timeSpanKey, timeSpanOffset } = (0, react_exports.useContext)(ChartStateContext);
  const { languageTag } = (0, react_exports.useContext)(StoreStateContext);
  const isPreviousPeriodButtonDisabled = useIsPreviousPeriodButtonDisabled();
  const { firstDate, lastDate } = useDateTitle();
  const dateFormatters = (0, react_exports.useMemo)(
    () => generateDateFormatters(languageTag),
    [languageTag]
  );
  const title = dateFormatters.formatChartTitle([firstDate, lastDate]);
  return /* @__PURE__ */ react_default.createElement("div", { className: `analytics-reports-app-main pb-3 px-3 ${className}` }, /* @__PURE__ */ react_default.createElement(
    BasicInformation_default,
    {
      author,
      canonicalURL,
      onSelectedLanguageClick,
      publishDate: pagePublishDate,
      title: pageTitle,
      viewURLs
    }
  ), !!timeSpanOptions.length && /* @__PURE__ */ react_default.createElement("div", { className: "c-mb-2 c-mt-4" }, /* @__PURE__ */ react_default.createElement(
    TimeSpanSelector,
    {
      disabledNextTimeSpan: timeSpanOffset === 0,
      disabledPreviousPeriodButton: isPreviousPeriodButtonDisabled,
      timeSpanKey,
      timeSpanOptions
    }
  )), title && /* @__PURE__ */ react_default.createElement("h5", { className: "c-mb-4" }, title), /* @__PURE__ */ react_default.createElement("h5", { className: "mt-3 sheet-subtitle" }, Liferay.Language.get("engagement")), /* @__PURE__ */ react_default.createElement(
    TotalCount_default,
    {
      className: "mb-2",
      dataProvider: totalViewsDataProvider,
      label: (0, frontend_js_web_exports.sub)(Liferay.Language.get("total-views")),
      popoverHeader: Liferay.Language.get("total-views"),
      popoverMessage: Liferay.Language.get(
        "this-number-refers-to-the-total-number-of-views-since-the-content-was-published"
      )
    }
  ), totalReadsDataProvider && /* @__PURE__ */ react_default.createElement(
    TotalCount_default,
    {
      className: "mb-2",
      dataProvider: totalReadsDataProvider,
      label: (0, frontend_js_web_exports.sub)(Liferay.Language.get("total-reads")),
      popoverHeader: Liferay.Language.get("total-reads"),
      popoverMessage: Liferay.Language.get(
        "this-number-refers-to-the-total-number-of-reads-since-the-content-was-published"
      )
    }
  ), /* @__PURE__ */ react_default.createElement(
    Chart,
    {
      dataProviders: chartDataProviders,
      publishDate: pagePublishDate,
      timeSpanOptions
    }
  ), /* @__PURE__ */ react_default.createElement(
    TrafficSources,
    {
      dataProvider: trafficSourcesDataProvider,
      onTrafficSourceClick
    }
  ));
}
Main.defaultProps = {
  author: null,
  className: "",
  totalReadsDataProvider: null
};
Main.propTypes = {
  author: prop_types_default.object,
  canonicalURL: prop_types_default.string.isRequired,
  chartDataProviders: prop_types_default.arrayOf(prop_types_default.func.isRequired).isRequired,
  className: prop_types_default.string,
  onSelectedLanguageClick: prop_types_default.func.isRequired,
  onTrafficSourceClick: prop_types_default.func.isRequired,
  pagePublishDate: prop_types_default.string.isRequired,
  pageTitle: prop_types_default.string.isRequired,
  timeSpanOptions: prop_types_default.arrayOf(
    prop_types_default.shape({
      key: prop_types_default.string,
      label: prop_types_default.string
    })
  ).isRequired,
  totalReadsDataProvider: prop_types_default.func,
  totalViewsDataProvider: prop_types_default.func.isRequired,
  trafficSourcesDataProvider: prop_types_default.func.isRequired,
  viewURLs: prop_types_default.arrayOf(
    prop_types_default.shape({
      default: prop_types_default.bool.isRequired,
      languageId: prop_types_default.string.isRequired,
      languageLabel: prop_types_default.string.isRequired,
      selected: prop_types_default.bool.isRequired,
      viewURL: prop_types_default.string.isRequired
    })
  ).isRequired
};

// ../../../../../../../../../../$/bridge/for/main/@clayui/list
var list_exports = {};
__export(list_exports, {
  default: () => list_default
});
__reExport(list_exports, clayui_list_star);
import * as clayui_list_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$list.js";
import __default__16 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$list.js";
var list_default = __default__16;

// src/main/resources/META-INF/resources/js/components/Keywords.tsx
var KEYWORD_VALUE_TYPE = [
  { label: Liferay.Language.get("traffic"), name: "traffic" },
  { label: Liferay.Language.get("search-volume"), name: "volume" },
  { label: Liferay.Language.get("position"), name: "position" }
];
function Keywords({ currentPage }) {
  const [isDropdownOpen, setIsDropdownOpen] = (0, react_exports.useState)(false);
  const [keywordValueType, setKeywordValueType] = (0, react_exports.useState)(
    KEYWORD_VALUE_TYPE[0]
  );
  const { languageTag, publishedToday } = (0, react_exports.useContext)(StoreStateContext);
  const countries = (0, react_exports.useMemo)(() => {
    const dataKeys = /* @__PURE__ */ new Set();
    return currentPage.data.countrySearchKeywords.reduce(
      (acc, { countryCode, countryName }) => {
        if (dataKeys.has(countryCode)) {
          return acc;
        }
        dataKeys.add(countryCode);
        return acc.concat({ countryCode, countryName });
      },
      []
    );
  }, [currentPage.data.countrySearchKeywords]);
  const [currentCountry, setCurrentCountry] = (0, react_exports.useState)(
    countries[0].countryCode
  );
  const keywords = (0, react_exports.useMemo)(() => {
    const countryKeywords = currentCountry && currentPage.data.countrySearchKeywords.find((country) => {
      return country.countryCode === currentCountry;
    });
    return countryKeywords ? countryKeywords.keywords : [];
  }, [currentPage.data.countrySearchKeywords, currentCountry]);
  const handleCountrySelection = (event) => {
    const country = event.target.value;
    setCurrentCountry(country);
  };
  const handleKeywordValueType = (valueTypeName) => {
    const newKeywordValueType = KEYWORD_VALUE_TYPE.find(
      (keywordValueType2) => {
        return keywordValueType2.name === valueTypeName;
      }
    );
    if (newKeywordValueType) {
      setKeywordValueType(newKeywordValueType);
    }
  };
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement("h5", { className: "mt-3 sheet-subtitle" }, Liferay.Language.get("best-keywords")), /* @__PURE__ */ react_default.createElement("div", { className: "mb-3 text-secondary" }, Liferay.Language.get("best-keywords-description")), /* @__PURE__ */ react_default.createElement("div", { className: "form-group" }, /* @__PURE__ */ react_default.createElement("label", { htmlFor: "countrySelect" }, Liferay.Language.get("select-country")), /* @__PURE__ */ react_default.createElement(
    form_exports.ClaySelect,
    {
      "aria-label": Liferay.Language.get("select-country"),
      className: "bg-white",
      defaultValue: currentCountry,
      id: "countrySelect",
      onChange: handleCountrySelection
    },
    countries.map((item) => /* @__PURE__ */ react_default.createElement(
      form_exports.ClaySelect.Option,
      {
        key: item.countryCode,
        label: item.countryName,
        value: item.countryCode
      }
    ))
  )), /* @__PURE__ */ react_default.createElement(list_default, { className: "list-group-keywords-list" }, /* @__PURE__ */ react_default.createElement(list_default.Item, { flex: true }, /* @__PURE__ */ react_default.createElement(list_default.ItemField, { expand: true }, /* @__PURE__ */ react_default.createElement(list_default.ItemTitle, { className: "text-truncate-inline" }, /* @__PURE__ */ react_default.createElement("span", { className: "text-truncate" }, Liferay.Language.get("best-keyword"), /* @__PURE__ */ react_default.createElement("span", { className: "text-secondary" }, /* @__PURE__ */ react_default.createElement(
    Hint_default,
    {
      message: Liferay.Language.get(
        "best-keyword-help"
      ),
      title: Liferay.Language.get(
        "best-keyword"
      )
    }
  ))))), /* @__PURE__ */ react_default.createElement(list_default.ItemField, null, /* @__PURE__ */ react_default.createElement(
    drop_down_default,
    {
      active: isDropdownOpen,
      onActiveChange: setIsDropdownOpen,
      trigger: /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          className: "px-0 text-body",
          displayType: "link",
          small: true
        },
        /* @__PURE__ */ react_default.createElement("span", { className: "font-weight-semi-bold" }, /* @__PURE__ */ react_default.createElement("span", { className: "pr-2" }, keywordValueType.label), /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "caret-bottom" }))
      )
    },
    /* @__PURE__ */ react_default.createElement(drop_down_default.ItemList, null, KEYWORD_VALUE_TYPE.map((valueType, index) => /* @__PURE__ */ react_default.createElement(
      drop_down_default.Item,
      {
        active: valueType.name === keywordValueType.name,
        key: index,
        onClick: () => {
          handleKeywordValueType(
            valueType.name
          );
          setIsDropdownOpen(false);
        }
      },
      valueType.label
    )))
  ))), /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, !publishedToday && keywords.map(
    ({ keyword, position, searchVolume, traffic }) => {
      return /* @__PURE__ */ react_default.createElement(list_default.Item, { flex: true, key: keyword }, /* @__PURE__ */ react_default.createElement(list_default.ItemField, { expand: true }, /* @__PURE__ */ react_default.createElement(list_default.ItemText, null, /* @__PURE__ */ react_default.createElement(
        "span",
        {
          className: "text-truncate-inline",
          "data-tooltip-align": "top",
          title: keyword
        },
        /* @__PURE__ */ react_default.createElement("span", { className: "text-secondary text-truncate" }, keyword)
      ))), /* @__PURE__ */ react_default.createElement(list_default.ItemField, { expand: true }, /* @__PURE__ */ react_default.createElement("span", { className: "align-self-end font-weight-semi-bold text-dark" }, !languageTag ? "" : numberFormat(
        languageTag,
        keywordValueType.name === "traffic" ? traffic : keywordValueType.name === "volume" ? searchVolume : position
      ))));
    }
  )), /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, (publishedToday || !keywords.length) && /* @__PURE__ */ react_default.createElement(list_default.Item, { flex: true }, /* @__PURE__ */ react_default.createElement(list_default.ItemField, { expand: true }, /* @__PURE__ */ react_default.createElement(list_default.ItemText, null, /* @__PURE__ */ react_default.createElement("span", { className: "text-secondary" }, Liferay.Language.get(
    "there-are-no-best-keywords-yet"
  ))))))));
}
Keywords.propTypes = {
  currentPage: prop_types_default.object.isRequired
};

// src/main/resources/META-INF/resources/js/components/detail/KeywordsDetail.js
function KeywordsDetail({
  currentPage,
  trafficShareDataProvider,
  trafficVolumeDataProvider
}) {
  return /* @__PURE__ */ react_default.createElement("div", { className: "c-p-3 traffic-source-detail" }, /* @__PURE__ */ react_default.createElement(
    TotalCount_default,
    {
      className: "mb-2",
      dataProvider: trafficVolumeDataProvider,
      label: (0, frontend_js_web_exports.sub)(Liferay.Language.get("traffic-volume")),
      popoverHeader: Liferay.Language.get("traffic-volume"),
      popoverMessage: Liferay.Language.get(
        "traffic-volume-is-the-number-of-page-views-coming-from-one-channel"
      ),
      popoverPosition: "bottom"
    }
  ), /* @__PURE__ */ react_default.createElement(
    TotalCount_default,
    {
      className: "mb-4",
      dataProvider: trafficShareDataProvider,
      label: (0, frontend_js_web_exports.sub)(Liferay.Language.get("traffic-share")),
      percentage: true,
      popoverHeader: Liferay.Language.get("traffic-share"),
      popoverMessage: Liferay.Language.get(
        "traffic-share-is-the-percentage-of-traffic-sent-to-your-page-by-one-channel"
      )
    }
  ), /* @__PURE__ */ react_default.createElement(Keywords, { currentPage }));
}
KeywordsDetail.propTypes = {
  currentPage: prop_types_default.object.isRequired,
  trafficShareDataProvider: prop_types_default.func.isRequired,
  trafficVolumeDataProvider: prop_types_default.func.isRequired
};

// src/main/resources/META-INF/resources/js/components/detail/ReferralDetail.js
var ITEMS_TO_SHOW = 5;
function ReferralDetail({
  currentPage,
  handleDetailPeriodChange,
  timeSpanOptions,
  trafficShareDataProvider,
  trafficSourcesDataProvider,
  trafficVolumeDataProvider
}) {
  const { languageTag } = (0, react_exports.useContext)(StoreStateContext);
  const [isReferringPagesExpanded, setIsReferringPagesExpanded] = (0, react_exports.useState)(false);
  const [isReferringDomainsExpanded, setIsReferringDomainsExpanded] = (0, react_exports.useState)(false);
  const { referringDomains, referringPages } = currentPage.data;
  const dateFormatters = (0, react_exports.useMemo)(
    () => generateDateFormatters(languageTag),
    [languageTag]
  );
  const { firstDate, lastDate } = useDateTitle();
  const title = (0, react_exports.useMemo)(() => {
    return dateFormatters.formatChartTitle([firstDate, lastDate]);
  }, [dateFormatters, firstDate, lastDate]);
  const dispatch = (0, react_exports.useContext)(StoreDispatchContext);
  const chartDispatch = (0, react_exports.useContext)(ChartDispatchContext);
  const { pieChartLoading, timeSpanKey, timeSpanOffset } = (0, react_exports.useContext)(ChartStateContext);
  const { validAnalyticsConnection } = (0, react_exports.useContext)(ConnectionContext_default);
  const isPreviousPeriodButtonDisabled = useIsPreviousPeriodButtonDisabled();
  const firstUpdateRef = (0, react_exports.useRef)(true);
  const trafficSourceDetailClasses = classnames_default(
    "c-p-3 traffic-source-detail",
    {
      "traffic-source-detail--loading": pieChartLoading
    }
  );
  (0, react_exports.useEffect)(() => {
    if (firstUpdateRef.current) {
      firstUpdateRef.current = false;
      return;
    }
    if (validAnalyticsConnection) {
      chartDispatch({
        payload: {
          loading: true
        },
        type: "SET_PIE_CHART_LOADING"
      });
      trafficSourcesDataProvider().then((trafficSources) => {
        handleDetailPeriodChange(trafficSources, "referral", true);
      }).catch(() => {
        dispatch({ type: "ADD_WARNING" });
      }).finally(() => {
        chartDispatch({
          payload: {
            loading: false
          },
          type: "SET_PIE_CHART_LOADING"
        });
      });
    }
  }, [
    chartDispatch,
    dispatch,
    handleDetailPeriodChange,
    timeSpanKey,
    timeSpanOffset,
    trafficSourcesDataProvider,
    validAnalyticsConnection
  ]);
  return /* @__PURE__ */ react_default.createElement("div", { className: trafficSourceDetailClasses }, pieChartLoading && /* @__PURE__ */ react_default.createElement(
    loading_indicator_default,
    {
      className: "chart-loading-indicator",
      small: true
    }
  ), /* @__PURE__ */ react_default.createElement("div", { className: "c-mb-3 c-mt-2" }, /* @__PURE__ */ react_default.createElement(
    TimeSpanSelector,
    {
      disabledNextTimeSpan: timeSpanOffset === 0,
      disabledPreviousPeriodButton: isPreviousPeriodButtonDisabled,
      timeSpanKey,
      timeSpanOptions
    }
  )), title && /* @__PURE__ */ react_default.createElement("h5", { className: "c-mb-4" }, title), /* @__PURE__ */ react_default.createElement(
    TotalCount_default,
    {
      className: "c-mb-2",
      dataProvider: trafficVolumeDataProvider,
      label: (0, frontend_js_web_exports.sub)(Liferay.Language.get("traffic-volume")),
      popoverHeader: Liferay.Language.get("traffic-volume"),
      popoverMessage: Liferay.Language.get(
        "traffic-volume-is-the-number-of-page-views-coming-from-one-channel"
      ),
      popoverPosition: "bottom"
    }
  ), /* @__PURE__ */ react_default.createElement(
    TotalCount_default,
    {
      className: "c-mb-3",
      dataProvider: trafficShareDataProvider,
      label: (0, frontend_js_web_exports.sub)(Liferay.Language.get("traffic-share")),
      percentage: true,
      popoverHeader: Liferay.Language.get("traffic-share"),
      popoverMessage: Liferay.Language.get(
        "traffic-share-is-the-percentage-of-traffic-sent-to-your-page-by-one-channel"
      )
    }
  ), /* @__PURE__ */ react_default.createElement(list_default, { className: "list-group-pages-list" }, /* @__PURE__ */ react_default.createElement(list_default.Item, { flex: true }, /* @__PURE__ */ react_default.createElement(list_default.ItemField, { expand: true }, /* @__PURE__ */ react_default.createElement(list_default.ItemTitle, { className: "text-truncate-inline" }, /* @__PURE__ */ react_default.createElement("span", { className: "text-truncate" }, Liferay.Language.get("top-referring-pages"), /* @__PURE__ */ react_default.createElement("span", { className: "text-secondary" }, /* @__PURE__ */ react_default.createElement(
    Hint_default,
    {
      message: Liferay.Language.get(
        "top-referring-pages-help"
      ),
      title: Liferay.Language.get(
        "top-referring-pages"
      )
    }
  ))))), /* @__PURE__ */ react_default.createElement(list_default.ItemField, null, /* @__PURE__ */ react_default.createElement(list_default.ItemTitle, null, /* @__PURE__ */ react_default.createElement("span", null, Liferay.Language.get("traffic"))))), referringPages.slice(0, isReferringPagesExpanded ? 10 : ITEMS_TO_SHOW).map(({ trafficAmount, url }) => {
    return /* @__PURE__ */ react_default.createElement(list_default.Item, { flex: true, key: url }, /* @__PURE__ */ react_default.createElement(list_default.ItemField, { expand: true }, /* @__PURE__ */ react_default.createElement(list_default.ItemText, null, /* @__PURE__ */ react_default.createElement(
      "span",
      {
        className: "text-truncate-inline",
        "data-tooltip-align": "top",
        title: url
      },
      /* @__PURE__ */ react_default.createElement(
        "a",
        {
          className: "c-mr-2 text-primary text-truncate text-truncate-reverse",
          href: url,
          target: "_blank"
        },
        url
      )
    ))), /* @__PURE__ */ react_default.createElement(list_default.ItemField, { expand: true }, /* @__PURE__ */ react_default.createElement("span", { className: "align-self-end font-weight-semi-bold text-dark" }, numberFormat(
      languageTag,
      trafficAmount
    ))));
  })), referringPages.length > 5 && /* @__PURE__ */ react_default.createElement(
    button_default,
    {
      borderless: true,
      className: "c-mb-4",
      displayType: "secondary",
      onClick: () => setIsReferringPagesExpanded(!isReferringPagesExpanded),
      small: true
    },
    isReferringPagesExpanded ? /* @__PURE__ */ react_default.createElement("span", null, Liferay.Language.get("view-less")) : /* @__PURE__ */ react_default.createElement("span", null, Liferay.Language.get("view-more"))
  ), /* @__PURE__ */ react_default.createElement(list_default, { className: "list-group-pages-list" }, /* @__PURE__ */ react_default.createElement(list_default.Item, { flex: true }, /* @__PURE__ */ react_default.createElement(list_default.ItemField, { expand: true }, /* @__PURE__ */ react_default.createElement(list_default.ItemTitle, { className: "text-truncate-inline" }, /* @__PURE__ */ react_default.createElement("span", { className: "text-truncate" }, Liferay.Language.get("top-referring-domains"), /* @__PURE__ */ react_default.createElement("span", { className: "text-secondary" }, /* @__PURE__ */ react_default.createElement(
    Hint_default,
    {
      message: Liferay.Language.get(
        "top-referring-domains-help"
      ),
      title: Liferay.Language.get(
        "top-referring-domains"
      )
    }
  ))))), /* @__PURE__ */ react_default.createElement(list_default.ItemField, null, /* @__PURE__ */ react_default.createElement(list_default.ItemTitle, null, /* @__PURE__ */ react_default.createElement("span", null, Liferay.Language.get("traffic"))))), referringDomains.slice(0, isReferringDomainsExpanded ? 10 : ITEMS_TO_SHOW).map(({ trafficAmount, url }) => {
    return /* @__PURE__ */ react_default.createElement(list_default.Item, { flex: true, key: url }, /* @__PURE__ */ react_default.createElement(list_default.ItemField, { expand: true }, /* @__PURE__ */ react_default.createElement(list_default.ItemText, null, /* @__PURE__ */ react_default.createElement(
      "span",
      {
        className: "text-truncate-inline",
        "data-tooltip-align": "top",
        title: url
      },
      /* @__PURE__ */ react_default.createElement(
        "a",
        {
          className: "c-mr-2 text-primary text-truncate",
          href: url,
          target: "_blank"
        },
        url
      )
    ))), /* @__PURE__ */ react_default.createElement(list_default.ItemField, { expand: true }, /* @__PURE__ */ react_default.createElement("span", { className: "align-self-end font-weight-semi-bold text-dark" }, numberFormat(
      languageTag,
      trafficAmount
    ))));
  })), referringDomains.length > 5 && /* @__PURE__ */ react_default.createElement(
    button_default,
    {
      borderless: true,
      className: "c-mb-4",
      displayType: "secondary",
      onClick: () => setIsReferringDomainsExpanded(
        !isReferringDomainsExpanded
      ),
      small: true
    },
    isReferringDomainsExpanded ? /* @__PURE__ */ react_default.createElement("span", null, Liferay.Language.get("view-less")) : /* @__PURE__ */ react_default.createElement("span", null, Liferay.Language.get("view-more"))
  ));
}
ReferralDetail.propTypes = {
  currentPage: prop_types_default.object.isRequired,
  handleDetailPeriodChange: prop_types_default.func.isRequired,
  timeSpanOptions: prop_types_default.arrayOf(
    prop_types_default.shape({
      key: prop_types_default.string,
      label: prop_types_default.string
    })
  ).isRequired,
  trafficShareDataProvider: prop_types_default.func.isRequired,
  trafficSourcesDataProvider: prop_types_default.func.isRequired,
  trafficVolumeDataProvider: prop_types_default.func.isRequired
};

// src/main/resources/META-INF/resources/js/components/detail/SocialDetail.js
var SOCIAL_MEDIA_COLORS = {
  facebook: "#4B9BFF",
  instagram: "#FFB46E",
  linkedin: "#7785FF",
  others: "#6B6C7E",
  pinterest: "#50D2A0",
  snapchat: "#FFD76E",
  tiktok: "#FF73C3",
  twitter: "#5FC8FF",
  youtube: "#FF5F5F"
};
function SocialDetail({
  currentPage,
  handleDetailPeriodChange,
  timeSpanOptions,
  trafficShareDataProvider,
  trafficSourcesDataProvider,
  trafficVolumeDataProvider
}) {
  const { languageTag } = (0, react_exports.useContext)(StoreStateContext);
  const { referringSocialMedia } = currentPage.data;
  const dateFormatters = (0, react_exports.useMemo)(
    () => generateDateFormatters(languageTag),
    [languageTag]
  );
  const { firstDate, lastDate } = useDateTitle();
  const title = dateFormatters.formatChartTitle([firstDate, lastDate]);
  const dispatch = (0, react_exports.useContext)(StoreDispatchContext);
  const chartDispatch = (0, react_exports.useContext)(ChartDispatchContext);
  const { pieChartLoading, timeSpanKey, timeSpanOffset } = (0, react_exports.useContext)(ChartStateContext);
  const { validAnalyticsConnection } = (0, react_exports.useContext)(ConnectionContext_default);
  const isPreviousPeriodButtonDisabled = useIsPreviousPeriodButtonDisabled();
  const keyToHexColor2 = (name) => {
    return SOCIAL_MEDIA_COLORS[name] ?? "#666666";
  };
  const keyToWidth = (index) => {
    if (index === 0) {
      return "100%";
    }
    return `${referringSocialMedia[index].trafficAmount * 100 / referringSocialMedia[0].trafficAmount}%`;
  };
  const [highlighted, setHighlighted] = (0, react_exports.useState)(null);
  const firstUpdateRef = (0, react_exports.useRef)(true);
  const trafficSourceDetailClasses = classnames_default(
    "c-p-3 traffic-source-detail",
    {
      "traffic-source-detail--loading": pieChartLoading
    }
  );
  function handleLegendMouseEnter(name) {
    setHighlighted(name);
  }
  function handleLegendMouseLeave() {
    setHighlighted(null);
  }
  (0, react_exports.useEffect)(() => {
    if (firstUpdateRef.current) {
      firstUpdateRef.current = false;
      return;
    }
    if (validAnalyticsConnection) {
      chartDispatch({
        payload: {
          loading: true
        },
        type: "SET_PIE_CHART_LOADING"
      });
      trafficSourcesDataProvider().then((trafficSources) => {
        handleDetailPeriodChange(trafficSources, "social", true);
      }).catch(() => {
        dispatch({ type: "ADD_WARNING" });
      }).finally(() => {
        chartDispatch({
          payload: {
            loading: false
          },
          type: "SET_PIE_CHART_LOADING"
        });
      });
    }
  }, [
    chartDispatch,
    dispatch,
    handleDetailPeriodChange,
    timeSpanKey,
    timeSpanOffset,
    trafficSourcesDataProvider,
    validAnalyticsConnection
  ]);
  return /* @__PURE__ */ react_default.createElement("div", { className: trafficSourceDetailClasses }, pieChartLoading && /* @__PURE__ */ react_default.createElement(
    loading_indicator_default,
    {
      className: "chart-loading-indicator",
      small: true
    }
  ), /* @__PURE__ */ react_default.createElement("div", { className: "c-mb-3 c-mt-2" }, /* @__PURE__ */ react_default.createElement(
    TimeSpanSelector,
    {
      disabledNextTimeSpan: timeSpanOffset === 0,
      disabledPreviousPeriodButton: isPreviousPeriodButtonDisabled,
      timeSpanKey,
      timeSpanOptions
    }
  )), title && /* @__PURE__ */ react_default.createElement("h5", { className: "c-mb-4" }, title), /* @__PURE__ */ react_default.createElement(
    TotalCount_default,
    {
      className: "c-mb-2",
      dataProvider: trafficVolumeDataProvider,
      label: (0, frontend_js_web_exports.sub)(Liferay.Language.get("traffic-volume")),
      popoverHeader: Liferay.Language.get("traffic-volume"),
      popoverMessage: Liferay.Language.get(
        "traffic-volume-is-the-number-of-page-views-coming-from-one-channel"
      ),
      popoverPosition: "bottom"
    }
  ), /* @__PURE__ */ react_default.createElement(
    TotalCount_default,
    {
      className: "c-mb-3",
      dataProvider: trafficShareDataProvider,
      label: (0, frontend_js_web_exports.sub)(Liferay.Language.get("traffic-share")),
      percentage: true,
      popoverHeader: Liferay.Language.get("traffic-share"),
      popoverMessage: Liferay.Language.get(
        "traffic-share-is-the-percentage-of-traffic-sent-to-your-page-by-one-channel"
      )
    }
  ), /* @__PURE__ */ react_default.createElement(list_default, { className: "list-group-pages-list" }, /* @__PURE__ */ react_default.createElement(list_default.Item, { flex: true }, /* @__PURE__ */ react_default.createElement(list_default.ItemField, { expand: true }, /* @__PURE__ */ react_default.createElement(list_default.ItemTitle, { className: "text-truncate-inline" }, /* @__PURE__ */ react_default.createElement("span", { className: "text-truncate" }, Liferay.Language.get(
    "top-referring-social-media"
  )))), /* @__PURE__ */ react_default.createElement(list_default.ItemField, null, /* @__PURE__ */ react_default.createElement(list_default.ItemTitle, null, /* @__PURE__ */ react_default.createElement("span", null, Liferay.Language.get("traffic"))))), referringSocialMedia.map(
    ({ name, title: title2, trafficAmount }, index) => {
      const listItemClasses = classnames_default({
        dim: highlighted && name !== highlighted
      });
      return /* @__PURE__ */ react_default.createElement(
        list_default.Item,
        {
          className: listItemClasses,
          flex: true,
          key: title2,
          onMouseOut: handleLegendMouseLeave,
          onMouseOver: () => handleLegendMouseEnter(name)
        },
        /* @__PURE__ */ react_default.createElement(list_default.ItemField, { style: { width: "70px" } }, /* @__PURE__ */ react_default.createElement(list_default.ItemText, null, /* @__PURE__ */ react_default.createElement("span", { className: "c-mr-2 text-secondary" }, title2))),
        /* @__PURE__ */ react_default.createElement(
          list_default.ItemField,
          {
            className: "align-self-center",
            expand: true
          },
          /* @__PURE__ */ react_default.createElement(
            "div",
            {
              style: {
                backgroundColor: keyToHexColor2(name),
                height: "16px",
                width: keyToWidth(index)
              }
            }
          )
        ),
        /* @__PURE__ */ react_default.createElement(list_default.ItemField, { className: "align-self-center" }, /* @__PURE__ */ react_default.createElement("span", { className: "align-self-end c-ml-2 font-weight-semi-bold text-dark" }, numberFormat(
          languageTag,
          trafficAmount
        )))
      );
    }
  )));
}
SocialDetail.propTypes = {
  currentPage: prop_types_default.object.isRequired,
  handleDetailPeriodChange: prop_types_default.func.isRequired,
  timeSpanOptions: prop_types_default.arrayOf(
    prop_types_default.shape({
      key: prop_types_default.string,
      label: prop_types_default.string
    })
  ).isRequired,
  trafficShareDataProvider: prop_types_default.func.isRequired,
  trafficSourcesDataProvider: prop_types_default.func.isRequired,
  trafficVolumeDataProvider: prop_types_default.func.isRequired
};

// src/main/resources/META-INF/resources/js/components/detail/Detail.js
var TRAFFIC_CHANNELS = {
  DIRECT: "direct",
  ORGANIC: "organic",
  PAID: "paid",
  REFERRAL: "referral",
  SOCIAL: "social"
};
function Detail({
  currentPage,
  handleDetailPeriodChange,
  loadingData,
  onCurrentPageChange,
  onTrafficSourceNameChange,
  refProp,
  timeSpanOptions,
  trafficShareDataProvider,
  trafficSourcesDataProvider,
  trafficVolumeDataProvider
}) {
  const chartDispatch = (0, react_exports.useContext)(ChartDispatchContext);
  const storeDispatch = (0, react_exports.useContext)(StoreDispatchContext);
  const currentPageMocked = {
    data: {
      countrySearch: [
        {
          countryCode: "es",
          countryName: "Spain",
          views: 900,
          viewsP: 40
        },
        {
          countryCode: "br",
          countryName: "Brazil",
          views: 400,
          viewsP: 20
        },
        {
          countryCode: "us",
          countryName: "United States",
          views: 700,
          viewsP: 20
        },
        {
          countryCode: "ca",
          countryName: "Canada",
          views: 1e3,
          viewsP: 20
        },
        {
          countryCode: "me",
          countryName: "Mexico",
          views: 100,
          viewsP: 20
        },
        {
          countryCode: "fr",
          countryName: "France",
          views: 1700,
          viewsP: 20
        },
        {
          countryCode: "it",
          countryName: "Italy",
          views: 200,
          viewsP: 20
        }
      ]
    },
    view: "paid"
  };
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, loadingData ? /* @__PURE__ */ react_default.createElement(
    loading_indicator_default,
    {
      className: "chart-loading-indicator",
      small: true
    }
  ) : /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement("div", { className: "c-pt-3 c-px-3 d-flex", ref: refProp }, /* @__PURE__ */ react_default.createElement(
    button_default,
    {
      "aria-label": Liferay.Language.get("back"),
      displayType: "unstyled",
      onClick: () => {
        onCurrentPageChange({ view: "main" });
        onTrafficSourceNameChange("");
        chartDispatch({ type: "SET_LOADING" });
        storeDispatch({
          selectedTrafficSourceName: "",
          type: "SET_SELECTED_TRAFFIC_SOURCE_NAME"
        });
      },
      small: true
    },
    /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "angle-left-small" })
  ), /* @__PURE__ */ react_default.createElement("div", { className: "align-self-center flex-grow-1 mx-2" }, /* @__PURE__ */ react_default.createElement("strong", null, currentPage.data.title))), (currentPage.view === TRAFFIC_CHANNELS.ORGANIC || currentPage.view === TRAFFIC_CHANNELS.PAID) && !!currentPageMocked.data.countrySearch.length && /* @__PURE__ */ react_default.createElement(
    KeywordsDetail,
    {
      currentPage,
      trafficShareDataProvider,
      trafficVolumeDataProvider
    }
  ), currentPage.view === TRAFFIC_CHANNELS.REFERRAL && /* @__PURE__ */ react_default.createElement(
    ReferralDetail,
    {
      currentPage,
      handleDetailPeriodChange,
      timeSpanOptions,
      trafficShareDataProvider,
      trafficSourcesDataProvider,
      trafficVolumeDataProvider
    }
  ), currentPage.view === TRAFFIC_CHANNELS.SOCIAL && /* @__PURE__ */ react_default.createElement(
    SocialDetail,
    {
      currentPage,
      handleDetailPeriodChange,
      timeSpanOptions,
      trafficShareDataProvider,
      trafficSourcesDataProvider,
      trafficVolumeDataProvider
    }
  )));
}
Detail.propTypes = {
  currentPage: prop_types_default.object.isRequired,
  loadingData: prop_types_default.bool,
  onCurrentPageChange: prop_types_default.func.isRequired,
  onTrafficSourceNameChange: prop_types_default.func.isRequired,
  refProp: prop_types_default.oneOfType([
    prop_types_default.shape({ current: prop_types_default.instanceOf(Element) })
  ]),
  timeSpanOptions: prop_types_default.arrayOf(
    prop_types_default.shape({
      key: prop_types_default.string,
      label: prop_types_default.string
    })
  ).isRequired,
  trafficShareDataProvider: prop_types_default.func.isRequired,
  trafficSourcesDataProvider: prop_types_default.func.isRequired,
  trafficVolumeDataProvider: prop_types_default.func.isRequired
};

// src/main/resources/META-INF/resources/js/components/detail/Drawer.js
function Drawer({ children }) {
  return /* @__PURE__ */ react_default.createElement("section", { className: "traffic-source-detail-drawer" }, children);
}

// src/main/resources/META-INF/resources/js/components/Navigation.js
var noop = () => {
};
function Navigation({
  author,
  canonicalURL,
  onSelectedLanguageClick = noop,
  pagePublishDate,
  pageTitle,
  timeSpanOptions,
  viewURLs
}) {
  const { endpoints, namespace, page, publishedToday, warning } = (0, react_exports.useContext)(StoreStateContext);
  const { validAnalyticsConnection } = (0, react_exports.useContext)(ConnectionContext_default);
  const [currentPage, setCurrentPage] = (0, react_exports.useState)({ view: "main" });
  const [loadingDetailView, setLoadingDetailView] = (0, react_exports.useState)(false);
  const [trafficSources, setTrafficSources] = (0, react_exports.useState)([]);
  const [trafficSourceName, setTrafficSourceName] = (0, react_exports.useState)("");
  const { timeSpanKey, timeSpanOffset } = (0, react_exports.useContext)(ChartStateContext);
  const detailRef = (0, react_exports.useRef)(null);
  const handleCurrentPage = (0, react_exports.useCallback)((currentPage2) => {
    setCurrentPage({ view: currentPage2.view });
  }, []);
  const handleHistoricalReads = (0, react_exports.useCallback)(() => {
    return APIService_default.getHistoricalReads(
      endpoints.analyticsReportsHistoricalReadsURL,
      { namespace, plid: page.plid, timeSpanKey, timeSpanOffset }
    ).then((response) => response);
  }, [
    endpoints.analyticsReportsHistoricalReadsURL,
    namespace,
    page.plid,
    timeSpanKey,
    timeSpanOffset
  ]);
  const handleHistoricalViews = (0, react_exports.useCallback)(() => {
    return APIService_default.getHistoricalReads(
      endpoints.analyticsReportsHistoricalViewsURL,
      { namespace, plid: page.plid, timeSpanKey, timeSpanOffset }
    ).then((response) => response);
  }, [
    endpoints.analyticsReportsHistoricalViewsURL,
    namespace,
    page.plid,
    timeSpanKey,
    timeSpanOffset
  ]);
  const handleTotalReads = (0, react_exports.useCallback)(() => {
    return APIService_default.getTotalReads(
      endpoints.analyticsReportsTotalReadsURL,
      { namespace, plid: page.plid }
    ).then(({ analyticsReportsTotalReads }) => analyticsReportsTotalReads);
  }, [endpoints.analyticsReportsTotalReadsURL, namespace, page.plid]);
  const handleTotalViews = (0, react_exports.useCallback)(() => {
    return APIService_default.getTotalReads(
      endpoints.analyticsReportsTotalViewsURL,
      { namespace, plid: page.plid }
    ).then(({ analyticsReportsTotalViews }) => analyticsReportsTotalViews);
  }, [endpoints.analyticsReportsTotalViewsURL, namespace, page.plid]);
  const handleTrafficSources = (0, react_exports.useCallback)(() => {
    return APIService_default.getTrafficSources(
      endpoints.analyticsReportsTrafficSourcesURL,
      { namespace, plid: page.plid, timeSpanKey, timeSpanOffset }
    ).then(({ trafficSources: trafficSources2 }) => trafficSources2);
  }, [
    endpoints.analyticsReportsTrafficSourcesURL,
    namespace,
    page.plid,
    timeSpanKey,
    timeSpanOffset
  ]);
  const updateTrafficSourcesAndCurrentPage = (0, react_exports.useCallback)(
    (trafficSources2, trafficSourceName2, sameTrafficSource) => {
      setTrafficSources(trafficSources2);
      setTrafficSourceName(trafficSourceName2);
      const trafficSource = trafficSources2.find(
        (source) => source.name === trafficSourceName2
      );
      if (!sameTrafficSource) {
        setLoadingDetailView(true);
      }
      setCurrentPage({
        data: sameTrafficSource ? currentPage.data : null,
        view: trafficSourceName2
      });
      APIService_default.getTrafficSources(trafficSource.endpointURL, {
        namespace,
        plid: page.plid,
        timeSpanKey,
        timeSpanOffset
      }).then((response) => {
        response.title = trafficSource.title;
        setCurrentPage({
          data: response,
          view: trafficSourceName2
        });
        if (!sameTrafficSource) {
          setLoadingDetailView(false);
        }
      });
    },
    // eslint-disable-next-line react-hooks/exhaustive-deps
    [namespace, page.plid, timeSpanKey, timeSpanOffset]
  );
  const handleTrafficSourceName = (trafficSourceName2) => setTrafficSourceName(trafficSourceName2);
  const handleTrafficShare = (0, react_exports.useCallback)(() => {
    const trafficSource = trafficSources.find((trafficSource2) => {
      return trafficSource2.name === trafficSourceName;
    });
    return Promise.resolve(trafficSource?.share ?? "-");
  }, [trafficSourceName, trafficSources]);
  const handleTrafficVolume = (0, react_exports.useCallback)(() => {
    const trafficSource = trafficSources.find((trafficSource2) => {
      return trafficSource2.name === trafficSourceName;
    });
    return Promise.resolve(trafficSource?.value ?? "-");
  }, [trafficSourceName, trafficSources]);
  const showDetail = currentPage.view !== "main";
  (0, react_exports.useEffect)(() => {
    if (showDetail && !loadingDetailView) {
      detailRef.current.scrollIntoView();
    }
  }, [showDetail, loadingDetailView]);
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, !validAnalyticsConnection && /* @__PURE__ */ react_default.createElement(
    alert_default,
    {
      className: "mb-3",
      displayType: "danger",
      variant: "stripe"
    },
    Liferay.Language.get("an-unexpected-error-occurred")
  ), validAnalyticsConnection && warning && /* @__PURE__ */ react_default.createElement(
    alert_default,
    {
      className: "mb-3",
      displayType: "warning",
      variant: "stripe"
    },
    Liferay.Language.get(
      "some-data-is-temporarily-unavailable"
    )
  ), validAnalyticsConnection && publishedToday && !warning && /* @__PURE__ */ react_default.createElement(
    alert_default,
    {
      className: "mb-3",
      displayType: "info",
      title: Liferay.Language.get("no-data-is-available-yet"),
      variant: "stripe"
    },
    Liferay.Language.get("content-has-just-been-published")
  ), /* @__PURE__ */ react_default.createElement(
    Main,
    {
      author,
      canonicalURL,
      chartDataProviders: endpoints.analyticsReportsHistoricalReadsURL ? [handleHistoricalViews, handleHistoricalReads] : [handleHistoricalViews],
      className: classnames_default({
        "analytics-reports-app-main--hide": showDetail
      }),
      onSelectedLanguageClick,
      onTrafficSourceClick: updateTrafficSourcesAndCurrentPage,
      pagePublishDate,
      pageTitle,
      timeSpanOptions,
      totalReadsDataProvider: endpoints.analyticsReportsTotalReadsURL && handleTotalReads,
      totalViewsDataProvider: handleTotalViews,
      trafficSourcesDataProvider: handleTrafficSources,
      viewURLs
    }
  ), showDetail && /* @__PURE__ */ react_default.createElement(Drawer, null, /* @__PURE__ */ react_default.createElement(
    Detail,
    {
      currentPage,
      handleDetailPeriodChange: updateTrafficSourcesAndCurrentPage,
      loadingData: loadingDetailView,
      onCurrentPageChange: handleCurrentPage,
      onTrafficSourceNameChange: handleTrafficSourceName,
      refProp: detailRef,
      timeSpanOptions,
      trafficShareDataProvider: handleTrafficShare,
      trafficSourcesDataProvider: handleTrafficSources,
      trafficVolumeDataProvider: handleTrafficVolume
    }
  )));
}
Navigation.defaultProps = {
  author: null
};
Navigation.propTypes = {
  author: prop_types_default.object,
  canonicalURL: prop_types_default.string.isRequired,
  onSelectedLanguageClick: prop_types_default.func.isRequired,
  pagePublishDate: prop_types_default.string.isRequired,
  pageTitle: prop_types_default.string.isRequired,
  timeSpanOptions: prop_types_default.arrayOf(
    prop_types_default.shape({
      key: prop_types_default.string.isRequired,
      label: prop_types_default.string.isRequired
    })
  ).isRequired,
  viewURLs: prop_types_default.arrayOf(
    prop_types_default.shape({
      default: prop_types_default.bool.isRequired,
      languageId: prop_types_default.string.isRequired,
      languageLabel: prop_types_default.string.isRequired,
      selected: prop_types_default.bool.isRequired,
      viewURL: prop_types_default.string.isRequired
    })
  ).isRequired
};

// src/main/resources/META-INF/resources/css/analytics-reports-app.scss
var link = document.createElement("link");
link.setAttribute("rel", "stylesheet");
link.setAttribute("type", "text/css");
link.setAttribute(
  "href",
  Liferay.ThemeDisplay.getPathContext() + "/o/analytics-reports-web/css/analytics-reports-app.css"
);
document.querySelector("head").appendChild(link);

// src/main/resources/META-INF/resources/js/components/AnalyticsReports.js
function AnalyticsReports({
  analyticsReportsDataURL,
  hoverOrFocusEventTriggered,
  isPanelStateOpen
}) {
  const [state, dispatch] = useSafeReducer(dataReducer, initialState);
  const getData = (0, react_exports.useCallback)(
    (fetchURL, timeSpanKey, timeSpanOffset) => {
      dispatch({ type: "LOAD_DATA" });
      const body = !timeSpanOffset && !!timeSpanKey ? { timeSpanKey, timeSpanOffset } : {};
      APIService_default.getAnalyticsReportsData(fetchURL, body).then(
        (data2) => dispatch({
          data: data2.context,
          type: "SET_DATA"
        })
      ).catch(() => {
        dispatch({
          error: Liferay.Language.get(
            "an-unexpected-error-occurred"
          ),
          type: "SET_ERROR"
        });
      });
    },
    [dispatch]
  );
  (0, react_exports.useEffect)(() => {
    if (hoverOrFocusEventTriggered && !state.data) {
      getData(analyticsReportsDataURL);
    }
  }, [hoverOrFocusEventTriggered]);
  (0, react_exports.useEffect)(() => {
    if (isPanelStateOpen && !state.data && !state.loading) {
      getData(analyticsReportsDataURL);
    }
  }, [isPanelStateOpen]);
  const handleSelectedLanguageClick = (0, react_exports.useCallback)(
    (url, timeSpanKey, timeSpanOffset) => {
      getData(url, timeSpanKey, timeSpanOffset);
    },
    // eslint-disable-next-line react-hooks/exhaustive-deps
    []
  );
  const { data, error, loading } = state;
  return loading ? /* @__PURE__ */ react_default.createElement(loading_indicator_default, { small: true }) : error ? /* @__PURE__ */ react_default.createElement(alert_default, { displayType: "danger", variant: "stripe" }, error) : data && /* @__PURE__ */ react_default.createElement(
    ConnectionContext_default.Provider,
    {
      value: {
        validAnalyticsConnection: data?.analyticsData.hasValidConnection
      }
    },
    /* @__PURE__ */ react_default.createElement(
      StoreContextProvider,
      {
        value: {
          endpoints: { ...data?.endpoints },
          languageTag: data?.languageTag,
          namespace: data?.namespace,
          page: data?.page,
          publishedToday: data?.publishedToday
        }
      },
      /* @__PURE__ */ react_default.createElement(
        ChartStateContextProvider,
        {
          publishDate: data?.publishDate,
          timeRange: data?.timeRange,
          timeSpanKey: data?.timeSpanKey
        },
        data?.analyticsData.isSynced ? /* @__PURE__ */ react_default.createElement("div", { className: "analytics-reports-app" }, /* @__PURE__ */ react_default.createElement(
          Navigation,
          {
            author: data?.author,
            canonicalURL: data?.canonicalURL,
            onSelectedLanguageClick: handleSelectedLanguageClick,
            pagePublishDate: data?.publishDate,
            pageTitle: data?.title,
            timeSpanOptions: data?.timeSpans,
            viewURLs: data?.viewURLs
          }
        )) : /* @__PURE__ */ react_default.createElement(
          ConnectToAC,
          {
            analyticsCloudTrialURL: data?.analyticsData.cloudTrialURL,
            analyticsURL: data?.analyticsData.url,
            hideAnalyticsReportsPanelURL: data?.hideAnalyticsReportsPanelURL,
            isAnalyticsConnected: data?.analyticsData.hasValidConnection,
            pathToAssets: data?.pathToAssets
          }
        )
      )
    )
  );
}
AnalyticsReports.propTypes = {
  analyticsReportsDataURL: prop_types_default.string.isRequired,
  hoverOrFocusEventTriggered: prop_types_default.bool.isRequired,
  isPanelStateOpen: prop_types_default.bool.isRequired
};

// src/main/resources/META-INF/resources/css/main.scss
var link2 = document.createElement("link");
link2.setAttribute("rel", "stylesheet");
link2.setAttribute("type", "text/css");
link2.setAttribute(
  "href",
  Liferay.ThemeDisplay.getPathContext() + "/o/analytics-reports-web/css/main.css"
);
document.querySelector("head").appendChild(link2);

// src/main/resources/META-INF/resources/js/index.js
function AnalyticsReportsApp({ context, portletNamespace }) {
  const { analyticsReportsDataURL, isPanelStateOpen } = context;
  const [hoverOrFocusEventTriggered, setHoverOrFocusEventTriggered] = (0, react_exports.useState)(false);
  const analyticsReportsPanelToggle = document.getElementById(
    `${portletNamespace}analyticsReportsPanelToggleId`
  );
  (0, react_exports.useEffect)(() => {
    if (analyticsReportsPanelToggle) {
      const sidenavInstance = Liferay.SideNavigation.instance(
        analyticsReportsPanelToggle
      );
      sidenavInstance.on("open.lexicon.sidenav", () => {
        (0, frontend_js_web_exports.setSessionValue)(
          "com.liferay.analytics.reports.web_panelState",
          "open"
        );
      });
      sidenavInstance.on("closed.lexicon.sidenav", () => {
        (0, frontend_js_web_exports.setSessionValue)(
          "com.liferay.analytics.reports.web_panelState",
          "closed"
        );
      });
      Liferay.once("screenLoad", () => {
        Liferay.SideNavigation.destroy(analyticsReportsPanelToggle);
      });
    }
  }, [analyticsReportsPanelToggle, portletNamespace]);
  (0, frontend_js_react_web_exports.useEventListener)(
    "mouseenter",
    () => setHoverOrFocusEventTriggered(true),
    { once: true },
    analyticsReportsPanelToggle
  );
  (0, frontend_js_react_web_exports.useEventListener)(
    "focus",
    () => setHoverOrFocusEventTriggered(true),
    { once: true },
    analyticsReportsPanelToggle
  );
  const visualizingAPage = analyticsReportsPanelToggle;
  return /* @__PURE__ */ react_default.createElement("div", { id: `${portletNamespace}-analytics-reports-root` }, /* @__PURE__ */ react_default.createElement(
    AnalyticsReports,
    {
      analyticsReportsDataURL,
      hoverOrFocusEventTriggered,
      isPanelStateOpen: visualizingAPage ? isPanelStateOpen : true
    }
  ));
}
AnalyticsReportsApp.propTypes = {
  context: prop_types_default.shape({
    analyticsReportsDataURL: prop_types_default.string.isRequired,
    isPanelStateOpen: prop_types_default.bool.isRequired
  }).isRequired,
  portletNamespace: prop_types_default.string.isRequired
};
export {
  AnalyticsReportsApp
};
//# sourceMappingURL=index.js.map
