"use strict";

Liferay.Loader.define("analytics-reports-web$dom-helpers@3.4.0/style/index", ['module', 'exports', 'require', '@analytics-reports-web$babel/runtime/helpers/interopRequireDefault', '../util/camelizeStyle', '../util/hyphenateStyle', './getComputedStyle', './removeStyle', '../transition/properties', '../transition/isTransform'], function (module, exports, require) {
  var define = undefined;
  var _interopRequireDefault = require("@analytics-reports-web$babel/runtime/helpers/interopRequireDefault");

  exports.__esModule = true;
  exports.default = style;

  var _camelizeStyle = _interopRequireDefault(require("../util/camelizeStyle"));

  var _hyphenateStyle = _interopRequireDefault(require("../util/hyphenateStyle"));

  var _getComputedStyle2 = _interopRequireDefault(require("./getComputedStyle"));

  var _removeStyle = _interopRequireDefault(require("./removeStyle"));

  var _properties = require("../transition/properties");

  var _isTransform = _interopRequireDefault(require("../transition/isTransform"));

  function style(node, property, value) {
    var css = '';
    var transforms = '';
    var props = property;

    if (typeof property === 'string') {
      if (value === undefined) {
        return node.style[(0, _camelizeStyle.default)(property)] || (0, _getComputedStyle2.default)(node).getPropertyValue((0, _hyphenateStyle.default)(property));
      } else {
        (props = {})[property] = value;
      }
    }

    Object.keys(props).forEach(function (key) {
      var value = props[key];

      if (!value && value !== 0) {
        (0, _removeStyle.default)(node, (0, _hyphenateStyle.default)(key));
      } else if ((0, _isTransform.default)(key)) {
        transforms += key + "(" + value + ") ";
      } else {
        css += (0, _hyphenateStyle.default)(key) + ": " + value + ";";
      }
    });

    if (transforms) {
      css += _properties.transform + ": " + transforms + ";";
    }

    node.style.cssText += ';' + css;
  }

  module.exports = exports["default"];
});
//# sourceMappingURL=index.js.map