"use strict";

Liferay.Loader.define("analytics-reports-web$dom-helpers@3.4.0/query/offset", ['module', 'exports', 'require', '@analytics-reports-web$babel/runtime/helpers/interopRequireDefault', './contains', './isWindow', '../ownerDocument'], function (module, exports, require) {
  var define = undefined;
  var _interopRequireDefault = require("@analytics-reports-web$babel/runtime/helpers/interopRequireDefault");

  exports.__esModule = true;
  exports.default = offset;

  var _contains = _interopRequireDefault(require("./contains"));

  var _isWindow = _interopRequireDefault(require("./isWindow"));

  var _ownerDocument = _interopRequireDefault(require("../ownerDocument"));

  function offset(node) {
    var doc = (0, _ownerDocument.default)(node),
        win = (0, _isWindow.default)(doc),
        docElem = doc && doc.documentElement,
        box = {
      top: 0,
      left: 0,
      height: 0,
      width: 0
    };
    if (!doc) return; // Make sure it's not a disconnected DOM node

    if (!(0, _contains.default)(docElem, node)) return box;
    if (node.getBoundingClientRect !== undefined) box = node.getBoundingClientRect(); // IE8 getBoundingClientRect doesn't support width & height

    box = {
      top: box.top + (win.pageYOffset || docElem.scrollTop) - (docElem.clientTop || 0),
      left: box.left + (win.pageXOffset || docElem.scrollLeft) - (docElem.clientLeft || 0),
      width: (box.width == null ? node.offsetWidth : box.width) || 0,
      height: (box.height == null ? node.offsetHeight : box.height) || 0
    };
    return box;
  }

  module.exports = exports["default"];
});
//# sourceMappingURL=offset.js.map