Liferay.Loader.define('analytics-reports-web$core-js@2.6.11/modules/_math-fround', ['module', 'exports', 'require', './_math-sign'], function (module, exports, require) {
  var define = undefined;
  // 20.2.2.16 Math.fround(x)
  var sign = require('./_math-sign');
  var pow = Math.pow;
  var EPSILON = pow(2, -52);
  var EPSILON32 = pow(2, -23);
  var MAX32 = pow(2, 127) * (2 - EPSILON32);
  var MIN32 = pow(2, -126);

  var roundTiesToEven = function (n) {
    return n + 1 / EPSILON - 1 / EPSILON;
  };

  module.exports = Math.fround || function fround(x) {
    var $abs = Math.abs(x);
    var $sign = sign(x);
    var a, result;
    if ($abs < MIN32) return $sign * roundTiesToEven($abs / MIN32 / EPSILON32) * MIN32 * EPSILON32;
    a = (1 + EPSILON32 / EPSILON) * $abs;
    result = a - (a - $abs);
    // eslint-disable-next-line no-self-compare
    if (result > MAX32 || result != result) return $sign * Infinity;
    return $sign * result;
  };
});
//# sourceMappingURL=_math-fround.js.map