Liferay.Loader.define("analytics-reports-web@1.0.8/js/components/TrafficSources", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', 'frontend-js-recharts$recharts', '../context/store', '../utils/numberFormat', './EmptyPieChart', './Hint'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = TrafficSources;

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _recharts = require("frontend-js-recharts$recharts");

  var _store = require("../context/store");

  var _numberFormat = require("../utils/numberFormat");

  var _EmptyPieChart = _interopRequireDefault(require("./EmptyPieChart"));

  var _Hint = _interopRequireDefault(require("./Hint"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var COLORS_MAP = {
    organic: '#7785FF',
    paid: '#FFB46E'
  };
  var PIE_CHART_SIZES = {
    height: 80,
    innerRadius: 25,
    paddingAngle: 1,
    radius: 40,
    width: 100
  };
  /**
   * Used when the traffic source name is not within the COLORS_MAP
   */

  var FALLBACK_COLOR = '#e92563';

  var getColorByName = function getColorByName(name) {
    return COLORS_MAP[name] || FALLBACK_COLOR;
  };

  function TrafficSources(_ref) {
    var languageTag = _ref.languageTag,
        onTrafficSourceClick = _ref.onTrafficSourceClick,
        trafficSources = _ref.trafficSources;

    var _useState = (0, _react.useState)(null),
        _useState2 = _slicedToArray(_useState, 2),
        highlighted = _useState2[0],
        setHighlighted = _useState2[1];

    var _useWarning = (0, _store.useWarning)(),
        _useWarning2 = _slicedToArray(_useWarning, 2),
        addWarning = _useWarning2[1];

    var _useContext = (0, _react.useContext)(_store.StoreContext),
        _useContext2 = _slicedToArray(_useContext, 1),
        publishedToday = _useContext2[0].publishedToday;

    var fullPieChart = trafficSources.some(function (source) {
      return !!source.value;
    });
    var missingTrafficSourceValue = trafficSources.some(function (trafficSource) {
      return trafficSource.value === undefined;
    });
    (0, _react.useEffect)(function () {
      if (missingTrafficSourceValue) {
        addWarning();
      }
    }, [addWarning, missingTrafficSourceValue]);

    function handleLegendMouseEnter(name) {
      setHighlighted(name);
    }

    function handleLegendMouseLeave() {
      setHighlighted(null);
    }

    return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement("h5", {
      className: "mt-3 sheet-subtitle"
    }, Liferay.Language.get('search-engines-traffic'), _react["default"].createElement(_Hint["default"], {
      message: Liferay.Language.get('search-engines-traffic-help'),
      secondary: true,
      title: Liferay.Language.get('search-engines-traffic')
    })), !fullPieChart && !missingTrafficSourceValue && _react["default"].createElement("div", {
      className: "mb-3 text-secondary"
    }, Liferay.Language.get('your-page-has-no-incoming-traffic-from-search-engines-yet')), _react["default"].createElement("div", {
      className: "pie-chart-wrapper"
    }, _react["default"].createElement("div", {
      className: "pie-chart-wrapper--legend"
    }, _react["default"].createElement("table", null, _react["default"].createElement("tbody", null, trafficSources.map(function (entry) {
      return _react["default"].createElement("tr", {
        key: entry.name
      }, _react["default"].createElement("td", {
        className: "px-0",
        onMouseOut: handleLegendMouseLeave,
        onMouseOver: function onMouseOver() {
          return handleLegendMouseEnter(entry.name);
        }
      }, _react["default"].createElement("span", {
        className: "pie-chart-wrapper--legend--dot",
        style: {
          backgroundColor: getColorByName(entry.name)
        }
      })), _react["default"].createElement("td", {
        className: "pie-chart-wrapper--legend--title text-secondary",
        onMouseOut: handleLegendMouseLeave,
        onMouseOver: function onMouseOver() {
          return handleLegendMouseEnter(entry.name);
        }
      }, entry.value > 0 ? _react["default"].createElement(_button["default"], {
        className: "font-weight-semi-bold px-0 py-1 text-primary",
        displayType: "link",
        onClick: function onClick() {
          return onTrafficSourceClick(entry.name);
        },
        small: true
      }, entry.title) : _react["default"].createElement("span", null, entry.title)), _react["default"].createElement("td", {
        className: "text-secondary"
      }, _react["default"].createElement(_Hint["default"], {
        message: entry.helpMessage,
        title: entry.title
      })), _react["default"].createElement("td", {
        className: "font-weight-bold"
      }, entry.value !== undefined && !publishedToday ? (0, _numberFormat.numberFormat)(languageTag, entry.value) : '-'));
    })))), !fullPieChart && _react["default"].createElement(_EmptyPieChart["default"], {
      height: PIE_CHART_SIZES.height,
      innerRadius: PIE_CHART_SIZES.innerRadius,
      radius: PIE_CHART_SIZES.radius,
      width: PIE_CHART_SIZES.width
    }), fullPieChart && _react["default"].createElement("div", {
      className: "pie-chart-wrapper--chart"
    }, _react["default"].createElement(_recharts.PieChart, {
      height: PIE_CHART_SIZES.height,
      width: PIE_CHART_SIZES.width
    }, _react["default"].createElement(_recharts.Pie, {
      cx: "50%",
      cy: "50%",
      data: trafficSources,
      dataKey: "value",
      innerRadius: PIE_CHART_SIZES.innerRadius,
      nameKey: 'name',
      outerRadius: PIE_CHART_SIZES.radius,
      paddingAngle: PIE_CHART_SIZES.paddingAngle
    }, trafficSources.map(function (entry, i) {
      var fillColor = getColorByName(entry.name);
      var cellClasses = (0, _classnames["default"])({
        dim: highlighted && entry.name !== highlighted
      });
      return _react["default"].createElement(_recharts.Cell, {
        className: cellClasses,
        fill: fillColor,
        key: i,
        onMouseOut: handleLegendMouseLeave,
        onMouseOver: function onMouseOver() {
          return handleLegendMouseEnter(entry.name);
        }
      });
    })), _react["default"].createElement(_recharts.Tooltip, {
      animationDuration: 0,
      content: _react["default"].createElement(TrafficSourcesCustomTooltip, null),
      formatter: function formatter(value, name, iconType) {
        return [(0, _numberFormat.numberFormat)(languageTag, value), name, iconType];
      },
      separator: ': '
    })))));
  }

  function TrafficSourcesCustomTooltip(props) {
    var formatter = props.formatter,
        payload = props.payload,
        _props$separator = props.separator,
        separator = _props$separator === void 0 ? '' : _props$separator;
    return _react["default"].createElement("div", {
      className: "custom-tooltip"
    }, _react["default"].createElement("p", {
      className: "mb-1 mt-0"
    }, _react["default"].createElement("b", null, payload.length && payload[0].payload.title)), _react["default"].createElement("ul", {
      className: "list-unstyled mb-0"
    }, _react["default"].createElement(_react["default"].Fragment, null, payload.map(function (item) {
      // eslint-disable-next-line no-unused-vars
      var _ref2 = formatter ? formatter(item.value, item.name, item.iconType) : [item.value, item.name, item.iconType],
          _ref3 = _slicedToArray(_ref2, 3),
          value = _ref3[0],
          _name = _ref3[1],
          iconType = _ref3[2];

      var payload = item.payload;
      return _react["default"].createElement(_react["default"].Fragment, {
        key: item.name
      }, _react["default"].createElement("li", null, Liferay.Language.get('visitors'), separator, _react["default"].createElement("b", null, value)), _react["default"].createElement("li", null, Liferay.Language.get('traffic-share'), separator, _react["default"].createElement("b", null, "".concat(payload.share, "%"))));
    }))));
  }
  //# sourceMappingURL=TrafficSources.js.map
});
//# sourceMappingURL=TrafficSources.js.map