Liferay.Loader.define("analytics-reports-web@1.0.8/js/components/Main", ['module', 'exports', 'require', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './BasicInformation', './Chart', './TotalCount', './TrafficSources'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = Main;

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _BasicInformation = _interopRequireDefault(require("./BasicInformation"));

  var _Chart = _interopRequireDefault(require("./Chart"));

  var _TotalCount = _interopRequireDefault(require("./TotalCount"));

  var _TrafficSources = _interopRequireDefault(require("./TrafficSources"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * The contents of this file are subject to the terms of the Liferay Enterprise
   * Subscription License ("License"). You may not use this file except in
   * compliance with the License. You can obtain a copy of the License by
   * contacting Liferay, Inc. See the License for the specific language governing
   * permissions and limitations under the License, including but not limited to
   * distribution rights of the Software.
   */
  function Main(_ref) {
    var authorName = _ref.authorName,
        authorPortraitURL = _ref.authorPortraitURL,
        authorUserId = _ref.authorUserId,
        chartDataProviders = _ref.chartDataProviders,
        defaultTimeRange = _ref.defaultTimeRange,
        defaultTimeSpanOption = _ref.defaultTimeSpanOption,
        languageTag = _ref.languageTag,
        onTrafficSourceClick = _ref.onTrafficSourceClick,
        pagePublishDate = _ref.pagePublishDate,
        pageTitle = _ref.pageTitle,
        timeSpanOptions = _ref.timeSpanOptions,
        totalReadsDataProvider = _ref.totalReadsDataProvider,
        totalViewsDataProvider = _ref.totalViewsDataProvider,
        trafficSources = _ref.trafficSources;
    return _react["default"].createElement("div", {
      className: "c-p-3"
    }, _react["default"].createElement(_BasicInformation["default"], {
      authorName: authorName,
      authorPortraitURL: authorPortraitURL,
      authorUserId: authorUserId,
      languageTag: languageTag,
      publishDate: pagePublishDate,
      title: pageTitle
    }), _react["default"].createElement("h5", {
      className: "mt-3 sheet-subtitle"
    }, Liferay.Language.get('engagement')), _react["default"].createElement(_TotalCount["default"], {
      className: "mb-2",
      dataProvider: totalViewsDataProvider,
      label: Liferay.Util.sub(Liferay.Language.get('total-views')),
      languageTag: languageTag,
      popoverHeader: Liferay.Language.get('total-views'),
      popoverMessage: Liferay.Language.get('this-number-refers-to-the-total-number-of-views-since-the-content-was-published')
    }), _react["default"].createElement(_TotalCount["default"], {
      dataProvider: totalReadsDataProvider,
      label: Liferay.Util.sub(Liferay.Language.get('total-reads')),
      languageTag: languageTag,
      popoverHeader: Liferay.Language.get('total-reads'),
      popoverMessage: Liferay.Language.get('this-number-refers-to-the-total-number-of-reads-since-the-content-was-published')
    }), _react["default"].createElement(_Chart["default"], {
      dataProviders: chartDataProviders,
      defaultTimeRange: defaultTimeRange,
      defaultTimeSpanOption: defaultTimeSpanOption,
      languageTag: languageTag,
      publishDate: pagePublishDate,
      timeSpanOptions: timeSpanOptions
    }), trafficSources.length > 0 && _react["default"].createElement(_TrafficSources["default"], {
      languageTag: languageTag,
      onTrafficSourceClick: onTrafficSourceClick,
      trafficSources: trafficSources
    }));
  }

  Main.proptypes = {
    authorName: _propTypes["default"].string.isRequired,
    authorPortraitURL: _propTypes["default"].string.isRequired,
    authorUserId: _propTypes["default"].string.isRequired,
    chartDataProviders: _propTypes["default"].arrayOf(_propTypes["default"].func.isRequired).isRequired,
    defaultTimeRange: _propTypes["default"].object.isRequired,
    defaultTimeSpanOption: _propTypes["default"].string.isRequired,
    languageTag: _propTypes["default"].string.isRequired,
    onTrafficSourceClick: _propTypes["default"].func.isRequired,
    pagePublishDate: _propTypes["default"].number.isRequired,
    pageTitle: _propTypes["default"].string.isRequired,
    timeSpanOptions: _propTypes["default"].arrayOf(_propTypes["default"].shape({
      key: _propTypes["default"].string,
      label: _propTypes["default"].string
    })).isRequired,
    totalReadsDataProvider: _propTypes["default"].func.isRequired,
    totalViewsDataProvider: _propTypes["default"].func.isRequired,
    trafficSources: _propTypes["default"].array.isRequired
  };
  //# sourceMappingURL=Main.js.map
});
//# sourceMappingURL=Main.js.map